/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.cbor.internal.EncodingKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u0002H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\nH\u0002\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"flatten", "", "", "normalizeBaseBits", "", "floatFromHalfBits", "", "bits", "", "getElementNameForCborLabel", "", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "label", "", "getElementIndexOrThrow", "name", "kotlinx-serialization-cbor"})
@SourceDebugExtension(value={"SMAP\nDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Decoder.kt\nkotlinx/serialization/cbor/internal/DecoderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,619:1\n1#2:620\n295#3,2:621\n*S KotlinDebug\n*F\n+ 1 Decoder.kt\nkotlinx/serialization/cbor/internal/DecoderKt\n*L\n605#1:621,2\n*E\n"})
public final class DecoderKt {
    private static final int normalizeBaseBits = Float.floatToIntBits(0.5f);

    /*
     * WARNING - void declaration
     */
    private static final byte[] flatten(Iterable<byte[]> $this$flatten) {
        Iterable<byte[]> iterable = $this$flatten;
        int n = 0;
        Iterator<byte[]> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            void it;
            byte[] byArray;
            byte[] byArray2 = byArray = iterator.next();
            int n2 = n;
            boolean bl = false;
            int n3 = ((void)it).length;
            n = n2 + n3;
        }
        byte[] output = new byte[n];
        int position = 0;
        for (byte[] chunk : $this$flatten) {
            ArraysKt.copyInto$default((byte[])chunk, (byte[])output, (int)position, (int)0, (int)0, (int)12, null);
            position += chunk.length;
        }
        return output;
    }

    private static final float floatFromHalfBits(short bits) {
        short intBits = bits;
        boolean negative = (intBits & 0x8000) != 0;
        int halfExp = intBits >> 10 & 0x1F;
        int halfMant = intBits & 0x3FF;
        int exp = 0;
        int mant = 0;
        switch (halfExp) {
            case 31: {
                exp = 255;
                mant = halfMant;
                break;
            }
            case 0: {
                if (halfMant == 0) {
                    mant = 0;
                    exp = 0;
                    break;
                }
                float res = Float.intBitsToFloat(normalizeBaseBits + halfMant);
                return negative ? -res : (res -= 0.5f);
            }
            default: {
                exp = halfExp + 112;
                mant = halfMant;
            }
        }
        float res = Float.intBitsToFloat(exp << 23 | mant << 13);
        return negative ? -res : res;
    }

    private static final String getElementNameForCborLabel(SerialDescriptor $this$getElementNameForCborLabel, long label) {
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = SerialDescriptorKt.getElementNames((SerialDescriptor)$this$getElementNameForCborLabel);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Long l = EncodingKt.getCborLabel($this$getElementNameForCborLabel, $this$getElementNameForCborLabel.getElementIndex(it));
                long l2 = label;
                if (!(l != null && l == l2)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final int getElementIndexOrThrow(SerialDescriptor $this$getElementIndexOrThrow, String name) {
        int index = $this$getElementIndexOrThrow.getElementIndex(name);
        if (index == -3) {
            throw new SerializationException($this$getElementIndexOrThrow.getSerialName() + " does not contain element with name '" + name + ". You can enable 'CborBuilder.ignoreUnknownKeys' property to ignore unknown keys");
        }
        return index;
    }

    public static final /* synthetic */ int access$getElementIndexOrThrow(SerialDescriptor $receiver, String name) {
        return DecoderKt.getElementIndexOrThrow($receiver, name);
    }

    public static final /* synthetic */ String access$getElementNameForCborLabel(SerialDescriptor $receiver, long label) {
        return DecoderKt.getElementNameForCborLabel($receiver, label);
    }

    public static final /* synthetic */ float access$floatFromHalfBits(short bits) {
        return DecoderKt.floatFromHalfBits(bits);
    }

    public static final /* synthetic */ byte[] access$flatten(Iterable $receiver) {
        return DecoderKt.flatten($receiver);
    }
}

