/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.python.django.lang.template.inspection.DjangoInspectionVisitor;
import com.intellij.python.django.lang.template.inspection.DjangoTemplateLocalInspectionTool;
import com.jetbrains.django.ui.DjangoBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class DjangoBrokenLineCommentInspection
extends DjangoTemplateLocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "DjangoBrokenLineCommentInspection";
    }

    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new DjangoTagVisitor(manager);
    }

    private static final class DjangoTagVisitor
    extends PsiRecursiveElementVisitor
    implements DjangoInspectionVisitor {
        private final List<ProblemDescriptor> myProblems = new ArrayList<ProblemDescriptor>();
        private final InspectionManager myManager;

        private DjangoTagVisitor(InspectionManager manager) {
            this.myManager = manager;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                DjangoTagVisitor.$$$reportNull$$$0(0);
            }
            if (element.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_COMMENT_START_WITHOUT_END) {
                this.reportProblem(element, DjangoBundle.message((String)"django.start.comment.without.ending", (Object[])new Object[0]));
            }
            if (element.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_COMMENT_END_WITHOUT_START) {
                this.reportProblem(element, DjangoBundle.message((String)"django.end.comment.without.starting", (Object[])new Object[0]));
            }
            super.visitElement(element);
        }

        private void reportProblem(PsiElement elem, @Nls String msg) {
            ProblemDescriptor d = this.myManager.createProblemDescriptor(elem, new TextRange(0, elem.getTextLength()), msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
            this.myProblems.add(d);
        }

        @Override
        public void postprocess() {
        }

        @Override
        public List<ProblemDescriptor> getProblems() {
            return this.myProblems;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/python/django/lang/template/inspection/DjangoBrokenLineCommentInspection$DjangoTagVisitor", "visitElement"));
        }
    }
}

