/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.manage;

import com.intellij.commandInterface.command.SimpleCommand;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.OutputListener;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.django.manage.DjangoCommandsInfo;
import com.intellij.python.django.manage.DjangoManageTask;
import com.intellij.python.django.manage.FailedToProvideCommandsException;
import com.intellij.python.django.manage.ProcessHandlerWaiter;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.XStreamTools;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.extensions.RegistryValueExtKt;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.StreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RealCommandsProvider {
    private static final int COMMANDS_OBTAIN_TIMEOUT_SECONDS = Registry.intValue((String)"python.django.timeout", (int)10);
    private static final Pattern EXPECTED_DOCUMENT = Pattern.compile(".*(<\\?xml version=\"1.0\".*?\\?><!--jb pycharm data start-->.+$)", 32);
    private static final Logger LOGGER = Logger.getInstance(RealCommandsProvider.class);

    private RealCommandsProvider() {
    }

    @NotNull
    private static String runExternalProcess(@NotNull Module module, @NotNull Consumer<String> errorConsumer, @NotNull ProgressIndicator indicator) throws FailedToProvideCommandsException {
        String string;
        if (module == null) {
            RealCommandsProvider.$$$reportNull$$$0(0);
        }
        if (errorConsumer == null) {
            RealCommandsProvider.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            RealCommandsProvider.$$$reportNull$$$0(2);
        }
        StringBuilder stdout = new StringBuilder();
        StringBuilder stderr = new StringBuilder();
        String moduleName = module.getName();
        int commandsObtainTimeout = COMMANDS_OBTAIN_TIMEOUT_SECONDS * (ApplicationManager.getApplication().isUnitTestMode() ? 10 : 1);
        try {
            DjangoManageTask task = new DjangoManageTask(module, "");
            task.setHelper((HelperPackage)PythonHelper.MANAGE_TASKS_PROVIDER);
            DjangoFacet facet = DjangoFacet.getInstance((Module)module);
            if (facet == null) {
                return "No Django facet configured";
            }
            List commandsToSkip = RegistryValueExtKt.asList((RegistryValue)Registry.get((String)"python.django.commandsToSkip"));
            task.setParameters(Collections.singletonList(StringUtil.join((Collection)commandsToSkip, (String)",")));
            ProcessHandler processHandler = task.createProcess();
            processHandler.addProcessListener((ProcessListener)new OutputListenerWithFakeIndicator(stdout, stderr, indicator));
            processHandler.startNotify();
            int errorCode = ProcessHandlerWaiter.create(processHandler).waitForExit(commandsObtainTimeout);
            String error = stderr.toString();
            if (errorCode != 0) {
                String out = String.format("%s\n%s", error, stdout);
                throw new FailedToProvideCommandsException(DjangoBundle.message((String)"django.manage.real_commands.fail.died", (Object[])new Object[]{moduleName, errorCode, out}));
            }
            if (!error.trim().isEmpty()) {
                Logger.getInstance(RealCommandsProvider.class).info(error);
                errorConsumer.accept(error);
            }
            string = stdout.toString();
        }
        catch (ProcessHandlerWaiter.TimeoutException e) {
            throw new FailedToProvideCommandsException(DjangoBundle.message((String)"django.manage.timeout", (Object[])new Object[]{commandsObtainTimeout}), e);
        }
        catch (ExecutionException e) {
            throw new FailedToProvideCommandsException(DjangoBundle.message((String)"django.manage.real_commands.fail.cant_execute", (Object[])new Object[]{moduleName, e.getMessage()}), e);
        }
        catch (InterruptedException e) {
            throw new FailedToProvideCommandsException(DjangoBundle.message((String)"django.manage.real_commands.fail.died", (Object[])new Object[]{moduleName, 0, e.getMessage()}), e);
        }
        if (string == null) {
            RealCommandsProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    static List<SimpleCommand> getCommands(final @NotNull Module module, final @NotNull Consumer<String> errorConsumer) throws FailedToProvideCommandsException {
        ArrayList<SimpleCommand> arrayList;
        if (module == null) {
            RealCommandsProvider.$$$reportNull$$$0(4);
        }
        if (errorConsumer == null) {
            RealCommandsProvider.$$$reportNull$$$0(5);
        }
        final Ref processError = new Ref();
        final Ref processResult = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(module.getProject(), DjangoBundle.message((String)"django.manage.real_commands.modal_title", (Object[])new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    processResult.set((Object)RealCommandsProvider.runExternalProcess(module, errorConsumer, indicator));
                }
                catch (FailedToProvideCommandsException e) {
                    processError.set((Object)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/python/django/manage/RealCommandsProvider$1", "run"));
            }
        });
        if (!processError.isNull()) {
            Throwable throwable = (Throwable)processError.get();
            if (throwable instanceof FailedToProvideCommandsException) {
                throw (FailedToProvideCommandsException)throwable;
            }
            throw new FailedToProvideCommandsException(DjangoBundle.message((String)"django.manage.real_commands.fail.died", (Object[])new Object[]{module.getName(), 0, throwable.getMessage()}), throwable);
        }
        String data = (String)processResult.get();
        XStream stream = XStreamTools.createWithRootClass(DjangoCommandsInfo.class, (String)"commandInfo");
        stream.autodetectAnnotations(true);
        try {
            Matcher matcher = EXPECTED_DOCUMENT.matcher(data);
            if (!matcher.matches()) {
                throw RealCommandsProvider.reportFormatError(null, data);
            }
            Object unserializedResult = stream.fromXML(matcher.group(1));
            assert (unserializedResult instanceof DjangoCommandsInfo[]) : "Junk after serialization: " + String.valueOf(unserializedResult);
            ArrayList<SimpleCommand> result = new ArrayList<SimpleCommand>();
            for (DjangoCommandsInfo commandsInfo : (DjangoCommandsInfo[])unserializedResult) {
                result.add(commandsInfo.getCommand());
            }
            arrayList = result;
        }
        catch (StreamException exception) {
            throw RealCommandsProvider.reportFormatError((Exception)((Object)exception), data);
        }
        if (arrayList == null) {
            RealCommandsProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static FailedToProvideCommandsException reportFormatError(@Nullable Exception exception, @NotNull String data) {
        if (data == null) {
            RealCommandsProvider.$$$reportNull$$$0(7);
        }
        LOGGER.warn(String.format("Unexpected format: %s", data), (Throwable)exception);
        return new FailedToProvideCommandsException(DjangoBundle.message((String)"django.manage.bad_commands_out", (Object[])new Object[0]), exception);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/manage/RealCommandsProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/manage/RealCommandsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runExternalProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runExternalProcess";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCommands";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reportFormatError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }

    private static final class OutputListenerWithFakeIndicator
    extends OutputListener {
        private static final double FAKE_FRACTION_STEP = 0.1;
        @NotNull
        private final ProgressIndicator myIndicator;
        private double myFakeFraction;

        private OutputListenerWithFakeIndicator(@NotNull StringBuilder out, @NotNull StringBuilder err, @NotNull ProgressIndicator indicator) {
            if (out == null) {
                OutputListenerWithFakeIndicator.$$$reportNull$$$0(0);
            }
            if (err == null) {
                OutputListenerWithFakeIndicator.$$$reportNull$$$0(1);
            }
            if (indicator == null) {
                OutputListenerWithFakeIndicator.$$$reportNull$$$0(2);
            }
            super(out, err);
            this.myIndicator = indicator;
            this.myIndicator.setIndeterminate(false);
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                OutputListenerWithFakeIndicator.$$$reportNull$$$0(3);
            }
            if (outputType == null) {
                OutputListenerWithFakeIndicator.$$$reportNull$$$0(4);
            }
            super.onTextAvailable(event, outputType);
            if (this.myFakeFraction < 1.0) {
                this.myIndicator.setFraction(this.myFakeFraction += 0.1);
            } else {
                this.myIndicator.setIndeterminate(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "err";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/python/django/manage/RealCommandsProvider$OutputListenerWithFakeIndicator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

