/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.editor.DataGridColors;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.GridCellEditorTextField;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParsePosition;
import java.util.EventObject;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatBasedGridCellEditor
extends GridCellEditor.Adapter
implements GridCellEditor.EditorBased {
    private final Formatter myFormat;
    private final GridCellEditorFactory.ValueParser myValueParser;
    protected final ModelIndex<GridColumn> myColumn;
    protected final ModelIndex<GridRow> myRow;
    private final ReservedCellValue myNullValue;
    private final GridCellEditorTextField myTextField;
    private final DataGrid myGrid;

    public FormatBasedGridCellEditor(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @NotNull ModelIndex<GridColumn> column, @NotNull ModelIndex<GridRow> row, @Nullable ReservedCellValue nullValue, @Nullable EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter, boolean multiline) {
        if (project == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(1);
        }
        if (format == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(2);
        }
        if (column == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(3);
        }
        if (row == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(4);
        }
        if (valueParser == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(5);
        }
        if (valueFormatter == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(6);
        }
        this.myFormat = format;
        this.myColumn = column;
        this.myRow = row;
        this.myNullValue = nullValue;
        this.myGrid = grid;
        this.myValueParser = valueParser;
        this.myTextField = new GridCellEditorTextField(project, grid, row, column, multiline, initiator, provider, true, valueFormatter);
        this.myTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String editorText = FormatBasedGridCellEditor.this.myTextField.getDocument().getText();
                FormatBasedGridCellEditor.this.setError(null, 0);
                FormatBasedGridCellEditor.this.fireEditing(StringUtil.isEmpty((String)editorText) ? FormatBasedGridCellEditor.this.myNullValue : editorText);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$1", "documentChanged"));
            }
        });
        if (nullValue != null) {
            this.myTextField.addSettingsProvider(editor -> {
                editor.setPlaceholder((CharSequence)this.myNullValue.getDisplayName());
                editor.setShowPlaceholderWhenFocused(true);
            });
        }
        Disposer.register((Disposable)this, (Disposable)this.myTextField);
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myTextField.getText();
        if (string == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        GridCellEditorTextField gridCellEditorTextField = this.myTextField;
        if (gridCellEditorTextField == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(8);
        }
        return gridCellEditorTextField;
    }

    @Override
    @NotNull
    public Object getValue() {
        Object object = this.myValueParser.parse(this.myTextField.getText(), this.myTextField.getDocument());
        if (object == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(9);
        }
        return object;
    }

    @Override
    public boolean stop() {
        String text = this.myTextField.getText();
        Object parsed = this.myValueParser.parse(text, this.myTextField.getDocument());
        if (!(parsed instanceof UnparsedValue)) {
            return true;
        }
        UnparsedValue e = (UnparsedValue)parsed;
        UnparsedValue.ParsingError error = e.getError();
        this.setError(error == null ? DataGridBundle.message((String)"failed.to.parse.data", (Object[])new Object[0]) : error.message(), error == null ? 0 : error.offset());
        return false;
    }

    private void setError(@Nullable @Nls String error, int offset) {
        this.setEditorOutline(error == null ? null : DarculaUIUtil.Outline.error);
        Editor editor = this.getEditor();
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)this.myTextField.getDocument(), (Project)(editor == null ? null : editor.getProject()), (boolean)true);
        FormatBasedGridCellEditor.setHighlighting(markupModel, error == null ? null : FormatBasedGridCellEditor.createErrorInfo(offset, this.myTextField.getDocument().getTextLength(), error));
    }

    private void setEditorOutline(@Nullable DarculaUIUtil.Outline outline) {
        Editor editor = this.myTextField.getEditor();
        JComponent pane = (JComponent)UIUtil.uiParents((Component)(editor == null ? null : editor.getContentComponent()), (boolean)false).filter(JComponent.class).find(c -> c.getBorder() instanceof ErrorBorderCapable);
        if (pane != null) {
            pane.putClientProperty("JComponent.outline", outline == null ? null : outline.name());
        }
    }

    @NotNull
    private static HighlightInfo createErrorInfo(int startOffset, int endOffset, @NlsContexts.DetailedDescription String tooltip) {
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).textAttributes(DataGridColors.GRID_ERROR_VALUE).range(TextRange.create((int)startOffset, (int)endOffset)).descriptionAndTooltip(tooltip).createUnconditionally();
        if (highlightInfo == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(10);
        }
        return highlightInfo;
    }

    private static void setHighlighting(@NotNull MarkupModel markupModel, @Nullable HighlightInfo info) {
        if (markupModel == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(11);
        }
        markupModel.removeAllHighlighters();
        if (info != null) {
            RangeHighlighterEx highlighter = ((MarkupModelEx)markupModel).addRangeHighlighterAndChangeAttributes(info.forcedTextAttributesKey, info.startOffset, info.endOffset, 5000, HighlighterTargetArea.EXACT_RANGE, false, rh -> rh.setErrorStripeTooltip((Object)info));
            info.setHighlighter(highlighter);
        }
    }

    @NotNull
    protected GridCellEditorTextField getTextField() {
        GridCellEditorTextField gridCellEditorTextField = this.myTextField;
        if (gridCellEditorTextField == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(12);
        }
        return gridCellEditorTextField;
    }

    @Nullable
    protected ReservedCellValue getNullValue() {
        return this.myNullValue;
    }

    protected final DataGrid getGrid() {
        return this.myGrid;
    }

    protected final Formatter getFormat() {
        return this.myFormat;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myTextField.getEditor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFormatter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorInfo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setHighlighting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 12 -> new IllegalStateException(string);
        };
    }

    public static abstract class WithBrowseButton<T extends JComponent, V>
    extends BoundedFormatBasedGridCellEditor<V>
    implements ActionListener {
        private final ComponentWithBrowseButton<GridCellEditorTextField> myComponent;
        private final GridCellEditorFactory myFactory;
        private final Class<V> myClazz;
        private JBPopup myPopup;
        private T myPopupComponent;

        public WithBrowseButton(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable ReservedCellValue nullValue, final EventObject initiator, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> columnModelIndex, @NotNull Class<V> clazz, @Nullable TextCompletionProvider provider, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter, @NotNull GridCellEditorFactory factory) {
            if (project == null) {
                WithBrowseButton.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                WithBrowseButton.$$$reportNull$$$0(1);
            }
            if (format == null) {
                WithBrowseButton.$$$reportNull$$$0(2);
            }
            if (row == null) {
                WithBrowseButton.$$$reportNull$$$0(3);
            }
            if (columnModelIndex == null) {
                WithBrowseButton.$$$reportNull$$$0(4);
            }
            if (clazz == null) {
                WithBrowseButton.$$$reportNull$$$0(5);
            }
            if (valueParser == null) {
                WithBrowseButton.$$$reportNull$$$0(6);
            }
            if (valueFormatter == null) {
                WithBrowseButton.$$$reportNull$$$0(7);
            }
            if (factory == null) {
                WithBrowseButton.$$$reportNull$$$0(8);
            }
            super(project, grid, format, nullValue, initiator, row, columnModelIndex, provider, valueParser, valueFormatter);
            this.myClazz = clazz;
            this.myFactory = factory;
            this.myComponent = new ComponentWithBrowseButton<GridCellEditorTextField>(this.getTextField(), (ActionListener)this){

                public void addNotify() {
                    KeyEvent event;
                    int code;
                    super.addNotify();
                    if (initiator instanceof KeyEvent && (code = (event = (KeyEvent)initiator).getKeyCode()) != 10 && code != 32) {
                        return;
                    }
                    Objects.requireNonNull(this.getEditor()).getContentComponent().addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (myPopup != null) {
                                this.closePopup();
                            }
                        }
                    });
                    ApplicationManager.getApplication().invokeLater(() -> this.actionPerformed(null));
                }
            };
            this.myComponent.getButton().setBorder(UIManager.getBorder("Button.border"));
            this.myComponent.setRequestFocusEnabled(true);
            this.getTextField().addSettingsProvider(editor -> editor.getSelectionModel().removeSelection());
        }

        @NotNull
        public ComponentWithBrowseButton<GridCellEditorTextField> getComponent() {
            ComponentWithBrowseButton<GridCellEditorTextField> componentWithBrowseButton = this.myComponent;
            if (componentWithBrowseButton == null) {
                WithBrowseButton.$$$reportNull$$$0(9);
            }
            return componentWithBrowseButton;
        }

        @Override
        @NotNull
        public Object getValue() {
            V value;
            if (this.myPopup instanceof AbstractPopup && this.myPopup.isVisible() && (value = this.getValue(this.myPopupComponent)) != null) {
                V v = value;
                if (v == null) {
                    WithBrowseButton.$$$reportNull$$$0(10);
                }
                return v;
            }
            Object object = super.getValue();
            if (object == null) {
                WithBrowseButton.$$$reportNull$$$0(11);
            }
            return object;
        }

        protected abstract V getValue(T var1);

        protected final void processDate(@NotNull T component, @Nullable Runnable onAccept, @Nullable Runnable onDecline) {
            V internalValue;
            if (component == null) {
                WithBrowseButton.$$$reportNull$$$0(12);
            }
            if (this.outOfRange(internalValue = this.getValue(component), onAccept, onDecline)) {
                return;
            }
            this.acceptValue(internalValue, onAccept);
        }

        protected final Runnable onAccept(@NotNull JBPopup popup) {
            if (popup == null) {
                WithBrowseButton.$$$reportNull$$$0(13);
            }
            return () -> {
                popup.closeOk(null);
                this.getComponent().getParent().getParent().requestFocus();
            };
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            if (this.myPopup != null) {
                this.closePopup();
            } else {
                JBPopup popup = this.createPopup();
                this.showPopup(popup);
            }
        }

        private void closePopup() {
            JBPopup popup = this.myPopup;
            this.myPopup = null;
            this.myPopupComponent = null;
            popup.cancel();
            Disposer.dispose((Disposable)popup);
        }

        @NotNull
        private JBPopup createPopup() {
            this.myPopupComponent = this.getPopupComponent();
            this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(this.myPopupComponent, this.getPreferredFocusedComponent(this.myPopupComponent)).setModalContext(false).setFocusable(true).setCancelOnClickOutside(false).setRequestFocus(true).setResizable(false).createPopup();
            this.configurePopup(this.myPopup, this.myPopupComponent);
            Disposer.register((Disposable)this, (Disposable)this.myPopup);
            JBPopup jBPopup = this.myPopup;
            if (jBPopup == null) {
                WithBrowseButton.$$$reportNull$$$0(14);
            }
            return jBPopup;
        }

        @Override
        protected void showPopup(@NotNull JBPopup popup) {
            if (popup == null) {
                WithBrowseButton.$$$reportNull$$$0(15);
            }
            Dimension size = popup.getContent().getPreferredSize();
            FixedSizeButton button = this.getComponent().getButton();
            popup.show(new RelativePoint((Component)button, new Point(button.getWidth() - size.width, button.getHeight())));
        }

        @Override
        @Nullable
        protected V getInternalValue() {
            String text = this.getTextField().getText();
            return (V)ObjectUtils.tryCast((Object)this.getFormat().parse(text, new ParsePosition(0)), this.myClazz);
        }

        @Override
        protected String getInfinityString(@NotNull V internalValue) {
            if (internalValue == null) {
                WithBrowseButton.$$$reportNull$$$0(16);
            }
            BoundaryValueResolver resolver = GridCellEditorHelper.get((CoreGrid)this.getGrid()).getResolver((CoreGrid)this.getGrid(), this.myColumn);
            return resolver.getInfinityString(internalValue);
        }

        @Override
        protected void beforeStopEditing(@NotNull V internalValue) {
            if (internalValue == null) {
                WithBrowseButton.$$$reportNull$$$0(17);
            }
            Object object = this.convertInternalValue(internalValue);
            this.getTextField().setText(this.myFactory.getValueFormatter(this.getGrid(), (ModelIndex<GridRow>)this.myRow, (ModelIndex<GridColumn>)this.myColumn, object), this.getGrid(), (ModelIndex<GridRow>)this.myRow, (ModelIndex<GridColumn>)this.myColumn);
        }

        @Override
        protected boolean isSameValueInEditor(@NotNull V internalValue, @NotNull String boundaryString) {
            if (internalValue == null) {
                WithBrowseButton.$$$reportNull$$$0(18);
            }
            if (boundaryString == null) {
                WithBrowseButton.$$$reportNull$$$0(19);
            }
            return StringUtil.equalsIgnoreWhitespaces((CharSequence)boundaryString, (CharSequence)this.getTextField().getText());
        }

        @NotNull
        protected abstract T getPopupComponent();

        @NotNull
        protected abstract JComponent getPreferredFocusedComponent(@NotNull T var1);

        protected abstract void configurePopup(@NotNull JBPopup var1, @NotNull T var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 9, 10, 11, 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnModelIndex";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueParser";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueFormatter";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popup";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "internalValue";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "boundaryString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 14: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "processDate";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "onAccept";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "showPopup";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getInfinityString";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "beforeStopEditing";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "isSameValueInEditor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 9, 10, 11, 14 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class BoundedFormatBasedGridCellEditor<T>
    extends FormatBasedGridCellEditor {
        private boolean adjusting;

        public BoundedFormatBasedGridCellEditor(Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable ReservedCellValue nullValue, EventObject initiator, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> columnModelIndex, @Nullable TextCompletionProvider provider, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
            if (grid == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(0);
            }
            if (format == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(1);
            }
            if (row == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(2);
            }
            if (columnModelIndex == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(3);
            }
            if (valueParser == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(4);
            }
            if (valueFormatter == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(5);
            }
            super(project, grid, format, columnModelIndex, row, nullValue, initiator, provider, valueParser, valueFormatter, false);
        }

        @Override
        public boolean stop() {
            return super.stop() && this.checkInRange();
        }

        private boolean checkInRange() {
            if (this.adjusting || this.getTextField().getText().isEmpty()) {
                return true;
            }
            T value = this.getInternalValue();
            return value == null || !this.outOfRange(value, null, null);
        }

        protected void showPopup(@NotNull JBPopup popup) {
            if (popup == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(6);
            }
            Dimension size = popup.getContent().getPreferredSize();
            JComponent button = this.getComponent();
            popup.show(new RelativePoint((Component)button, new Point(button.getWidth() - size.width, button.getHeight())));
        }

        protected boolean outOfRange(@NotNull T internalValue, @Nullable Runnable onAccept, @Nullable Runnable onDecline) {
            String boundary;
            if (internalValue == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(7);
            }
            if ((boundary = this.getInfinityString(internalValue)) != null && !this.isSameValueInEditor(internalValue, boundary)) {
                this.onOutOfRange(boundary, internalValue, onAccept, onDecline);
                return true;
            }
            return false;
        }

        private void onOutOfRange(@NotNull String boundary, @NotNull T internalValue, @Nullable Runnable onAccept, @Nullable Runnable onDecline) {
            if (boundary == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(8);
            }
            if (internalValue == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(9);
            }
            this.showPopup((JBPopup)JBPopupFactory.getInstance().createConfirmation(DataGridBundle.message((String)"popup.title.value.out.range.set", (Object[])new Object[]{boundary}), CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), () -> this.acceptValue(internalValue, onAccept), (Runnable)ObjectUtils.notNull((Object)onDecline, () -> {}), 1));
        }

        protected void acceptValue(@NotNull T internalValue, @Nullable Runnable onAccept) {
            if (internalValue == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(10);
            }
            try {
                this.adjusting = true;
                this.beforeStopEditing(internalValue);
                if (onAccept != null) {
                    onAccept.run();
                }
                this.getGrid().stopEditing();
            }
            finally {
                this.adjusting = false;
            }
        }

        protected void beforeStopEditing(@NotNull T internalValue) {
            if (internalValue == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(11);
            }
        }

        @NotNull
        protected Object convertInternalValue(@NotNull T internalValue) {
            if (internalValue == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(12);
            }
            T t = internalValue;
            if (t == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(13);
            }
            return t;
        }

        protected abstract boolean isSameValueInEditor(@NotNull T var1, @NotNull String var2);

        @Nullable
        protected abstract T getInternalValue();

        @Nullable
        protected abstract String getInfinityString(@NotNull T var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnModelIndex";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueParser";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueFormatter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popup";
                    break;
                }
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "internalValue";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "boundary";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertInternalValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "showPopup";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "outOfRange";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "onOutOfRange";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptValue";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "beforeStopEditing";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "convertInternalValue";
                    break;
                }
                case 13: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 13 -> new IllegalStateException(string);
            };
        }
    }
}

