/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_aui.h"
        #include <wx/aui/auibook.h>
        #include <wx/gdicmn.h>
        #include <wx/window.h>
        #include <wx/colour.h>
        #include <wx/font.h>
        #include <wx/dc.h>
        #include <wx/bmpbndl.h>
        #include <wx/aui/auibook.h>
        #include <wx/gdicmn.h>


PyDoc_STRVAR(doc_wxAuiTabArt_Clone, "Clone() -> AuiTabArt\n"
"\n"
"Clones the art object.");

extern "C" {static PyObject *meth_wxAuiTabArt_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxAuiTabArt *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiTabArt, &sipCpp))
        {
            ::wxAuiTabArt*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_Clone);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Clone();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxAuiTabArt, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_Clone, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiTabArt_DrawBackground, "DrawBackground(dc, wnd, rect) -> None\n"
"\n"
"Draws a background on the given area.");

extern "C" {static PyObject *meth_wxAuiTabArt_DrawBackground(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_DrawBackground(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxDC* dc;
        ::wxWindow* wnd;
        const ::wxRect* rect;
        int rectState = 0;
        ::wxAuiTabArt *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_wnd,
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J8J1", &sipSelf, sipType_wxAuiTabArt, &sipCpp, sipType_wxDC, &dc, sipType_wxWindow, &wnd, sipType_wxRect, &rect, &rectState))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_DrawBackground);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawBackground(*dc, wnd, *rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_DrawBackground, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiTabArt_DrawButton, "DrawButton(dc, wnd, in_rect, bitmap_id, button_state, orientation, out_rect) -> None\n"
"\n"
"Draws a button.");

extern "C" {static PyObject *meth_wxAuiTabArt_DrawButton(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_DrawButton(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxDC* dc;
        ::wxWindow* wnd;
        const ::wxRect* in_rect;
        int in_rectState = 0;
        int bitmap_id;
        int button_state;
        int orientation;
        ::wxRect* out_rect;
        int out_rectState = 0;
        ::wxAuiTabArt *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_wnd,
            sipName_in_rect,
            sipName_bitmap_id,
            sipName_button_state,
            sipName_orientation,
            sipName_out_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J8J1iiiJ0", &sipSelf, sipType_wxAuiTabArt, &sipCpp, sipType_wxDC, &dc, sipType_wxWindow, &wnd, sipType_wxRect, &in_rect, &in_rectState, &bitmap_id, &button_state, &orientation, sipType_wxRect, &out_rect, &out_rectState))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_DrawButton);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawButton(*dc, wnd, *in_rect, bitmap_id, button_state, orientation, out_rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(in_rect), sipType_wxRect, in_rectState);
            sipReleaseType(out_rect, sipType_wxRect, out_rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_DrawButton, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiTabArt_DrawTab, "DrawTab(dc, wnd, page, rect, close_button_state, out_tab_rect, out_button_rect, x_extent) -> None\n"
"\n"
"Draws a tab.");

extern "C" {static PyObject *meth_wxAuiTabArt_DrawTab(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_DrawTab(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxDC* dc;
        ::wxWindow* wnd;
        const ::wxAuiNotebookPage* page;
        const ::wxRect* rect;
        int rectState = 0;
        int close_button_state;
        ::wxRect* out_tab_rect;
        int out_tab_rectState = 0;
        ::wxRect* out_button_rect;
        int out_button_rectState = 0;
        int x_extent;
        ::wxAuiTabArt *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_wnd,
            sipName_page,
            sipName_rect,
            sipName_close_button_state,
            sipName_out_tab_rect,
            sipName_out_button_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J8J9J1iJ0J0", &sipSelf, sipType_wxAuiTabArt, &sipCpp, sipType_wxDC, &dc, sipType_wxWindow, &wnd, sipType_wxAuiNotebookPage, &page, sipType_wxRect, &rect, &rectState, &close_button_state, sipType_wxRect, &out_tab_rect, &out_tab_rectState, sipType_wxRect, &out_button_rect, &out_button_rectState))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_DrawTab);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawTab(*dc, wnd, *page, *rect, close_button_state, out_tab_rect, out_button_rect, &x_extent);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);
            sipReleaseType(out_tab_rect, sipType_wxRect, out_tab_rectState);
            sipReleaseType(out_button_rect, sipType_wxRect, out_button_rectState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(x_extent);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_DrawTab, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiTabArt_GetBestTabCtrlSize, "GetBestTabCtrlSize() -> int\n"
"\n"
"Returns the tab control size.");

extern "C" {static PyObject *meth_wxAuiTabArt_GetBestTabCtrlSize(PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_GetBestTabCtrlSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxWindow* a0;
        const ::wxAuiNotebookPageArray* a1;
        const ::wxSize* a2;
        int a2State = 0;
        ::wxAuiTabArt *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8J9J1", &sipSelf, sipType_wxAuiTabArt, &sipCpp, sipType_wxWindow, &a0, sipType_wxAuiNotebookPageArray, &a1, sipType_wxSize, &a2, &a2State))
        {
            int sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_GetBestTabCtrlSize);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBestTabCtrlSize(a0, *a1, *a2);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(a2), sipType_wxSize, a2State);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_GetBestTabCtrlSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiTabArt_GetIndentSize, "GetIndentSize() -> int\n"
"\n"
"Returns the indent size.");

extern "C" {static PyObject *meth_wxAuiTabArt_GetIndentSize(PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_GetIndentSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxAuiTabArt *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiTabArt, &sipCpp))
        {
            int sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_GetIndentSize);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetIndentSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_GetIndentSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiTabArt_GetTabSize, "GetTabSize(dc, wnd, caption, bitmap, active, close_button_state, x_extent) -> wx.Size\n"
"\n"
"Returns the tab size for the given caption, bitmap and state.");

extern "C" {static PyObject *meth_wxAuiTabArt_GetTabSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_GetTabSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxDC* dc;
        ::wxWindow* wnd;
        const ::wxString* caption;
        int captionState = 0;
        const ::wxBitmapBundle* bitmap;
        int bitmapState = 0;
        bool active;
        int close_button_state;
        int x_extent;
        ::wxAuiTabArt *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_wnd,
            sipName_caption,
            sipName_bitmap,
            sipName_active,
            sipName_close_button_state,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J8J1J1bi", &sipSelf, sipType_wxAuiTabArt, &sipCpp, sipType_wxDC, &dc, sipType_wxWindow, &wnd, sipType_wxString, &caption, &captionState, sipType_wxBitmapBundle, &bitmap, &bitmapState, &active, &close_button_state))
        {
            ::wxSize*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_GetTabSize);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetTabSize(*dc, wnd, *caption, *bitmap, active, close_button_state, &x_extent));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(caption), sipType_wxString, captionState);
            sipReleaseType(const_cast< ::wxBitmapBundle *>(bitmap), sipType_wxBitmapBundle, bitmapState);

            if (PyErr_Occurred())
                return 0;

            PyObject *sipResObj = sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
            return sipBuildResult(0, "(Ri)", sipResObj, x_extent);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_GetTabSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiTabArt_SetFlags, "SetFlags(flags) -> None\n"
"\n"
"Sets flags.");

extern "C" {static PyObject *meth_wxAuiTabArt_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        uint flags;
        ::wxAuiTabArt *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bu", &sipSelf, sipType_wxAuiTabArt, &sipCpp, &flags))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_SetFlags);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_SetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiTabArt_SetMeasuringFont, "SetMeasuringFont(font) -> None\n"
"\n"
"Sets the font used for calculating measurements.");

extern "C" {static PyObject *meth_wxAuiTabArt_SetMeasuringFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_SetMeasuringFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxFont* font;
        ::wxAuiTabArt *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxAuiTabArt, &sipCpp, sipType_wxFont, &font))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_SetMeasuringFont);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMeasuringFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_SetMeasuringFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiTabArt_SetNormalFont, "SetNormalFont(font) -> None\n"
"\n"
"Sets the normal font for drawing labels.");

extern "C" {static PyObject *meth_wxAuiTabArt_SetNormalFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_SetNormalFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxFont* font;
        ::wxAuiTabArt *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxAuiTabArt, &sipCpp, sipType_wxFont, &font))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_SetNormalFont);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetNormalFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_SetNormalFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiTabArt_SetSelectedFont, "SetSelectedFont(font) -> None\n"
"\n"
"Sets the font for drawing text for selected UI elements.");

extern "C" {static PyObject *meth_wxAuiTabArt_SetSelectedFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_SetSelectedFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxFont* font;
        ::wxAuiTabArt *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxAuiTabArt, &sipCpp, sipType_wxFont, &font))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_SetSelectedFont);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSelectedFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_SetSelectedFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiTabArt_SetColour, "SetColour(colour) -> None\n"
"\n"
"Sets the colour of the inactive tabs.");

extern "C" {static PyObject *meth_wxAuiTabArt_SetColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_SetColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxColour* colour;
        int colourState = 0;
        ::wxAuiTabArt *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAuiTabArt, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_SetColour);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_SetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiTabArt_SetActiveColour, "SetActiveColour(colour) -> None\n"
"\n"
"Sets the colour of the selected tab.");

extern "C" {static PyObject *meth_wxAuiTabArt_SetActiveColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_SetActiveColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxColour* colour;
        int colourState = 0;
        ::wxAuiTabArt *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAuiTabArt, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_SetActiveColour);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetActiveColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_SetActiveColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiTabArt_SetSizingInfo, "SetSizingInfo(tab_ctrl_size, tab_count, wnd=None) -> None\n"
"\n"
"Sets sizing information.");

extern "C" {static PyObject *meth_wxAuiTabArt_SetSizingInfo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiTabArt_SetSizingInfo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxSize* tab_ctrl_size;
        int tab_ctrl_sizeState = 0;
        size_t tab_count;
        ::wxWindow* wnd = 0;
        ::wxAuiTabArt *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tab_ctrl_size,
            sipName_tab_count,
            sipName_wnd,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1=|J8", &sipSelf, sipType_wxAuiTabArt, &sipCpp, sipType_wxSize, &tab_ctrl_size, &tab_ctrl_sizeState, &tab_count, sipType_wxWindow, &wnd))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AuiTabArt, sipName_SetSizingInfo);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSizingInfo(*tab_ctrl_size, tab_count, wnd);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(tab_ctrl_size), sipType_wxSize, tab_ctrl_sizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiTabArt, sipName_SetSizingInfo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxAuiTabArt(void *, int);}
static void release_wxAuiTabArt(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxAuiTabArt *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxAuiTabArt(sipSimpleWrapper *);}
static void dealloc_wxAuiTabArt(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxAuiTabArt(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxAuiTabArt[] = {
    {sipName_Clone, meth_wxAuiTabArt_Clone, METH_VARARGS, doc_wxAuiTabArt_Clone},
    {sipName_DrawBackground, SIP_MLMETH_CAST(meth_wxAuiTabArt_DrawBackground), METH_VARARGS|METH_KEYWORDS, doc_wxAuiTabArt_DrawBackground},
    {sipName_DrawButton, SIP_MLMETH_CAST(meth_wxAuiTabArt_DrawButton), METH_VARARGS|METH_KEYWORDS, doc_wxAuiTabArt_DrawButton},
    {sipName_DrawTab, SIP_MLMETH_CAST(meth_wxAuiTabArt_DrawTab), METH_VARARGS|METH_KEYWORDS, doc_wxAuiTabArt_DrawTab},
    {sipName_GetBestTabCtrlSize, meth_wxAuiTabArt_GetBestTabCtrlSize, METH_VARARGS, doc_wxAuiTabArt_GetBestTabCtrlSize},
    {sipName_GetIndentSize, meth_wxAuiTabArt_GetIndentSize, METH_VARARGS, doc_wxAuiTabArt_GetIndentSize},
    {sipName_GetTabSize, SIP_MLMETH_CAST(meth_wxAuiTabArt_GetTabSize), METH_VARARGS|METH_KEYWORDS, doc_wxAuiTabArt_GetTabSize},
    {sipName_SetActiveColour, SIP_MLMETH_CAST(meth_wxAuiTabArt_SetActiveColour), METH_VARARGS|METH_KEYWORDS, doc_wxAuiTabArt_SetActiveColour},
    {sipName_SetColour, SIP_MLMETH_CAST(meth_wxAuiTabArt_SetColour), METH_VARARGS|METH_KEYWORDS, doc_wxAuiTabArt_SetColour},
    {sipName_SetFlags, SIP_MLMETH_CAST(meth_wxAuiTabArt_SetFlags), METH_VARARGS|METH_KEYWORDS, doc_wxAuiTabArt_SetFlags},
    {sipName_SetMeasuringFont, SIP_MLMETH_CAST(meth_wxAuiTabArt_SetMeasuringFont), METH_VARARGS|METH_KEYWORDS, doc_wxAuiTabArt_SetMeasuringFont},
    {sipName_SetNormalFont, SIP_MLMETH_CAST(meth_wxAuiTabArt_SetNormalFont), METH_VARARGS|METH_KEYWORDS, doc_wxAuiTabArt_SetNormalFont},
    {sipName_SetSelectedFont, SIP_MLMETH_CAST(meth_wxAuiTabArt_SetSelectedFont), METH_VARARGS|METH_KEYWORDS, doc_wxAuiTabArt_SetSelectedFont},
    {sipName_SetSizingInfo, SIP_MLMETH_CAST(meth_wxAuiTabArt_SetSizingInfo), METH_VARARGS|METH_KEYWORDS, doc_wxAuiTabArt_SetSizingInfo}
};

sipVariableDef variables_wxAuiTabArt[] = {
    {PropertyVariable, sipName_IndentSize, &methods_wxAuiTabArt[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxAuiTabArt, "AuiTabArt() -> None\n"
"\n"
"Tab art provider defines all the drawing functions used by\n"
"wxAuiNotebook.");


sipClassTypeDef sipTypeDef__aui_wxAuiTabArt = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxAuiTabArt,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_AuiTabArt,
        {0, 0, 1},
        14, methods_wxAuiTabArt,
        0, SIP_NULLPTR,
        1, variables_wxAuiTabArt,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxAuiTabArt,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxAuiTabArt,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxAuiTabArt,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};
