// @generated by protoc-gen-es v1.7.2 with parameter "target=ts"
// @generated from file tasks.proto (package rs.tokio.console.tasks, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Duration, Message, proto3, protoInt64, Timestamp } from "@bufbuild/protobuf";
import { Field, Id, Location, MetaId, PollStats, SpanId } from "./common_pb.js";

/**
 * A task state update.
 *
 * Each `TaskUpdate` contains any task data that has changed since the last
 * update. This includes:
 * - any new tasks that were spawned since the last update
 * - the current stats for any task whose stats changed since the last update
 *
 * @generated from message rs.tokio.console.tasks.TaskUpdate
 */
export class TaskUpdate extends Message<TaskUpdate> {
  /**
   * A list of new tasks that were spawned since the last `TaskUpdate` was
   * sent.
   *
   * If this is empty, no new tasks were spawned.
   *
   * @generated from field: repeated rs.tokio.console.tasks.Task new_tasks = 1;
   */
  newTasks: Task[] = [];

  /**
   * Any task stats that have changed since the last update.
   *
   * This is a map of task IDs (64-bit unsigned integers) to task stats. If a
   * task's ID is not included in this map, then its stats have *not* changed
   * since the last `TaskUpdate` in which they were present. If a task's ID
   * *is* included in this map, the corresponding value represents a complete
   * snapshot of that task's stats at in the current time window.
   *
   * @generated from field: map<uint64, rs.tokio.console.tasks.Stats> stats_update = 3;
   */
  statsUpdate: { [key: string]: Stats } = {};

  /**
   * A count of how many task events (e.g. polls, spawns, etc) were not
   * recorded because the application's event buffer was at capacity.
   *
   * If everything is working normally, this should be 0. If it is greater
   * than 0, that may indicate that some data is missing from this update, and
   * it may be necessary to increase the number of events buffered by the
   * application to ensure that data loss is avoided.
   *
   * If the application's instrumentation ensures reliable delivery of events,
   * this will always be 0.
   *
   * @generated from field: uint64 dropped_events = 4;
   */
  droppedEvents = protoInt64.zero;

  constructor(data?: PartialMessage<TaskUpdate>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "rs.tokio.console.tasks.TaskUpdate";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "new_tasks", kind: "message", T: Task, repeated: true },
    { no: 3, name: "stats_update", kind: "map", K: 4 /* ScalarType.UINT64 */, V: {kind: "message", T: Stats} },
    { no: 4, name: "dropped_events", kind: "scalar", T: 4 /* ScalarType.UINT64 */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TaskUpdate {
    return new TaskUpdate().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TaskUpdate {
    return new TaskUpdate().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TaskUpdate {
    return new TaskUpdate().fromJsonString(jsonString, options);
  }

  static equals(a: TaskUpdate | PlainMessage<TaskUpdate> | undefined, b: TaskUpdate | PlainMessage<TaskUpdate> | undefined): boolean {
    return proto3.util.equals(TaskUpdate, a, b);
  }
}

/**
 * A task details update
 *
 * @generated from message rs.tokio.console.tasks.TaskDetails
 */
export class TaskDetails extends Message<TaskDetails> {
  /**
   * The task's ID which the details belong to.
   *
   * @generated from field: rs.tokio.console.common.Id task_id = 1;
   */
  taskId?: Id;

  /**
   * The timestamp for when the update to the task took place.
   *
   * @generated from field: google.protobuf.Timestamp now = 2;
   */
  now?: Timestamp;

  /**
   * A histogram of task poll durations.
   *
   * This is either:
   * - the raw binary representation of a HdrHistogram.rs `Histogram`
   *   serialized to binary in the V2 format (legacy)
   * - a binary histogram plus details on outliers (current)
   *
   * @generated from oneof rs.tokio.console.tasks.TaskDetails.poll_times_histogram
   */
  pollTimesHistogram: {
    /**
     * HdrHistogram.rs `Histogram` serialized to binary in the V2 format
     *
     * @generated from field: bytes legacy_histogram = 3;
     */
    value: Uint8Array;
    case: "legacyHistogram";
  } | {
    /**
     * A histogram plus additional data.
     *
     * @generated from field: rs.tokio.console.tasks.DurationHistogram histogram = 4;
     */
    value: DurationHistogram;
    case: "histogram";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * A histogram of task scheduled durations.
   *
   * The scheduled duration is the time a task spends between being
   * woken and when it is next polled.
   *
   * @generated from field: rs.tokio.console.tasks.DurationHistogram scheduled_times_histogram = 5;
   */
  scheduledTimesHistogram?: DurationHistogram;

  constructor(data?: PartialMessage<TaskDetails>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "rs.tokio.console.tasks.TaskDetails";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "task_id", kind: "message", T: Id },
    { no: 2, name: "now", kind: "message", T: Timestamp },
    { no: 3, name: "legacy_histogram", kind: "scalar", T: 12 /* ScalarType.BYTES */, oneof: "poll_times_histogram" },
    { no: 4, name: "histogram", kind: "message", T: DurationHistogram, oneof: "poll_times_histogram" },
    { no: 5, name: "scheduled_times_histogram", kind: "message", T: DurationHistogram },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TaskDetails {
    return new TaskDetails().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TaskDetails {
    return new TaskDetails().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TaskDetails {
    return new TaskDetails().fromJsonString(jsonString, options);
  }

  static equals(a: TaskDetails | PlainMessage<TaskDetails> | undefined, b: TaskDetails | PlainMessage<TaskDetails> | undefined): boolean {
    return proto3.util.equals(TaskDetails, a, b);
  }
}

/**
 * Data recorded when a new task is spawned.
 *
 * @generated from message rs.tokio.console.tasks.Task
 */
export class Task extends Message<Task> {
  /**
   * The task's ID.
   *
   * This uniquely identifies this task across all *currently live* tasks.
   * When the task's stats change, or when the task completes, it will be
   * identified by this ID; if the client requires additional information
   * included in the `Task` message, it should store that data and access it
   * by ID.
   *
   * @generated from field: rs.tokio.console.common.Id id = 1;
   */
  id?: Id;

  /**
   * The numeric ID of the task's `Metadata`.
   *
   * This identifies the `Metadata` that describes the `tracing` span
   * corresponding to this task. The metadata for this ID will have been sent
   * in a prior `RegisterMetadata` message.
   *
   * @generated from field: rs.tokio.console.common.MetaId metadata = 2;
   */
  metadata?: MetaId;

  /**
   * The category of task this task belongs to.
   *
   * @generated from field: rs.tokio.console.tasks.Task.Kind kind = 3;
   */
  kind = Task_Kind.SPAWN;

  /**
   * A list of `Field` objects attached to this task.
   *
   * @generated from field: repeated rs.tokio.console.common.Field fields = 4;
   */
  fields: Field[] = [];

  /**
   * An ordered list of span IDs corresponding to the `tracing` span context
   * in which this task was spawned.
   *
   * The first span ID in this list is the immediate parent, followed by that
   * span's parent, and so on. The final ID is the root span of the current
   * trace.
   *
   * If this is empty, there were *no* active spans when the task was spawned.
   *
   * These IDs may correspond to `tracing` spans which are *not* tasks, if
   * additional trace data is being collected.
   *
   * @generated from field: repeated rs.tokio.console.common.SpanId parents = 5;
   */
  parents: SpanId[] = [];

  /**
   * The location in code where the task was spawned.
   *
   * @generated from field: rs.tokio.console.common.Location location = 6;
   */
  location?: Location;

  constructor(data?: PartialMessage<Task>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "rs.tokio.console.tasks.Task";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: Id },
    { no: 2, name: "metadata", kind: "message", T: MetaId },
    { no: 3, name: "kind", kind: "enum", T: proto3.getEnumType(Task_Kind) },
    { no: 4, name: "fields", kind: "message", T: Field, repeated: true },
    { no: 5, name: "parents", kind: "message", T: SpanId, repeated: true },
    { no: 6, name: "location", kind: "message", T: Location },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Task {
    return new Task().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Task {
    return new Task().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Task {
    return new Task().fromJsonString(jsonString, options);
  }

  static equals(a: Task | PlainMessage<Task> | undefined, b: Task | PlainMessage<Task> | undefined): boolean {
    return proto3.util.equals(Task, a, b);
  }
}

/**
 * The category of task this task belongs to.
 *
 * @generated from enum rs.tokio.console.tasks.Task.Kind
 */
export enum Task_Kind {
  /**
   * A task spawned using a runtime's standard asynchronous task spawning
   * operation (such as `tokio::task::spawn`).
   *
   * @generated from enum value: SPAWN = 0;
   */
  SPAWN = 0,

  /**
   * A task spawned via a runtime's blocking task spawning operation
   * (such as `tokio::task::spawn_blocking`).
   *
   * @generated from enum value: BLOCKING = 1;
   */
  BLOCKING = 1,
}
// Retrieve enum metadata with: proto3.getEnumType(Task_Kind)
proto3.util.setEnumType(Task_Kind, "rs.tokio.console.tasks.Task.Kind", [
  { no: 0, name: "SPAWN" },
  { no: 1, name: "BLOCKING" },
]);

/**
 * Task performance statistics.
 *
 * @generated from message rs.tokio.console.tasks.Stats
 */
export class Stats extends Message<Stats> {
  /**
   * Timestamp of when the task was spawned.
   *
   * @generated from field: google.protobuf.Timestamp created_at = 1;
   */
  createdAt?: Timestamp;

  /**
   * Timestamp of when the task was dropped.
   *
   * @generated from field: google.protobuf.Timestamp dropped_at = 2;
   */
  droppedAt?: Timestamp;

  /**
   * The total number of times this task has been woken over its lifetime.
   *
   * @generated from field: uint64 wakes = 3;
   */
  wakes = protoInt64.zero;

  /**
   * The total number of times this task's waker has been cloned.
   *
   * @generated from field: uint64 waker_clones = 4;
   */
  wakerClones = protoInt64.zero;

  /**
   * The total number of times this task's waker has been dropped.
   *
   * @generated from field: uint64 waker_drops = 5;
   */
  wakerDrops = protoInt64.zero;

  /**
   * The timestamp of the most recent time this task has been woken.
   *
   * If this is `None`, the task has not yet been woken.
   *
   * @generated from field: optional google.protobuf.Timestamp last_wake = 6;
   */
  lastWake?: Timestamp;

  /**
   * Contains task poll statistics.
   *
   * @generated from field: rs.tokio.console.common.PollStats poll_stats = 7;
   */
  pollStats?: PollStats;

  /**
   * The total number of times this task has woken itself.
   *
   * @generated from field: uint64 self_wakes = 8;
   */
  selfWakes = protoInt64.zero;

  /**
   * The total duration this task was scheduled prior to being polled, summed
   * across all poll cycles.
   *
   * Note that this includes only polls that have started, and does not
   * reflect any scheduled state where the task hasn't yet been polled.
   * Subtracting both `busy_time` (from the task's `PollStats`) and
   * `scheduled_time` from the total lifetime of the task results in the
   * amount of time it spent unable to progress because it was waiting on 
   * some resource.
   *
   * @generated from field: google.protobuf.Duration scheduled_time = 9;
   */
  scheduledTime?: Duration;

  constructor(data?: PartialMessage<Stats>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "rs.tokio.console.tasks.Stats";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "created_at", kind: "message", T: Timestamp },
    { no: 2, name: "dropped_at", kind: "message", T: Timestamp },
    { no: 3, name: "wakes", kind: "scalar", T: 4 /* ScalarType.UINT64 */ },
    { no: 4, name: "waker_clones", kind: "scalar", T: 4 /* ScalarType.UINT64 */ },
    { no: 5, name: "waker_drops", kind: "scalar", T: 4 /* ScalarType.UINT64 */ },
    { no: 6, name: "last_wake", kind: "message", T: Timestamp, opt: true },
    { no: 7, name: "poll_stats", kind: "message", T: PollStats },
    { no: 8, name: "self_wakes", kind: "scalar", T: 4 /* ScalarType.UINT64 */ },
    { no: 9, name: "scheduled_time", kind: "message", T: Duration },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Stats {
    return new Stats().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Stats {
    return new Stats().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Stats {
    return new Stats().fromJsonString(jsonString, options);
  }

  static equals(a: Stats | PlainMessage<Stats> | undefined, b: Stats | PlainMessage<Stats> | undefined): boolean {
    return proto3.util.equals(Stats, a, b);
  }
}

/**
 * @generated from message rs.tokio.console.tasks.DurationHistogram
 */
export class DurationHistogram extends Message<DurationHistogram> {
  /**
   * HdrHistogram.rs `Histogram` serialized to binary in the V2 format
   *
   * @generated from field: bytes raw_histogram = 1;
   */
  rawHistogram = new Uint8Array(0);

  /**
   * The histogram's maximum value.
   *
   * @generated from field: uint64 max_value = 2;
   */
  maxValue = protoInt64.zero;

  /**
   * The number of outliers which have exceeded the histogram's maximum value.
   *
   * @generated from field: uint64 high_outliers = 3;
   */
  highOutliers = protoInt64.zero;

  /**
   * The highest recorded outlier. This is only present if `high_outliers` is
   * greater than zero.
   *
   * @generated from field: optional uint64 highest_outlier = 4;
   */
  highestOutlier?: bigint;

  constructor(data?: PartialMessage<DurationHistogram>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "rs.tokio.console.tasks.DurationHistogram";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "raw_histogram", kind: "scalar", T: 12 /* ScalarType.BYTES */ },
    { no: 2, name: "max_value", kind: "scalar", T: 4 /* ScalarType.UINT64 */ },
    { no: 3, name: "high_outliers", kind: "scalar", T: 4 /* ScalarType.UINT64 */ },
    { no: 4, name: "highest_outlier", kind: "scalar", T: 4 /* ScalarType.UINT64 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DurationHistogram {
    return new DurationHistogram().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DurationHistogram {
    return new DurationHistogram().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DurationHistogram {
    return new DurationHistogram().fromJsonString(jsonString, options);
  }

  static equals(a: DurationHistogram | PlainMessage<DurationHistogram> | undefined, b: DurationHistogram | PlainMessage<DurationHistogram> | undefined): boolean {
    return proto3.util.equals(DurationHistogram, a, b);
  }
}

