/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.impl.DefaultFtpHandler;
import org.apache.ftpserver.impl.FtpHandler;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.ipfilter.MinaSessionFilter;
import org.apache.ftpserver.ipfilter.SessionFilter;
import org.apache.ftpserver.listener.nio.AbstractListener;
import org.apache.ftpserver.listener.nio.FtpHandlerAdapter;
import org.apache.ftpserver.listener.nio.FtpLoggingFilter;
import org.apache.ftpserver.listener.nio.FtpServerProtocolCodecFactory;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.firewall.Subnet;
import org.apache.mina.filter.logging.MdcInjectionFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioListener
extends AbstractListener {
    private final Logger LOG = LoggerFactory.getLogger(NioListener.class);
    private SocketAcceptor acceptor;
    private InetSocketAddress address;
    boolean suspended = false;
    private FtpHandler handler = new DefaultFtpHandler();
    private FtpServerContext context;

    @Deprecated
    public NioListener(String serverAddress, int port, boolean implicitSsl, SslConfiguration sslConfiguration, DataConnectionConfiguration dataConnectionConfig, int idleTimeout, List<InetAddress> blockedAddresses, List<Subnet> blockedSubnets) {
        super(serverAddress, port, implicitSsl, sslConfiguration, dataConnectionConfig, idleTimeout, blockedAddresses, blockedSubnets);
    }

    public NioListener(String serverAddress, int port, boolean implicitSsl, SslConfiguration sslConfiguration, DataConnectionConfiguration dataConnectionConfig, int idleTimeout, SessionFilter sessionFilter) {
        super(serverAddress, port, implicitSsl, sslConfiguration, dataConnectionConfig, idleTimeout, sessionFilter);
    }

    @Override
    public synchronized void start(FtpServerContext context) {
        if (!this.isStopped()) {
            throw new IllegalStateException("Listener already started");
        }
        try {
            this.context = context;
            this.acceptor = new NioSocketAcceptor(Runtime.getRuntime().availableProcessors());
            this.address = this.getServerAddress() != null ? new InetSocketAddress(this.getServerAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
            this.acceptor.setReuseAddress(true);
            this.acceptor.getSessionConfig().setReadBufferSize(2048);
            this.acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, this.getIdleTimeout());
            this.acceptor.getSessionConfig().setReceiveBufferSize(512);
            MdcInjectionFilter mdcFilter = new MdcInjectionFilter();
            this.acceptor.getFilterChain().addLast("mdcFilter", (IoFilter)mdcFilter);
            SessionFilter sessionFilter = this.getSessionFilter();
            if (sessionFilter != null) {
                this.acceptor.getFilterChain().addLast("sessionFilter", (IoFilter)new MinaSessionFilter(sessionFilter));
            }
            this.acceptor.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)context.getThreadPoolExecutor()));
            this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new FtpServerProtocolCodecFactory()));
            this.acceptor.getFilterChain().addLast("mdcFilter2", (IoFilter)mdcFilter);
            this.acceptor.getFilterChain().addLast("logger", (IoFilter)new FtpLoggingFilter());
            if (this.isImplicitSsl()) {
                SslFilter ssl_filter;
                SslConfiguration ssl_conf = this.getSslConfiguration();
                try {
                    ssl_filter = new SslFilter(ssl_conf.getSSLContext());
                }
                catch (GeneralSecurityException e) {
                    throw new FtpServerConfigurationException("SSL could not be initialized, check configuration");
                }
                if (ssl_conf.getClientAuth() == ClientAuth.NEED) {
                    ssl_filter.setNeedClientAuth(true);
                } else if (ssl_conf.getClientAuth() == ClientAuth.WANT) {
                    ssl_filter.setWantClientAuth(true);
                }
                if (ssl_conf.getEnabledProtocols() != null) {
                    ssl_filter.setEnabledProtocols(ssl_conf.getEnabledProtocols());
                }
                if (ssl_conf.getEnabledCipherSuites() != null) {
                    ssl_filter.setEnabledCipherSuites(ssl_conf.getEnabledCipherSuites());
                }
                this.acceptor.getFilterChain().addFirst("sslFilter", (IoFilter)ssl_filter);
            }
            this.handler.init(context, this);
            this.acceptor.setHandler((IoHandler)new FtpHandlerAdapter(context, this.handler));
            try {
                this.acceptor.bind((SocketAddress)this.address);
            }
            catch (IOException e) {
                throw new FtpServerConfigurationException("Failed to bind to address " + this.address + ", check configuration", e);
            }
            this.updatePort();
        }
        catch (RuntimeException e) {
            this.stop();
            throw e;
        }
    }

    private void updatePort() {
        this.setPort(this.acceptor.getLocalAddress().getPort());
    }

    @Override
    public synchronized void stop() {
        if (this.acceptor != null) {
            this.acceptor.unbind();
            this.acceptor.dispose();
            this.acceptor = null;
        }
        this.context = null;
    }

    @Override
    public boolean isStopped() {
        return this.acceptor == null;
    }

    @Override
    public boolean isSuspended() {
        return this.suspended;
    }

    @Override
    public synchronized void resume() {
        if (this.acceptor != null && this.suspended) {
            try {
                this.LOG.debug("Resuming listener");
                this.acceptor.bind((SocketAddress)this.address);
                this.LOG.debug("Listener resumed");
                this.updatePort();
                this.suspended = false;
            }
            catch (IOException e) {
                this.LOG.error("Failed to resume listener", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void suspend() {
        if (this.acceptor != null && !this.suspended) {
            this.LOG.debug("Suspending listener");
            this.acceptor.unbind();
            this.suspended = true;
            this.LOG.debug("Listener suspended");
        }
    }

    @Override
    public synchronized Set<FtpIoSession> getActiveSessions() {
        Map sessions = this.acceptor.getManagedSessions();
        HashSet<FtpIoSession> ftpSessions = new HashSet<FtpIoSession>();
        for (IoSession session : sessions.values()) {
            ftpSessions.add(new FtpIoSession(session, this.context));
        }
        return ftpSessions;
    }
}

