// -------------------- UIV+ VECTORS
//
// Generated from the python reference implementation
#[rustfmt::skip]
#[allow(clippy::type_complexity)]
const UIV_TEST_VECTORS : &[(bool, &str, &str, &str, &str, (&str, &str))] = &[
// All zeros, encrypt
(
    // Encrypt
    True,
    // (J,S)
    "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    // H
    "0000000000000000000000000000000000",
    // X_L
    "00000000000000000000000000000000",
    // X_R
    "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    // Output=(Y_L, Y_R)
    ("66e94bd4ef8a2c3b884cfa59ca342b2e", "66e94bd4ef8a2c3b884cfa59ca342b2e58e2fccefa7e3061367f1d57a4e7455a0388dace60b6a392f328c2b971b2fe78f795aaab494b5923f7fd89ff948bc1e0200211214e7394da2089b6acd093abe0c94da219118e297d7b7ebcbcc9c388f28ade7d85a8ee35616f7124a9d527029195b84d1b96c690ff2f2de30bf2ec89e00253786e126504f0dab90c48a30321de3345e6b0461e7c9e6c6b7afedde83f40deb3fa6794f8fd8f55a88dcbda9d68f2137cc9c83420077e7cf28ab2696b0df05d11452b58ac50aa2eb3a195b61b87e5c65a6dd5d7f7a84065d5a17ff46273086002496db63fa4b91bee387fa3030c95a73f8d0437e0915fbce5d7a62d8dab0a58b2431bc0bede02550f40238969ec780410befccde6944b69dd007debe39a9dbc5e24f519a4bdf478b1d9ec0b67125f28b06efaa55d79412ad628d45089c3c304f94db3a21df6cdaf6d2e2e3b355441eff64ad90527e752a4b2ebb4d0a1070ce2e2982e272fdb7cf4b584b095a0f957fdb828689437e37dc48b2ad379c6f3c6e957ee77afb88c65949ba12eec45c22865e4907ae42aee813898acdf91e2e4c21d828e0a76de2bb6bb6f869e5eef1f618dedd27562812b9a14e8996a5c352df3817e60d6ec20119a52c80a61ec195622627240212decca515feab63e2734587948a836a7de205cfec0c288351c"),
),
// All zeros, decrypt
(
    // Encrypt
    False,
    // (J,S)
    "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    // H
    "0000000000000000000000000000000000",
    // X_L
    "00000000000000000000000000000000",
    // X_R
    "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    // Output=(Y_L, Y_R)
    ("140f0f1011b5223d79587717ffd9ec3a", "66e94bd4ef8a2c3b884cfa59ca342b2e58e2fccefa7e3061367f1d57a4e7455a0388dace60b6a392f328c2b971b2fe78f795aaab494b5923f7fd89ff948bc1e0200211214e7394da2089b6acd093abe0c94da219118e297d7b7ebcbcc9c388f28ade7d85a8ee35616f7124a9d527029195b84d1b96c690ff2f2de30bf2ec89e00253786e126504f0dab90c48a30321de3345e6b0461e7c9e6c6b7afedde83f40deb3fa6794f8fd8f55a88dcbda9d68f2137cc9c83420077e7cf28ab2696b0df05d11452b58ac50aa2eb3a195b61b87e5c65a6dd5d7f7a84065d5a17ff46273086002496db63fa4b91bee387fa3030c95a73f8d0437e0915fbce5d7a62d8dab0a58b2431bc0bede02550f40238969ec780410befccde6944b69dd007debe39a9dbc5e24f519a4bdf478b1d9ec0b67125f28b06efaa55d79412ad628d45089c3c304f94db3a21df6cdaf6d2e2e3b355441eff64ad90527e752a4b2ebb4d0a1070ce2e2982e272fdb7cf4b584b095a0f957fdb828689437e37dc48b2ad379c6f3c6e957ee77afb88c65949ba12eec45c22865e4907ae42aee813898acdf91e2e4c21d828e0a76de2bb6bb6f869e5eef1f618dedd27562812b9a14e8996a5c352df3817e60d6ec20119a52c80a61ec195622627240212decca515feab63e2734587948a836a7de205cfec0c288351c"),
),
// All ones, encrypt
(
    // Encrypt
    True,
    // (J,S)
    "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
    // H
    "ffffffffffffffffffffffffffffffffff",
    // X_L
    "ffffffffffffffffffffffffffffffff",
    // X_R
    "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
    // Output=(Y_L, Y_R)
    ("7209baed4b605b158b7eb25de2200e83", "5546c0d2d8da37d92908803d88ff5a646e24a9f9c8c0e9f239726ccc5107d45ed813697aab0b27969930489e47c87475d71b92fc875e268d2ed92fa735b8258c657ff883512adf916a7a8819596e878415da7dc689fc658b862235133b4366e5bea11ece0990a544cb324e27313d67567797213ddb9102e75caca82a15035e44a306c906f8c17e2c88975808b35ad13443849d9ebec10f2c888738ff5b7cb3043b2bbd6098b167746addcc55238fb32d9ef404f3d0f7db0bc5f30aca0cf9ce5f87c989268d18b1069b33bbd5b7818a99603ec0d82871e75cffd1d84e2be1e0f8e8b3678b1ccd7a5a676d83fe0e68f09027ad912d58d2257932750b383e2f2fa3c889ee9d71919cc05d982230c6ff8b7e5e3ed302ed82bed429794c261aa009d231bb6c8675e513313432017cea50843a0309153f7f9d556330f19c38bc5ae6d33d63abaa7ebabd3335c1bf59a2121378288da679259bb1b8a8b027938f3e902c655c781e7f5d9514e53502e7ebc31e344344c3ae2a6397a9a8b846dab8a84174e91664804c7804bab09d6d40aeeb491d6f6184830ac7b5807418a05a7ab9938c3fdc18066b5d503f8c98e83be033b6fba905324267618cc6989b486e0decf7cc897d17be093286a4d4fb5016c3e3323ccc416a30473081473bd471e430194ec4e2ac0af3bca0577b78f4c70e4d"),
),
// All ones, decrypt
(
    // Encrypt
    False,
    // (J,S)
    "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
    // H
    "ffffffffffffffffffffffffffffffffff",
    // X_L
    "ffffffffffffffffffffffffffffffff",
    // X_R
    "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
    // Output=(Y_L, Y_R)
    ("a9166add184e00b007217cb4e4f52ee5", "c516fd6ce5172c45f85d10240fbeeada3699ca9b9c98cbbc9b92c12c1a459759e332751f270727b5235a3ffdc0fd102ef338438360402e9640b8586d4445f82936cc7efe2f3d71b89166adfbec5c83c36fba6f6572c8393458061ccdab00f4d15ee33292f59112fd744c53334c701f5af15d35ae23ca23edabe0a31ff9eecc9106992656fd859cbd3f6a6f2fa977f186402e5d8e5007deeeb9b61cc594b27c41f77c4c52b4cea539488fe838b757448e567e9870063935f79af81049177affbc898415f929911a164d78fef8b8beaffbbb775d2ff42e2aeab1f0e5153a50f48cfb6ffb078e8455ec3e51ff770d202071f759ed55ee57449b54d5b2d6d698afb5934bae5a9d8a48a93d2809a5548d79e8eab96c584ce2fb77fd4f319ca8ab688047ae44de222326a9b86a1ceadc033ca3303f9946abdaf74b2559a4b36f7c4ed5a32f7083ba6f9adc2a28ece0d866a66ffb8c58a91b7545456c04bd99cbfe27b4106c3930291fd03e886858ffb98e2de2c43ca34d165cbb25f5e93cff0c368849376d1f3d56ae879d413b85ae02b63a5b2b99df15a2065faa1763d2ab54004ff8fb3ede6e8abcc43e97c26c38a0028013339faf6d4e683a55a5566a45f3f1cc78f4f0aec5a1102629b03917679d8f635678920793e76e7e18f1b112d27895edb7f49b505001ab45b5370dcfbc27"),
),
// Pseudorandom 1, Encrypt
(
    // Encrypt
    True,
    // (J,S)
    "22169d562646db8ce3322daf9fa8e84bed57dac18beabdb619b40f5a02786e439e6132a5b7e7445ef962e2c7f30a0b2ec994ee1935e1787d6f89cbc15b9254d5",
    // H
    "81b1a82c63d8dd9f682f734e82e259a14b",
    // X_L
    "db4adc246c6a54fe55e11901f08f0eee",
    // X_R
    "dccb8aa0570982d5b08fa6b4fbb3bc7bcd7e1cb374f114fcdd0ed53255c523c1e8ecabfbaab00105af9933eff304a40877e3006be82417e44462fc6955777baf2f2f9c99966ddee30b7c65050dcc8f5d7bc22f9192e1c4a83ca0a2338deca9da4fed14058812ace259e9851f50c83d97515b647ff56749a3c615e1860a404e9b05619a48aa3e5f09779e72c77dfdd1ab5d796860178938efffb4e43bda443c2fba0d5be14baa375d881ee5e14d760a12c4d9807c8c54b714a75324c4074296ba8c86beceb4dc2337946f0af67c759d999d56aceebefd80438dc625b0b50f749440e8cd5bcee1afa05ff8cff1bfd3e0e68930b74b3baa7e6cb723896afc3098326716e0554319c9f8f3683a8fd359ae48a3591dac67adeea6e24600037cb1a42c38b23a9e7c31e6d0b13b84e88341458050856c476f6875dfe17806e0cd72baeebd0e1108fb13088a887153a1d13bac414ed120c26bda5bc08202fc1489746305dcda5dfc3e6a869b52d63654f3bc35841a2345df8691caf1de06d5ebd214af729e239efd62d05060eab13fb973ffb41f461224e2eee1f739529d37e8db40c065e52de7b8f19fbf695470341062c7f212d8cf5310cc17f487e04e8ed03fe50f3758eda9e41bf37af62f94709b16e01b4305d1a5ccad2bcacc7e35d4a1d1a40c26dbf3153739175ca65ab59cc1c9",
    // Output=(Y_L, Y_R)
    ("9ff8aec547f02caae7555ad7b0cb1372", "d2ceaad0ef52ac304d9550f0c365fa7728dca633f4f62228b241e47754dfa01c709e66f54a018e667573dbf5063c10a6167592250a8f6af17c68d5e190c5e8bdb40082b54e428ada58b3a805cdd56d87cc56591f8ac5f310eb37ce4d8a6ea6a80c3d7316f872aeb8a1a40ef7d1f0bbd1711d38c500eccc0acb88c1a3491ceee45bf82ba3fdf939dcbedb4f140fae21339f671df748d18e8bc8d72eb8e7cf18feafcd6f363345e2b05bc2d4d6f3affb8589d002aadb711d5ad2fa81398137b9e88f5a8663787e746bb878c0973d9b80145f8dd18bce30ea10e13ad07aeb469f62c4507ff8aaba09ed988a794232b5fc4e64466103366ed474fb99406fc80dd5ae5cb90001b1485476978dada0df83456feb3674ec7070b177871203410c5f7adbefbf5069c64bce59ef381514cb2a8d0804d855cca0a9c84d4c60c44e7242ffc479aabf357016166e9b184311c0e04dd9d1c512ae508b8f8c6bfdba68d46e338250f23668aaf11f45f57bfbc8e32d14ccab853af085a17405058ecd993cb21b41f8456c54a3900a50c270fc2b0931394ba257fd49bf79ae54d9c39a8504067b9cee1e42b688dcc606bee57006bc561b991dd10c56c129d1db8997e0d163fd06fca83249f146e348a4f35d0cb47d0ea6b3c6c587487f3816e13c2494d6d1e866fa182855cd668462a30b4e7019d2"),
),
// Pseudorandom 1, Decrypt
(
    // Encrypt
    False,
    // (J,S)
    "22169d562646db8ce3322daf9fa8e84bed57dac18beabdb619b40f5a02786e439e6132a5b7e7445ef962e2c7f30a0b2ec994ee1935e1787d6f89cbc15b9254d5",
    // H
    "81b1a82c63d8dd9f682f734e82e259a14b",
    // X_L
    "db4adc246c6a54fe55e11901f08f0eee",
    // X_R
    "dccb8aa0570982d5b08fa6b4fbb3bc7bcd7e1cb374f114fcdd0ed53255c523c1e8ecabfbaab00105af9933eff304a40877e3006be82417e44462fc6955777baf2f2f9c99966ddee30b7c65050dcc8f5d7bc22f9192e1c4a83ca0a2338deca9da4fed14058812ace259e9851f50c83d97515b647ff56749a3c615e1860a404e9b05619a48aa3e5f09779e72c77dfdd1ab5d796860178938efffb4e43bda443c2fba0d5be14baa375d881ee5e14d760a12c4d9807c8c54b714a75324c4074296ba8c86beceb4dc2337946f0af67c759d999d56aceebefd80438dc625b0b50f749440e8cd5bcee1afa05ff8cff1bfd3e0e68930b74b3baa7e6cb723896afc3098326716e0554319c9f8f3683a8fd359ae48a3591dac67adeea6e24600037cb1a42c38b23a9e7c31e6d0b13b84e88341458050856c476f6875dfe17806e0cd72baeebd0e1108fb13088a887153a1d13bac414ed120c26bda5bc08202fc1489746305dcda5dfc3e6a869b52d63654f3bc35841a2345df8691caf1de06d5ebd214af729e239efd62d05060eab13fb973ffb41f461224e2eee1f739529d37e8db40c065e52de7b8f19fbf695470341062c7f212d8cf5310cc17f487e04e8ed03fe50f3758eda9e41bf37af62f94709b16e01b4305d1a5ccad2bcacc7e35d4a1d1a40c26dbf3153739175ca65ab59cc1c9",
    // Output=(Y_L, Y_R)
    ("1c1593f30a020d44b7b2cf9b75204808", "c8135c678f97432394c2fa38ee6f590104a99028da2624a44d9a503adf1fe0d236ed5253d2e1cfca479c1b41609ef7cab58d7bb4d8e50e21108f837791f2e3066d3c40672f8e0f1a304d25ba20401a8aac6b15c1582788fe8996277b5cb554cd82e0920f212293b8bc4357349465f75e2f688a084d4c4741e2b384523d51cf94062cb7e6c1481eb48f1eb37e00937e0a2b2e12c88ac1b8ca2eef537b74b9f22e016b1a72818eddd1bde1e3643f4aa8fbf1e69543475131c17e8562c6c7d9a4375936fcc1c6ffeb131195e2168cd26368c3ab40f436563b4a5b6db2a7fa61e521321dad4d1aaaca8d0b38d68de26f402233d3bc25c78cd9019d2985f0f02c51cd07423726bd7ef3d19a8bb7b5a94d54ed86c460e7b02388fcedaa99902bc43c8339a171e89dc8123a9cd05287f2c0a39fdf24dd56dcf4326c163d38c9282d1f2f9a0faf50beb6e5caeb300a6192f6c1aaa5ba515bb677bb399edfcb05eab48870e79018d60ccdf3f1b5b6eb1e1a9e24a8a11da26c0919e6ec7db6a1260d6299e7a2830d48d3bf33b40f4c5cc0c4acae037a4bf5731fff732f44752bd002c8493f1d48ea6c5f0cbbd596d679c7130d687211e74a96473275f2c8df1634ad36aab16eb0221777e98f62057d669b51bee20ab45db78b619aa619a40245d9ddd074a35c54b77f7ccc0410c00719e423"),
),
// Pseudorandom 2, Encrypt
(
    // Encrypt
    True,
    // (J,S)
    "e61126a280c66e99171b1ec940a75ba6d4c3301062760a9ff9f9b332433b8408af4a49ad5326b95da7f501bb8b34bce8ce6e8c33f57263a4779a161d3736b7e4",
    // H
    "837d18ad2b0162977d3461349b00bcfdd7",
    // X_L
    "4b9fa9b1d31ada9a15d29cd0bd920a53",
    // X_R
    "c819e68a3dbdb6e730e4c9ed6dc11187f7ef0f021f63f0da32b55c8e2c78d4bc55d0e487329542e0b63a8f57313a146443cb5b8ba9eaf77d7e80884333b0e33b806da9cb32e231b5a23aa9ffa6f598df337126b26d6f9ef0d6c6a1bb59d83d253ea0ddc7272d633eb785dd7649fb7618a3b2c721cfba7d3e3d4a95fafcb90c2c60a52258ff3da3e1ab1205747e049e4730d734eaa5744a18fa8b8c4aed37d28857a5877839a40659e9754795859dad3163d6358234072ae62f64e58c861fd2225c60a708bb9b199e2070315e6d8eda8365b7cdaf5d067280086fda2a304ccbf3177fb0d34bbc3b02b4aaf42e535fbf2a15b782a8f3004eecda69aade92eb7bc92b6d552172bd26db28dcdf36547fa2794bf598db51ba0578f176e0cd3db04bf8333819a17f9c0d6faa9128930a3d8e93170d1bdf4e17a26f794631c870d9fd0edc73c3ce51753cbf59f3c942b689ccd08d8c0e0b19840b5113b760893b7d3b3a7c8f2c8794cab2f35a49d1d3f8c93bc353f376904d1961d3958cdc7a1841fe305c5c48b98f3b829ab1540876c3bd9d73e979107ab6f8146fe8acf33bde92b0a0ec2088dca60ae8374bda9d36977e5653762e8744d2b66d5bcc26dde754ec5eb3f665fbdd1ce2d0a7a48c499c0a5b846a7cb3c478484703c31ebb0c20c66bc1c1722529be0bb850d9bff7437ca7",
    // Output=(Y_L, Y_R)
    ("6db7f5e28e54c81ce9a22df58eef5f65", "bc742015a226d2f1f855c06e9c12ce9866a311622befc8ff5f796c1813308fecb8c91b7fdc00de93198498afeec55422f678fd1822131877c947236c4c978b0f0fc3d0ddeee5770bac3c635895d9b922399a0062e4c80b9ea753f89608ed6920fc2f8a9e09ba87b40c6ef2a9354524e7f0ac1d967ef520a348e37fccc35f584ed5270b7e4694cd263a25f8869e07693df3f9a5fbc6aa4f8697456fa830e07f6ab89d3ae18790b6208c09ec2cf530239bb7d514691a01b4a772233693dc398bc6b4a08e412dce4d3b3556c0aa8ad2d0ee474ef56c1dd232b677c2d38be103921b8373e9e1c8ef2e98ededce0439351e74ca751db03e8213cd6adb6ee5a7b3103675776b82e59120d21e4b4e03e01aa420c254530ed74c24dcc514ddb241450642dedd0c5b1a0f7c2a7af243b96f1d1312ff8448a0c3a2b9cdaa90c45d11fdd82e6b17bc83f246313d7d67dd380165ceac938f5cd7896ffb8c22669526345f42892e1cb2b5af64f39139e6f3d5ed8e03efa61d653bbfcdf387c9ccf9de686b9603a681143ccd21a12004c810acc7e9c17bbdeba632bc9e5f0c6d3cbf72c8e7b958fb66d38bdb77c1e170de541b0750d942e9f8bcf123bd4a369af220135816b6d9b09778a8bc5e0378ec82678c1344a978fd1b271376ac31ba3981a1639a3808a8cd35424daa91d59f6e34967434"),
),
// Pseudorandom 2, Decrypt
(
    // Encrypt
    False,
    // (J,S)
    "e61126a280c66e99171b1ec940a75ba6d4c3301062760a9ff9f9b332433b8408af4a49ad5326b95da7f501bb8b34bce8ce6e8c33f57263a4779a161d3736b7e4",
    // H
    "837d18ad2b0162977d3461349b00bcfdd7",
    // X_L
    "4b9fa9b1d31ada9a15d29cd0bd920a53",
    // X_R
    "c819e68a3dbdb6e730e4c9ed6dc11187f7ef0f021f63f0da32b55c8e2c78d4bc55d0e487329542e0b63a8f57313a146443cb5b8ba9eaf77d7e80884333b0e33b806da9cb32e231b5a23aa9ffa6f598df337126b26d6f9ef0d6c6a1bb59d83d253ea0ddc7272d633eb785dd7649fb7618a3b2c721cfba7d3e3d4a95fafcb90c2c60a52258ff3da3e1ab1205747e049e4730d734eaa5744a18fa8b8c4aed37d28857a5877839a40659e9754795859dad3163d6358234072ae62f64e58c861fd2225c60a708bb9b199e2070315e6d8eda8365b7cdaf5d067280086fda2a304ccbf3177fb0d34bbc3b02b4aaf42e535fbf2a15b782a8f3004eecda69aade92eb7bc92b6d552172bd26db28dcdf36547fa2794bf598db51ba0578f176e0cd3db04bf8333819a17f9c0d6faa9128930a3d8e93170d1bdf4e17a26f794631c870d9fd0edc73c3ce51753cbf59f3c942b689ccd08d8c0e0b19840b5113b760893b7d3b3a7c8f2c8794cab2f35a49d1d3f8c93bc353f376904d1961d3958cdc7a1841fe305c5c48b98f3b829ab1540876c3bd9d73e979107ab6f8146fe8acf33bde92b0a0ec2088dca60ae8374bda9d36977e5653762e8744d2b66d5bcc26dde754ec5eb3f665fbdd1ce2d0a7a48c499c0a5b846a7cb3c478484703c31ebb0c20c66bc1c1722529be0bb850d9bff7437ca7",
    // Output=(Y_L, Y_R)
    ("e6d9d943df0c57ffcf625bd142f023cc", "16fcd880981c22d459e61a502213668f6f040c57f9db8cf39fc07bce35a9df2e2cd083359e833944bb1da2d107caa11d171abfe5878787ca89c5460753a8df4c3af7d9e1091a68e1976eba0ba81005f60f1fb2f26b6163896070efb1c39e31d24bfcd23e897062645b5d5766ab81eef662ca789d4e5bf7aa76414d01acd67e9ec372e63f5a676fb4645cbff0c47b3ec0c667b781ac42a0fedb75eaf39fce4da7f37a660db56ca92836609ca32faa4987f232e89177cee0b45ab8d34ca1c9a9f29fcd057cc6e491387f75e01ffc40ddef01c0bb557803cb514afb19718a9b918ed266f5c3283d93b6fdd1232758f059a0f6f78b7d5e8cb0d61a7e974936b6bf007a0121db05051a3f3279c3b295de61af596f8ce8820480f666f963ad4c9af0490272f88eb01bdad77ca43c8d5cc3abf7b1d1b6b15890b43008d68ddbc9f2426985d6ef946cae5099b1b81eb500959d8e5571b438f796aafadfa85ae29e6373878f0eac3f91e75cd37c609064e57fc588bdba25f5f2cd095e14d01fe72ddb30f784fe97ccb7619ebe809a5acb24f73a69f9a3b348b99ff554fa316b4b16cb7cdcd79602ac17003057e7bff980521e43a57a43df4c13ed71740767ab277e1da09b371843aa1160b599b5cc0b1cb4c31d348718b64b9a6d66cd691185465ae5dcea649391b342bea21d430df41080"),
),
// Pseudorandom 3, Encrypt
(
    // Encrypt
    True,
    // (J,S)
    "f32563514c60b34aff6107deb5a324e97833eb0da2c49ca86c3c977974b18d2148fc035e8d2d7bd6f29cfadd9b947caefc5fe707827619134babb436252c0391",
    // H
    "a97040573c1aae79986f933d6286e6e069",
    // X_L
    "84a8b1973bd819e817aef7a866bd2016",
    // X_R
    "73e89e5eea49fdb60bc19671e46c47d404047a75b9e80ea4f433b473f66f10a4670dfe487d54c49b1e31feb4566effbf42c1f04322f629826d580671fc45ee4f3942d424cace60bd159cd5de7138f931682569afdefaa769cd61e46b4f9d38b9214d953b40889a18e26b116c5af9eb0efe4d8cdb60ba09380cd0abbf42382ca5376d52b9c9a4700b72834b3f64de998ac0b1a619cc944583db92c04bb98875bed6b4afa60080830b03e809e9de9d1ecc4f7714751d7fbf83060895b749aceefebd09b745a326e9c85c7eaf39b7adff950106ebb65ea809d7b22b166971ee931f41c1f6b2ad8f0ed9c29223ec008dbc6011749782c2c01ee5a9449329f75cda97dab10c0e0824ecb4f5aa26cab07236a1c6a997fedbe7bb0e92a3a6bc04bec72ccc87fd75268fe534124462595ef876ddddf5133315e70ad60a5c3e98c0aad8e07019874123b5bc37364a7e1bdeac5b3654c3e7509126fc0a47a14ba7200cbef264e2fa29fcd46230c510a1403b61feefeee659e4ce44cb76d723bfbc9a8e960d8d02aa62001dbf5e0f43bb688c7c43d8851b7a6e967dced63803310b7b34bac0b56ba041a0aad014ae6f3139590eaa2a993332ff47cb096d5a6e8fa39d924580d343989ccc9bca7b4b94c2778bc9abfa0c9dacb0e40745032520e923a7c2cc1f0599cb84620b9058af0b6c382f",
    // Output=(Y_L, Y_R)
    ("1cdf946d1d9305046d085170db0a9b3b", "500612a0471fd5323b63cb7af3899ae01b6408d84785ad9cd7e5ae5cb29d52d9df9702ee3d786172c175b3ce68c2a4f12ae294e491440e41a26f67ddb6f14b3137667093869ff76b04529d20a7ada5148d9238eb7334f0c4b4591e42f8950356aaec4f6db7408344559a24f5565238694c04ee6c175c6e76ddafdea6e2710e3e4bfbcedea81ce278f28c8b4407c6c077cd8d294528d568ded02f916a65a97394c7a51091ee52249df83c9b93252dd51aab1808c1bded4acd6bf2154699a247d7dc0a511d7c00d3fcb2bd84f5bb7604476e8169cac7ad70817f3c9ddfd1f28099dc41eb331790abab93a458b82559d3b176d77b7e759b0339567cf679b61a58fee7b4d4e532221dda47bc5cda437c0166258f8b2f2821a94e16bd24dc066993fee81db153f738ca29cc739e2afebb6f099e4ddf813dbfea6a6ce89e5112a2c9f52753ed72c06ba08a66741efc6504c206c5fe5b4029a06a86759666fe3c4711bbb52533e042bcd6cd08fdcf05e0937b629be8dc279a65463e41bc36fcb9fa04816b859bc3ab2ed638327e3849613ebdb1efd275b9097f8ab78114fd042e74ad83cd2d700a30f366027b173e4640bb8fbb838260a139d4119b78442d32f37a95545a539c7d5d02bf98c7576efedce0cbf68d05c101e4bfef4d20ebbaf84fe22b0160b5020b61eb7029173abdb232"),
),
// Pseudorandom 3, Decrypt
(
    // Encrypt
    False,
    // (J,S)
    "f32563514c60b34aff6107deb5a324e97833eb0da2c49ca86c3c977974b18d2148fc035e8d2d7bd6f29cfadd9b947caefc5fe707827619134babb436252c0391",
    // H
    "a97040573c1aae79986f933d6286e6e069",
    // X_L
    "84a8b1973bd819e817aef7a866bd2016",
    // X_R
    "73e89e5eea49fdb60bc19671e46c47d404047a75b9e80ea4f433b473f66f10a4670dfe487d54c49b1e31feb4566effbf42c1f04322f629826d580671fc45ee4f3942d424cace60bd159cd5de7138f931682569afdefaa769cd61e46b4f9d38b9214d953b40889a18e26b116c5af9eb0efe4d8cdb60ba09380cd0abbf42382ca5376d52b9c9a4700b72834b3f64de998ac0b1a619cc944583db92c04bb98875bed6b4afa60080830b03e809e9de9d1ecc4f7714751d7fbf83060895b749aceefebd09b745a326e9c85c7eaf39b7adff950106ebb65ea809d7b22b166971ee931f41c1f6b2ad8f0ed9c29223ec008dbc6011749782c2c01ee5a9449329f75cda97dab10c0e0824ecb4f5aa26cab07236a1c6a997fedbe7bb0e92a3a6bc04bec72ccc87fd75268fe534124462595ef876ddddf5133315e70ad60a5c3e98c0aad8e07019874123b5bc37364a7e1bdeac5b3654c3e7509126fc0a47a14ba7200cbef264e2fa29fcd46230c510a1403b61feefeee659e4ce44cb76d723bfbc9a8e960d8d02aa62001dbf5e0f43bb688c7c43d8851b7a6e967dced63803310b7b34bac0b56ba041a0aad014ae6f3139590eaa2a993332ff47cb096d5a6e8fa39d924580d343989ccc9bca7b4b94c2778bc9abfa0c9dacb0e40745032520e923a7c2cc1f0599cb84620b9058af0b6c382f",
    // Output=(Y_L, Y_R)
    ("fa3b9f620642a59de542bc8528216e22", "f621ee0172189b1f14eed6dc55d2d7e8cf7ecc6f72ab5a477a774fcf731e02be994ac02a0105b34c7a3d72a58b20646f1863c634e84977a8c92f677742d628c04daedd8369173556236a11a6cc6220a9db90cf98805885ffc599424a9798a63218abf0a11c74868e3444fd089ee71d578a4527afc0d7993345188b56407e478e2ee8ca7ace4d458acd27101b66d114f7e10a08971c0d61f4fb9a6d07acd25d81f6c0977c9cbad16ed587a5a0baeb69f5aa5c76aeae4bae5141d7b176f5876a3c4a62407d97833fcd2c83d6ed20954c5486422732a6a2ac3accf32f777e79a3d961b9274dca60685f4e170c0bb6e9685a51b390bc9efe36b41ffa137be17b018acf6fc15ae474e4d232609a30affef40741c59e4fc86eb08bea5643dd72a3615d99c70a65a96be9eb00c0b74a726e371bf08231755f19429b125a5a56bbe03a28fc32a920177d68f5d9eec0505c3fba1ce1c412f8856434526a6d15c1a0f11c4ad45740172afec416df395174d50c74fbe16d803acac8b318d6d6f2ec419625786ba69bf11d30b5b27e7c6254a87e5854b7dc11b94f67fc56a7b7174deb6360f087e2853adcb536e3f7494eaac5d29010b468e3b833d38e09c5c9adfca0605c2822e44df2561279ae1c8b6666d03c453239ff85899d93a4dc3d98ace0b63756ef7b98d7057879b4d3707b16f73b"),
),
// Pseudorandom 4, Encrypt
(
    // Encrypt
    True,
    // (J,S)
    "7c5f3d9842de08497272a35a2bd9d877af6afc3c9129a8f98d5b2bddd3c1fce97e80c0ad331c69cd85c1bc2af104066668d57b16c7ced48a950163522dcbc37f",
    // H
    "e75e52a81768470fab9b32245352f13511",
    // X_L
    "1cb4bee05ab1f045df3f32be190106dd",
    // X_R
    "00f2becfe9dbfef521fd09dabbad42d2246296090062c6ce100f32cbbe1a3656e30552aa27a5d686f7fafacecea10f152913bea3e2c1cf67c6193cb3964844e868a7bccf58a85eccb8ad2dfff58640c6a39081f4234ebb0b099fbe48b3d42b17e15eede1db369d5b73cd223f3d062aa63fca1e886a4a88bc4aeef9d4e4583754270f59da4b5bcaeb0e661ecd9ab342191019bcd4dab8fff6514a6a353215699e59884cbdcb4dad9ea7dce8acbd24aeb9ede406d14c61df9c48a95f3e9169d295f8fd5df19174325c0bf132855d7d23b72a23b18016a1e888e51b3484600f255de4922c51acc7092656ea162160fa9159a10ec7b1c081605028e0bf4641e1cbba629ad85ae9c75de4c73c08509bc36ce8405589500c3cf4f3a871bddaa77831dc105a9941da1dd594c79c53f130f72450c92dcdcba8b6311298ba5c1cbe3d82235ece74a2061622ece1e41d3a42eaab31d049b7843301647ce062668d7244a50cb37343621034ef825eadf3c47ebc246e44ff7c84e5fb92dd3b8a8d8b1e44867fe49a3bd8814513441dd4c4360305194dbbeb877101f595f0320343dcbb9843402ac3300a1f5e1a02f1141cee369e5dca27b105a305b1d75e99b50ddd2e9bf6c092ce0b95345dfdf2740c9d212186d8a9aff9d2d04b32ef61099240be6693e69eed715e0697e252798a2ee274f0",
    // Output=(Y_L, Y_R)
    ("85ffba80eb5137eee559745dceeee851", "56cc2ab8f82cff1f85db849b9d7db995e7b74bb6be3239acd16546a2dac80493715ec80729347718e05dfd5b034573a755a3e1515b91416042237edb076cf138243a76380e9bada8c21251363206fb3e88279867ea57b4f292c4bbd45738011a29390fd940ae37dda62a5dd6db715bdc194b26e67ca6689c5178cffdcb9be54d4df2ab36859a78dfd511cff3a86281379d331024ee4f55c7df67061d9a1e4971f6f6c5c3e83ecb37465e3bf2b458e8a51e9f1fdfd1d31a4880b8dcaf5871611ca587034a9c7c568e0dc226e0bc675a4296e342be2817445028f5dde58326db1c383ca0dc2802ac65e91171d555fafcafc9a2d03e6addaec0c6af841cdfb5854c1fa847103afe93257584f4cafb6d97efa602d7c7c9ac47e64e1205052a67c18fbe3e2f55e53293f4de94c2a6e59c6bbe84efb1f1954cdc4b99c056e8f5ade24b8c1a8c889538cdd24a350bf26edef57a65d1cdd7bd8573097d0f3867e2276f21bbafcf0cd5c169eef214d75520a756e7398716fdeaf91f95ed067e606ae35c30b22bcf83030c7f08ad0a31d00d9a5aca0540fa46e4034643a7b03567949b4407aadc3187bfffaaad00c950e187c295fa31418c858023057c61616e9d8aec7c96e3b64f131f209ad61ddc2c3ada91a93baf5307b3e7028f243b0816fc6556c5e840ccd6519e779ce5d76b947692"),
),
// Pseudorandom 4, Decrypt
(
    // Encrypt
    False,
    // (J,S)
    "7c5f3d9842de08497272a35a2bd9d877af6afc3c9129a8f98d5b2bddd3c1fce97e80c0ad331c69cd85c1bc2af104066668d57b16c7ced48a950163522dcbc37f",
    // H
    "e75e52a81768470fab9b32245352f13511",
    // X_L
    "1cb4bee05ab1f045df3f32be190106dd",
    // X_R
    "00f2becfe9dbfef521fd09dabbad42d2246296090062c6ce100f32cbbe1a3656e30552aa27a5d686f7fafacecea10f152913bea3e2c1cf67c6193cb3964844e868a7bccf58a85eccb8ad2dfff58640c6a39081f4234ebb0b099fbe48b3d42b17e15eede1db369d5b73cd223f3d062aa63fca1e886a4a88bc4aeef9d4e4583754270f59da4b5bcaeb0e661ecd9ab342191019bcd4dab8fff6514a6a353215699e59884cbdcb4dad9ea7dce8acbd24aeb9ede406d14c61df9c48a95f3e9169d295f8fd5df19174325c0bf132855d7d23b72a23b18016a1e888e51b3484600f255de4922c51acc7092656ea162160fa9159a10ec7b1c081605028e0bf4641e1cbba629ad85ae9c75de4c73c08509bc36ce8405589500c3cf4f3a871bddaa77831dc105a9941da1dd594c79c53f130f72450c92dcdcba8b6311298ba5c1cbe3d82235ece74a2061622ece1e41d3a42eaab31d049b7843301647ce062668d7244a50cb37343621034ef825eadf3c47ebc246e44ff7c84e5fb92dd3b8a8d8b1e44867fe49a3bd8814513441dd4c4360305194dbbeb877101f595f0320343dcbb9843402ac3300a1f5e1a02f1141cee369e5dca27b105a305b1d75e99b50ddd2e9bf6c092ce0b95345dfdf2740c9d212186d8a9aff9d2d04b32ef61099240be6693e69eed715e0697e252798a2ee274f0",
    // Output=(Y_L, Y_R)
    ("e8e2cd1a866b3715098b96ec81f653c5", "b321b32509f40b5c1895ae2a8e9a15aced718c29e5b2af8280f37e5a2dba3856430a68d36dd7b888008a6ac99184c7fc908402f817a0554b9e7dbedd442372401ae1ee6c70c05ed45d7c332a40b0bb63aa1375208d7bcc7b483f3669b745c5dd9a08fad615b3edff5c4890d950c5ab94739474c952c3356cc8d2860e373258fda0c37da59b80375a78dea30543576b5fe482175c59de400e69ee781294f88b8fc8a3bac1219952f2458975f201f3dc2bac0264d5b2981229236386987e218d00b5961e3deac39e38786ba117cb7d8ae36632d09b3784eab1523e68ca068a6b0fb61753a2d042930ccf402681ea2efce09b072e145091b6fd74a3038b3dd424bd490acd828bb767327f4acf4c0684c807883501b64fc62de719940d8489ddf07e817928fe7b997239eb67395eaf4863c07f084b2cf442542914b7aae8210189d5b32c72198c5f0f1151c889ad630d3deba2a6285d89907cbab3c175654ba62ea29afe0c505fbf56479a888e4e4b5106cce8711964692e085ac16834fc95dd1e76e160018ab976154de883878b723a56ef7b80970fc0c429955f1d3de931235c69c29d00a8a53515aff2bf9f4320a878109ccab6c5f4449a86b8ebaace77467d6bbae5850b8fb6d3368d0622a8bd70faf429fe5620a67cb736d8f4bcebc281643deab5007fb6f1604d8e9c1daaa1"),
),
];

// -------------------- UIV+ KEY UPDATE VECTORS
#[rustfmt::skip]
const UIV_UPDATE_TEST_VECTORS: &[(&str, &str, (&str, &str))] = &[
    (
        // (J,S)
        "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        // N
        "00000000000000000000000000000000",
        // Output=((J',S'), N')
        ("7941dd0a63d994703e63d94a446804213ab4fb1d2b7ba376590a2c241d1f508dc6a7f418a14503deb89b17aadb2806f73fc06e5d14e675f5ec880023d4f73296", "12dce4a0e5bc792b5b5a55f9c2f30e07"),
    ),
    // All ones
    (
        // (J,S)
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
        // N
        "ffffffffffffffffffffffffffffffff",
        // Output=((J',S'), N')
        ("be938fc23009440bfb5d7bba1d28428ec0897793bb878b8e1eb3ec1257b88024d551d770b56c9312de3dd4ac64e194c91185a89f2ba01f90b03b3acb93f634df", "4b263f03af0acda2f9721d0f4c0783c7"),
    ),
    // Pseudorandom 1
    (
        // (J,S)
        "bf9b13b7097f5eee96b15423348ebf7aa13da31a2955a72ff17c7f75f9fd92f3280bb2d8992bc2a5f70f8e4e10f0404f16f3a0bbb91975bae7e11180adcba6da",
        // N
        "1ecb6e1ee6f0531c233676fd1c3ca701",
        // Output=((J',S'), N')
        ("4c03bdb301aaa20b907ac88ecd3174bb1b476a00a81ad67cb4eceba22354ce8f241ab2da59d565781634e9252358006b5b78166ea59028e1ff40a71687dd2f11", "30151c332e40594324ef033a469d4f50"),
    ),
    // Pseudorandom 2
    (
        // (J,S)
        "e773e6211d22f03e0220bd6e69803b2d0bfbd6321a9e0184e49660bc1989318a868d5ccd3f769537c4990df2998cddc14cd853d8614c6e7e3548af9c824b457d",
        // N
        "d8097e67afff2d56a6279229cfb37f29",
        // Output=((J',S'), N')
        ("c9f14480f4d46a1e40ba3daaab9004ec0e7afab84f3c60da9f7f01ab46aab7a81e2138eed6f141047bc4169013450134586120852ca9a952417b402834fbedf4", "c79fdf8d9ae28e55eaed6e556e12b994"),
    ),
    // Pseudorandom 3
    (
        // (J,S)
        "a150329bf382e5c3b11619ac72ac3b2cdf55b19e94fd2f92bfca40ef540274ba571c53695d5d8f0d4d4935d2b599ee095754d3bbdd9929d60997eb4f745e0a48",
        // N
        "071652e3ea1b1d299ac07ab3df431090",
        // Output=((J',S'), N')
        ("7c7a284801c7aa0f727f8e24b87a2dca1b7550577924490291a7343924dfd1b9e2b86e4f7db39b77715888f7d3b9aa4ea44bd72a8b1eb79df0d46f25c130fc87", "3c8ecadfbe9ee9587332a6568c7f2476"),
    ),
    // Pseudorandom 4
    (
        // (J,S)
        "224dce00e26bdee463ac8b09cfda8d82a1e647f5f15ee3ed76c14ff92d57d01f2070c03304c5f08e0ddfae4690e8cf8ff52b07a739eb3b71c969d0bd5ed76567",
        // N
        "059945a49806db09e60fa6921759fc02",
        // Output=((J',S'), N')
        ("879021aaaac098d329495a3f6628d95bd0b3fd8f65ccf5178cdd7a70db387d7436c124ea0df1527a9e2deb3a6c8d3f2a21917711bf07ca81c4b91cbe1942cf6f", "91c08d6ba88ba4c4f3e50963dce7810e"),
    ),
    // Pseudorandom 5
    (
        // (J,S)
        "ba31312925f0ea4813b7400649ca7789ce36f0c8718d7a8752f115c00735a0a3e50859cf07b4099fb75728ed7a766a70edcb272798abb191de1cb2a46f902c73",
        // N
        "018e3929ab803e9b6e5fb4bd9c1fc9e1",
        // Output=((J',S'), N')
        ("5b3fed0efa4afdb6fab2c29346fdafc336f167d06a086ac78e3a013785fefb9eb05b31627f69c445a1112d9af941f8c59d104d51641ef52e00eaddde94f1ba23", "043530b4018b60c5d8b86a3b9e97b32c"),
    ),
    // Pseudorandom 6
    (
        // (J,S)
        "56fa9180e02b1d96fff07cb4502375e5c480fbd85f70650e13445b4f3c4228a671d1d3b4cf3582d8f33c9e1cbd0aa46fdbc41b5d24ed3e7f8ffd1f74daed66ec",
        // N
        "15073ad51ed0714a57318835edb35fb8",
        // Output=((J',S'), N')
        ("874955b320a46fa2d80e856614743407965e384381db357165c367d6995a388bd6f447e05eb667ce10938555db1bb3aba224557ed360cba7603d925e271f415f", "e43aeccc0c8129742cf12ae1e42c0983"),
    ),
    // Pseudorandom 7
    (
        // (J,S)
        "df4223c9f3190f08cbd9e531f8d14cdb3b056198819c3eed402376f55aeca2664969d9dcbffc98355dd52e11c38c1507cf35600ba151008c34842b245540db6e",
        // N
        "7c965af0577c48c6d3b65ef56f99f8f2",
        // Output=((J',S'), N')
        ("4438c11facc50013bd52f53858fc5b7dfdabe6169806a583b372a344518a97e3106d136b8f3ac7d3e41eab03eb5730c334183f9cc555a587af0bfbfd1ea67bd1", "bb7751edce82fa0392a5879f870c86bb"),
    ),
    // Pseudorandom 8
    (
        // (J,S)
        "602a99f4000ea3fc0488c7677df13014aac62ff3b6f7b6e2b5c7e72a742d488817bcd049f0e019fd191646841ab3f110e72b05c619c8258b746acb675b1fdd91",
        // N
        "690b56403667d406a41f73c179949b1d",
        // Output=((J',S'), N')
        ("8af4ecc5a27a35ba0863256e61764f2e7cc76432ae80b206ac512ce32e4f886900088e2652cc99805e2b70c8155bf68b401c11e66ddc944a148c715d761af935", "23475d0e7d14e5177c8498a1f2e72261"),
    ),
];
