/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Loader;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.ExtensionElementFactory;
import com.icl.saxon.style.LiteralResultElement;
import com.icl.saxon.style.SAXONAssign;
import com.icl.saxon.style.SAXONDoctype;
import com.icl.saxon.style.SAXONEntityRef;
import com.icl.saxon.style.SAXONFunction;
import com.icl.saxon.style.SAXONGroup;
import com.icl.saxon.style.SAXONHandler;
import com.icl.saxon.style.SAXONItem;
import com.icl.saxon.style.SAXONPreview;
import com.icl.saxon.style.SAXONReturn;
import com.icl.saxon.style.SAXONWhile;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLApplyImports;
import com.icl.saxon.style.XSLApplyTemplates;
import com.icl.saxon.style.XSLAttribute;
import com.icl.saxon.style.XSLAttributeSet;
import com.icl.saxon.style.XSLCallTemplate;
import com.icl.saxon.style.XSLChoose;
import com.icl.saxon.style.XSLComment;
import com.icl.saxon.style.XSLCopy;
import com.icl.saxon.style.XSLCopyOf;
import com.icl.saxon.style.XSLDecimalFormat;
import com.icl.saxon.style.XSLDocument;
import com.icl.saxon.style.XSLElement;
import com.icl.saxon.style.XSLFallback;
import com.icl.saxon.style.XSLForEach;
import com.icl.saxon.style.XSLIf;
import com.icl.saxon.style.XSLImport;
import com.icl.saxon.style.XSLInclude;
import com.icl.saxon.style.XSLKey;
import com.icl.saxon.style.XSLMessage;
import com.icl.saxon.style.XSLNamespaceAlias;
import com.icl.saxon.style.XSLNumber;
import com.icl.saxon.style.XSLOtherwise;
import com.icl.saxon.style.XSLOutput;
import com.icl.saxon.style.XSLParam;
import com.icl.saxon.style.XSLPreserveSpace;
import com.icl.saxon.style.XSLProcessingInstruction;
import com.icl.saxon.style.XSLScript;
import com.icl.saxon.style.XSLSort;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.style.XSLTemplate;
import com.icl.saxon.style.XSLText;
import com.icl.saxon.style.XSLValueOf;
import com.icl.saxon.style.XSLVariable;
import com.icl.saxon.style.XSLWhen;
import com.icl.saxon.style.XSLWithParam;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NodeFactory;
import java.util.Hashtable;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.xml.sax.Locator;

public class StyleNodeFactory
implements NodeFactory {
    Hashtable userStyles = new Hashtable();
    NamePool namePool;
    StandardNames sn;
    static /* synthetic */ Class class$com$icl$saxon$style$LiteralResultElement;
    static /* synthetic */ Class class$com$icl$saxon$style$AbsentExtensionElement;

    public StyleNodeFactory(NamePool namePool) {
        this.namePool = namePool;
        this.sn = namePool.getStandardNames();
    }

    public StandardNames getStandardNames() {
        return this.namePool.getStandardNames();
    }

    public ElementImpl makeElementNode(NodeInfo nodeInfo, int n, AttributeCollection attributeCollection, int[] nArray, int n2, Locator locator, int n3) {
        Object object;
        Class clazz;
        int n4;
        StyleElement styleElement;
        boolean bl = nodeInfo instanceof XSLStyleSheet;
        String string = null;
        int n5 = -1;
        if (locator != null) {
            string = locator.getSystemId();
            n5 = locator.getLineNumber();
        }
        if ((styleElement = this.makeXSLElement(n4 = n & 0xFFFFF)) != null) {
            try {
                styleElement.setNamespaceDeclarations(nArray, n2);
                styleElement.initialise(n, attributeCollection, nodeInfo, string, n5, n3);
                if (styleElement instanceof XSLStyleSheet) {
                    styleElement.processVersionAttribute(this.sn.VERSION);
                    styleElement.processExtensionElementAttribute(this.sn.EXTENSION_ELEMENT_PREFIXES);
                    styleElement.processExcludedNamespaces(this.sn.EXCLUDE_RESULT_PREFIXES);
                }
            }
            catch (TransformerException transformerException) {
                styleElement.setValidationError(transformerException, 2);
            }
            return styleElement;
        }
        short s = this.namePool.getURICode(n);
        String string2 = this.namePool.getLocalName(n);
        Class clazz2 = class$com$icl$saxon$style$LiteralResultElement == null ? (class$com$icl$saxon$style$LiteralResultElement = StyleNodeFactory.class$("com.icl.saxon.style.LiteralResultElement")) : class$com$icl$saxon$style$LiteralResultElement;
        StyleElement styleElement2 = null;
        boolean bl2 = false;
        if (s == 4) {
            styleElement2 = this.makeExsltFunctionsElement(n4);
            if (styleElement2 != null) {
                clazz2 = styleElement2.getClass();
                bl2 = true;
            }
        } else if (s == 3 && (styleElement2 = this.makeSaxonElement(n4)) != null) {
            clazz2 = styleElement2.getClass();
            bl2 = true;
        }
        if (styleElement2 == null) {
            styleElement2 = new LiteralResultElement();
        }
        styleElement2.setNamespaceDeclarations(nArray, n2);
        try {
            styleElement2.initialise(n, attributeCollection, nodeInfo, string, n5, n3);
            styleElement2.processExtensionElementAttribute(this.sn.XSL_EXTENSION_ELEMENT_PREFIXES);
            styleElement2.processExcludedNamespaces(this.sn.XSL_EXCLUDE_RESULT_PREFIXES);
            styleElement2.processVersionAttribute(this.sn.XSL_VERSION);
        }
        catch (TransformerException transformerException) {
            styleElement2.setValidationError(transformerException, 2);
        }
        TransformerConfigurationException transformerConfigurationException = null;
        Class clazz3 = clazz = class$com$icl$saxon$style$LiteralResultElement == null ? (class$com$icl$saxon$style$LiteralResultElement = StyleNodeFactory.class$("com.icl.saxon.style.LiteralResultElement")) : class$com$icl$saxon$style$LiteralResultElement;
        if (s == 2) {
            transformerConfigurationException = new TransformerConfigurationException("Unknown XSLT element: " + string2);
            clazz = class$com$icl$saxon$style$AbsentExtensionElement == null ? (class$com$icl$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("com.icl.saxon.style.AbsentExtensionElement")) : class$com$icl$saxon$style$AbsentExtensionElement;
            styleElement2.setValidationError(transformerConfigurationException, 2);
        } else if (s == 3 || s == 4) {
            if (bl || styleElement2.isExtensionNamespace(s)) {
                if (bl2) {
                    clazz = clazz2;
                } else {
                    clazz = class$com$icl$saxon$style$AbsentExtensionElement == null ? (class$com$icl$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("com.icl.saxon.style.AbsentExtensionElement")) : class$com$icl$saxon$style$AbsentExtensionElement;
                    transformerConfigurationException = new TransformerConfigurationException("Unknown Saxon extension element: " + string2);
                    styleElement2.setValidationError(transformerConfigurationException, 3);
                }
            } else {
                clazz = class$com$icl$saxon$style$LiteralResultElement == null ? (class$com$icl$saxon$style$LiteralResultElement = StyleNodeFactory.class$("com.icl.saxon.style.LiteralResultElement")) : class$com$icl$saxon$style$LiteralResultElement;
            }
        } else if (styleElement2.isExtensionNamespace(s) && !bl) {
            object = new Integer(n & 0xFFFFF);
            clazz = (Class)this.userStyles.get(object);
            if (clazz == null) {
                ExtensionElementFactory extensionElementFactory = this.getFactory(s);
                if (extensionElementFactory != null && (clazz = extensionElementFactory.getExtensionClass(string2)) != null) {
                    this.userStyles.put(object, clazz);
                }
                if (clazz == null) {
                    clazz = class$com$icl$saxon$style$AbsentExtensionElement == null ? (class$com$icl$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("com.icl.saxon.style.AbsentExtensionElement")) : class$com$icl$saxon$style$AbsentExtensionElement;
                    transformerConfigurationException = new TransformerConfigurationException("Unknown extension element");
                    styleElement2.setValidationError(transformerConfigurationException, 3);
                }
            }
        } else {
            Class clazz4 = clazz = class$com$icl$saxon$style$LiteralResultElement == null ? (class$com$icl$saxon$style$LiteralResultElement = StyleNodeFactory.class$("com.icl.saxon.style.LiteralResultElement")) : class$com$icl$saxon$style$LiteralResultElement;
        }
        if (!clazz.equals(clazz2)) {
            try {
                object = (StyleElement)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new TransformerFactoryConfigurationError(instantiationException, "Failed to create instance of " + clazz.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TransformerFactoryConfigurationError(illegalAccessException, "Failed to access class " + clazz.getName());
            }
            ((StyleElement)object).substituteFor(styleElement2);
        } else {
            object = styleElement2;
        }
        return object;
    }

    private StyleElement makeXSLElement(int n) {
        StyleElement styleElement = null;
        if (n == this.sn.XSL_APPLY_IMPORTS) {
            styleElement = new XSLApplyImports();
        } else if (n == this.sn.XSL_APPLY_TEMPLATES) {
            styleElement = new XSLApplyTemplates();
        } else if (n == this.sn.XSL_ATTRIBUTE) {
            styleElement = new XSLAttribute();
        } else if (n == this.sn.XSL_ATTRIBUTE_SET) {
            styleElement = new XSLAttributeSet();
        } else if (n == this.sn.XSL_CALL_TEMPLATE) {
            styleElement = new XSLCallTemplate();
        } else if (n == this.sn.XSL_CHOOSE) {
            styleElement = new XSLChoose();
        } else if (n == this.sn.XSL_COMMENT) {
            styleElement = new XSLComment();
        } else if (n == this.sn.XSL_COPY) {
            styleElement = new XSLCopy();
        } else if (n == this.sn.XSL_COPY_OF) {
            styleElement = new XSLCopyOf();
        } else if (n == this.sn.XSL_DECIMAL_FORMAT) {
            styleElement = new XSLDecimalFormat();
        } else if (n == this.sn.XSL_DOCUMENT) {
            styleElement = new XSLDocument();
        } else if (n == this.sn.XSL_ELEMENT) {
            styleElement = new XSLElement();
        } else if (n == this.sn.XSL_FALLBACK) {
            styleElement = new XSLFallback();
        } else if (n == this.sn.XSL_FOR_EACH) {
            styleElement = new XSLForEach();
        } else if (n == this.sn.XSL_IF) {
            styleElement = new XSLIf();
        } else if (n == this.sn.XSL_IMPORT) {
            styleElement = new XSLImport();
        } else if (n == this.sn.XSL_INCLUDE) {
            styleElement = new XSLInclude();
        } else if (n == this.sn.XSL_KEY) {
            styleElement = new XSLKey();
        } else if (n == this.sn.XSL_MESSAGE) {
            styleElement = new XSLMessage();
        } else if (n == this.sn.XSL_NUMBER) {
            styleElement = new XSLNumber();
        } else if (n == this.sn.XSL_NAMESPACE_ALIAS) {
            styleElement = new XSLNamespaceAlias();
        } else if (n == this.sn.XSL_OTHERWISE) {
            styleElement = new XSLOtherwise();
        } else if (n == this.sn.XSL_OUTPUT) {
            styleElement = new XSLOutput();
        } else if (n == this.sn.XSL_PARAM) {
            styleElement = new XSLParam();
        } else if (n == this.sn.XSL_PRESERVE_SPACE) {
            styleElement = new XSLPreserveSpace();
        } else if (n == this.sn.XSL_PROCESSING_INSTRUCTION) {
            styleElement = new XSLProcessingInstruction();
        } else if (n == this.sn.XSL_SCRIPT) {
            styleElement = new XSLScript();
        } else if (n == this.sn.XSL_SORT) {
            styleElement = new XSLSort();
        } else if (n == this.sn.XSL_STRIP_SPACE) {
            styleElement = new XSLPreserveSpace();
        } else if (n == this.sn.XSL_STYLESHEET) {
            styleElement = new XSLStyleSheet();
        } else if (n == this.sn.XSL_TEMPLATE) {
            styleElement = new XSLTemplate();
        } else if (n == this.sn.XSL_TEXT) {
            styleElement = new XSLText();
        } else if (n == this.sn.XSL_TRANSFORM) {
            styleElement = new XSLStyleSheet();
        } else if (n == this.sn.XSL_VALUE_OF) {
            styleElement = new XSLValueOf();
        } else if (n == this.sn.XSL_VARIABLE) {
            styleElement = new XSLVariable();
        } else if (n == this.sn.XSL_WITH_PARAM) {
            styleElement = new XSLWithParam();
        } else if (n == this.sn.XSL_WHEN) {
            styleElement = new XSLWhen();
        }
        return styleElement;
    }

    private StyleElement makeSaxonElement(int n) {
        StyleElement styleElement = null;
        if (n == this.sn.SAXON_ASSIGN) {
            styleElement = new SAXONAssign();
        } else if (n == this.sn.SAXON_ENTITY_REF) {
            styleElement = new SAXONEntityRef();
        } else if (n == this.sn.SAXON_DOCTYPE) {
            styleElement = new SAXONDoctype();
        } else if (n == this.sn.SAXON_FUNCTION) {
            styleElement = new SAXONFunction();
        } else if (n == this.sn.SAXON_GROUP) {
            styleElement = new SAXONGroup();
        } else if (n == this.sn.SAXON_HANDLER) {
            styleElement = new SAXONHandler();
        } else if (n == this.sn.SAXON_ITEM) {
            styleElement = new SAXONItem();
        } else if (n == this.sn.SAXON_OUTPUT) {
            styleElement = new XSLDocument();
        } else if (n == this.sn.SAXON_PREVIEW) {
            styleElement = new SAXONPreview();
        } else if (n == this.sn.SAXON_RETURN) {
            styleElement = new SAXONReturn();
        } else if (n == this.sn.SAXON_SCRIPT) {
            styleElement = new XSLScript();
        } else if (n == this.sn.SAXON_WHILE) {
            styleElement = new SAXONWhile();
        }
        return styleElement;
    }

    private StyleElement makeExsltFunctionsElement(int n) {
        if (n == this.sn.EXSLT_FUNC_FUNCTION) {
            return new SAXONFunction();
        }
        if (n == this.sn.EXSLT_FUNC_RESULT) {
            return new SAXONReturn();
        }
        return null;
    }

    private ExtensionElementFactory getFactory(short s) {
        ExtensionElementFactory extensionElementFactory;
        String string = this.namePool.getURIFromNamespaceCode(s);
        int n = string.lastIndexOf(47);
        if (n < 0 || n == string.length() - 1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        try {
            extensionElementFactory = (ExtensionElementFactory)Loader.getInstance(string2);
        }
        catch (Exception exception) {
            return null;
        }
        return extensionElementFactory;
    }

    public boolean isElementAvailable(String string, String string2) {
        short s;
        ExtensionElementFactory extensionElementFactory;
        StyleElement styleElement;
        int n = this.namePool.getFingerprint(string, string2);
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (n == -1) {
                return false;
            }
            styleElement = this.makeXSLElement(n);
            if (styleElement != null) {
                return styleElement.isInstruction();
            }
        }
        if (string.equals("http://icl.com/saxon")) {
            if (n == -1) {
                return false;
            }
            styleElement = this.makeSaxonElement(n);
            if (styleElement != null) {
                return styleElement.isInstruction();
            }
        }
        if ((extensionElementFactory = this.getFactory(s = this.namePool.getCodeForURI(string))) == null) {
            return false;
        }
        Class clazz = extensionElementFactory.getExtensionClass(string2);
        return clazz != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

