/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.evpull.BracketedDocumentIterator;
import net.sf.saxon.evpull.BracketedElementIterator;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorOverSequence;
import net.sf.saxon.evpull.EventStackIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.SingletonEventIterator;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTreeEventIterator;

public class Decomposer
implements EventIterator {
    private EventIterator base;
    private PipelineConfiguration pipe;

    public Decomposer(EventIterator base, PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.base = EventStackIterator.flatten(base);
    }

    public Decomposer(NodeInfo node, PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.base = new SingletonEventIterator(node);
    }

    public PullEvent next() throws XPathException {
        PullEvent pe = this.base.next();
        if (pe instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)pe;
            switch (node.getNodeKind()) {
                case 9: {
                    if (node instanceof TinyNodeImpl) {
                        return new TinyTreeEventIterator((TinyNodeImpl)node, this.pipe);
                    }
                    AxisIterator content = node.iterateAxis((byte)3);
                    EventIteratorOverSequence contentEvents = new EventIteratorOverSequence(content);
                    return new BracketedDocumentIterator(new Decomposer(contentEvents, this.pipe));
                }
                case 1: {
                    NodeInfo att;
                    if (node instanceof TinyNodeImpl) {
                        return new TinyTreeEventIterator((TinyNodeImpl)node, this.pipe);
                    }
                    AxisIterator content = node.iterateAxis((byte)3);
                    EventIteratorOverSequence contentEvents = new EventIteratorOverSequence(content);
                    StartElementEvent see = new StartElementEvent(this.pipe);
                    see.setNameCode(node.getNameCode());
                    see.setTypeCode(node.getTypeAnnotation());
                    see.setLocalNamespaces(node.getDeclaredNamespaces(null));
                    AxisIterator atts = node.iterateAxis((byte)2);
                    while ((att = (NodeInfo)atts.next()) != null) {
                        see.addAttribute(att);
                    }
                    return new BracketedElementIterator(see, new Decomposer(contentEvents, this.pipe), EndElementEvent.getInstance());
                }
            }
            return node;
        }
        return pe;
    }

    public boolean isFlatSequence() {
        return false;
    }
}

