/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.ComputableValue;
import com.xmlcalabash.model.EndPoint;
import com.xmlcalabash.model.Environment;
import com.xmlcalabash.model.NamespaceBinding;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class Option
extends EndPoint
implements ComputableValue {
    private QName name = null;
    private boolean required = false;
    private String select = null;
    private String type = null;
    private XdmNode typeNode = null;
    private Vector<NamespaceBinding> nsBindings = new Vector();

    public Option(XProcRuntime xProcRuntime, XdmNode xdmNode) {
        super(xProcRuntime, xdmNode);
    }

    public void setName(QName qName) {
        this.name = qName;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    public void setType(String string, XdmNode xdmNode) {
        this.type = string;
        this.typeNode = xdmNode;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public QName getTypeAsQName() {
        return new QName(this.type, this.typeNode);
    }

    public void setRequired(String string) {
        this.required = "true".equals(string);
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setSelect(String string) {
        this.select = string;
    }

    @Override
    public String getSelect() {
        return this.select;
    }

    @Override
    public void addNamespaceBinding(NamespaceBinding namespaceBinding) {
        this.nsBindings.add(namespaceBinding);
    }

    @Override
    public Vector<NamespaceBinding> getNamespaceBindings() {
        return this.nsBindings;
    }

    public boolean valid(Environment environment) {
        boolean bl = true;
        if (this.bindings.size() > 1) {
            this.error("Option can have at most one binding.", XProcConstants.dynamicError(8));
            bl = false;
        }
        if (this.required && this.select != null) {
            this.error("You can't specify a default value on a required option", XProcConstants.staticError(17));
        }
        return bl;
    }

    public String toString() {
        if (XProcConstants.p_option.equals((Object)this.node.getNodeName())) {
            return "with-option " + this.name;
        }
        return "option " + this.name;
    }

    protected void dump(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        if (this.select != null) {
            System.err.println(string + "option " + this.getName() + " select=" + this.select);
        } else {
            System.err.println(string + "option " + this.getName());
            if (this.getBinding().size() == 0 && !XProcConstants.p_option.equals((Object)this.node.getNodeName())) {
                System.err.println(string + "  no binding");
            }
        }
        for (Binding binding : this.getBinding()) {
            binding.dump(n + 2);
        }
    }
}

