/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

#ifndef __QL_FCOE_VMKMGMT_STRUCT_H
#define __QL_FCOE_VMKMGMT_STRUCT_H

#include "qedfc_basetypes.h"

struct ql_fcoe_pci_info {
	UINT16 vendor_id;
	UINT16 device_id;
	UINT16 subvendor_id;
	UINT16 subsystem_id;
	UINT16 domain_num;
	UINT16 bus_num;
	UINT16 device_num;
	UINT16 function_num;
	UINT16 revision;
	UINT16 port_num;
	UINT32 pcie_speed;
	UINT32 pcie_width;
	UINT32 chip_rev_id;
	UINT8 reserved[32];
} __attribute__((__packed__));	/* 64 */

struct ql_fcoe_port_info {
	UINT8 manufacturer[QLEVFC_SIZE_64];
	UINT8 model_name[QLEVFC_SIZE_32];
	UINT8 model_desc[QLEVFC_SIZE_128];
	UINT8 serial_num[QLEVFC_SIZE_32];
	UINT8 driver_version[QLEVFC_SIZE_32];
	UINT8 driver_date[QLEVFC_SIZE_32];
	UINT8 driver_name[QLEVFC_SIZE_16];
	UINT8 driver_loaded;
	UINT8 fw_version[QLEVFC_SIZE_32];
	UINT64 wwnn;
	UINT64 wwpn;
	UINT32 portid;
	UINT16 port_type;
	UINT32 link_state;
	UINT16 port_sup_speed;
	UINT16 port_speed;
	UINT8 mac[QLEVFC_SIZE_6];
	UINT32 tgt_cnt;
	UINT32 fcf_cnt;
	UINT32 mtu;
	UINT32 vlan;
	UINT32 npiv_count;
	UINT32 npiv_index;
	UINT8 hba_name[QLEVFC_SIZE_32];
	UINT8 reserved[51];
} __attribute__((__packed__));	/* 512 */

struct ql_fcoe_port_stats {
	UINT64 rx_fcoe_frames;
	UINT64 rx_fcoe_bytes;
	UINT64 rx_fcp_frames;
	UINT64 tx_fcoe_frames;
	UINT64 tx_fcoe_bytes;
	UINT64 tx_fcp_frames;
	UINT64 fcoe_dropped_frames;
	UINT64 seq_dropped;
	UINT64 fc_crc_err_frames;
	UINT64 wrong_fcoe_ver_frames;
	UINT64 eofa_frames;
	UINT64 missing_frames;
	UINT64 seq_timeouts;
	UINT64 read_req;
	UINT64 write_req;
	UINT64 ctrl_req;
	UINT64 read_megabytes;
	UINT64 write_megabytes;
	UINT64 fip_vlan_negotiations;
	UINT64 fip_fabric_discoveries;
	UINT64 flogi_cnt;
	UINT64 fdisc_cnt;
	UINT64 ulp_tov_expirations;
	UINT64 rec_expirations;
	UINT64 abts_cnt;
	UINT64 srr_cnt;
	UINT64 reset_lun_cnt;
	UINT64 reset_tgt_cnt;
	UINT64 sess_level_recovery_cnt;
	UINT64 link_failures;
	UINT64 reserved[34];
} __attribute__((__packed__));	/* 512 bytes */

struct ql_fcoe_tgt_info {
	UINT32 scsi_bus_num;
	UINT32 scsi_tgt_num;
	UINT64 wwnn;
	UINT64 wwpn;
	UINT32 portid;
	UINT16 port_state;
	UINT8 reserved[34];
} __attribute__((__packed__));	/* 64 */

struct ql_fcoe_fcf_info {
	UINT32 fcf_num;
	UINT64 switch_name;
	UINT64 fabric_name;
	UINT32 fc_map;
	UINT16 vfid;
	UINT8 fcf_mac[QLEVFC_SIZE_6];
	UINT8 fcoe_mac[QLEVFC_SIZE_6];
	UINT8 flogi_sent;
	UINT8 priority;
	UINT16 flags;
	UINT32 ka_timeout;
	UINT8 fcf_selected;
	UINT8 reserved[17];
} __attribute__((__packed__));	/* 64 */

/* SCSI Command data direction */
#define QL_FCOE_DATA_DIRECTION_NONE	0
#define QL_FCOE_DATA_DIRECTION_IN	1
#define QL_FCOE_DATA_DIRECTION_OUT	2

struct ql_fcoe_scsi_cmd {
	UINT32 bus;
	UINT32 tgt;
	UINT32 lun;
	UINT8 direction;
	UINT8 cdb_len;
	UINT8 cdb[QLEVFC_SIZE_16];
	UINT16 sense_len;
	UINT8 sense[QLEVFC_SIZE_256];
	UINT32 data_len;
	UINT8 data_buffer[QLEVFC_SIZE_256K];
} __attribute__((__packed__));	/* 262436 */

#endif /* __QEDFC_VMKMGMT_H */
