
#ifndef _QFLE3_CNIC_H_
#define _QFLE3_CNIC_H_
#define QFLE3_CNIC_DRV
#include "qcnic_if.h"

struct qfle3_adapter;
struct qfle3_fastpath;
//#define QFLE3_NUM_QUEUES(bp)			((bp)->num_ethqs)
#define QFLE3_NUM_NON_CNIC_QUEUES(bp)	(QFLE3_NUM_ETH_QUEUES(bp))
#define QFLE3_1st_NON_L2_ETH_CID(bp)	(QFLE3_NUM_NON_CNIC_QUEUES(bp) * QFLE3_MULTI_TX_COS)
/* amount of cids traversed by UIO's DPM addition to doorbell */
#define UIO_DPM				8
/* roundup to DPM offset */
#define UIO_ROUNDUP(bp)			(ROUNDUP(QFLE3_1st_NON_L2_ETH_CID(bp), \
			UIO_DPM))
/* offset to nearest value which has lsb nibble matching DPM */
#define UIO_CID_OFFSET(bp)		((UIO_ROUNDUP(bp) + UIO_DPM) % \
		(UIO_DPM * 2))
/* add offset to rounded-up cid to get a value which could be used with UIO */
#define UIO_DPM_ALIGN(bp)		(UIO_ROUNDUP(bp) + UIO_CID_OFFSET(bp))
/* but wait - avoid UIO special case for cid 0 */
#define UIO_DPM_CID0_OFFSET(bp)		((UIO_DPM * 2) * \
		(UIO_DPM_ALIGN(bp) == UIO_DPM))
/* Properly DPM aligned CID adjusted to cid 0 special case */
#define QFLE3_CNIC_START_ETH_CID(bp)	(UIO_DPM_ALIGN(bp) + \
		(UIO_DPM_CID0_OFFSET(bp)))
/* how many cids were wasted  - need this value for cid allocation */
#define UIO_CID_PAD(bp)			(QFLE3_CNIC_START_ETH_CID(bp) - \
		QFLE3_1st_NON_L2_ETH_CID(bp))
/* iSCSI L2 */
#define	QFLE3_ISCSI_ETH_CID(bp)		(QFLE3_CNIC_START_ETH_CID(bp))
#define	QFLE3_OOO_ETH_CID(bp)		(QFLE3_CNIC_START_ETH_CID(bp) + 1)
/* Forwarding: has no client, only CID */
#define	QFLE3_FWD_ETH_CID(bp)		(QFLE3_CNIC_START_ETH_CID(bp) + 2)
/* FCoE L2 */
#define	QFLE3_FCOE_ETH_CID(bp)		(QFLE3_CNIC_START_ETH_CID(bp) + 3)

#define QFLE3_FCOE_L2_RX_INDEX \
	(&adapter->def_status_blk->sp_sb.\
	index_values[HC_SP_INDEX_ETH_FCOE_RX_CQ_CONS])

#define QFLE3_FCOE_L2_TX_INDEX \
	(&adapter->def_status_blk->sp_sb.\
	index_values[HC_SP_INDEX_ETH_FCOE_TX_CQ_CONS])

/* OOO connection */
#define HC_INDEX_OOO_RX_CQ_CONS		HC_INDEX_ETH_RX_CQ_CONS

#define QFLE3_RX_OOO_INDEX \
	(&fp->sb_index_values[HC_INDEX_ETH_RX_CQ_CONS])

/* It's an index that will never be advanced - we need it in
 * order to use the general NAPI poll() for handling OOO
 * ring SP in qfle3_nic_load()/unload()
 */
#define QFLE3_TX_OOO_INDEX \
	(&fp->sb_index_values[HC_INDEX_OOO_TX_CQ_CONS])

/* FWD connection */
#define HC_INDEX_FWD_TX_CQ_CONS		C_SB_ETH_TX_CQ_INDEX

#define QFLE3_TX_FWD_INDEX \
	(&fp->sb_index_values[HC_INDEX_ETH_TX_CQ_CONS_COS0])


typedef vmk_uint8 qfle3_status_block[64];

struct cnic_eth_dev *qfle3_cnic_probe(vmk_AddrCookie driverData);

VMK_ReturnStatus qfle3_remove_cnic_device(vmk_Device device);
VMK_ReturnStatus qfle3_cnic_sp_queue(vmk_Device nicDev,
	struct kwqe_16 *kwqes[], vmk_uint32 count);

VMK_ReturnStatus qfle3_cnic_drv_ctl(vmk_Device nicDev,
	struct drv_ctl_info *ctl);
VMK_ReturnStatus qfle3_register_cnic(vmk_Device nicDev, cnic_ops *ops,
	void *data);
VMK_ReturnStatus qfle3_unregister_cnic(vmk_Device nicDev);
void  qfle3_get_cnic_mac_hwinfo(struct qfle3_adapter *adapter);
void qfle3_get_cnic_info(struct qfle3_adapter *adapter);
void qfle3_init_fcoe_fp(struct qfle3_adapter * adapter);
void qfle3_init_ooo_fp(struct qfle3_adapter * adapter);
void qfle3_init_fwd_fp(struct qfle3_adapter * adapter);
int qfle3_setup_tx_only(struct qfle3_adapter *adapter, struct qfle3_fastpath *fp,
			struct ecore_queue_state_params *q_params,
			struct ecore_queue_setup_tx_only_params *tx_only_params,
			int tx_index, vmk_Bool leading);
VMK_ReturnStatus qfle3_alloc_ooo_rx_bd_ring(struct qfle3_fastpath * fp);
void qfle3_register_cnic_irq_handlr(struct qfle3_adapter *adapter, void *cnicIRQHandler);
VMK_ReturnStatus qfle3_create_cnicqs(struct qfle3_adapter * adapter);
VMK_ReturnStatus qfle3_remove_cnicqs(struct qfle3_adapter *adapter);
VMK_ReturnStatus qfle3_start_cnicqs(struct qfle3_adapter * adapter);
VMK_ReturnStatus qfle3_stop_cnicqs(struct qfle3_adapter * adapter);
void
qfle3_set_mac_buf(vmk_uint8 *mac_buf, vmk_uint32 mac_lo, vmk_uint16 mac_hi);

vmk_uint32 qfle3_rx_ustorm_prods_offset(struct qfle3_fastpath *fp);
unsigned long qfle3_get_common_flags(struct qfle3_adapter *adapter,
					    struct qfle3_fastpath *fp,
					    vmk_Bool zero_stats);
void qfle3_pf_q_prep_general(struct qfle3_adapter *adapter,
				    struct qfle3_fastpath *fp, struct ecore_general_setup_params *gen_init,
				    vmk_uint8 cos);
void qfle3_pf_tx_q_prep(struct qfle3_adapter *adapter,
			       struct qfle3_fastpath *fp, struct ecore_txq_setup_params *txq_init,
			       vmk_uint8 cos);
int  qfle3_cnic_handle_cfc_del(struct qfle3_adapter * adapter, vmk_uint32 cid,
				      union event_ring_elem *elem);
int qfle3_set_storm_rx_mode(struct qfle3_adapter *adapter);
int qfle3_cnic_ctl_send(struct qfle3_adapter * adapter, struct cnic_ctl_info *ctl);
VMK_ReturnStatus qfle3_alloc_cnicqs_mem(struct qfle3_adapter * adapter);

int
qfle3_xmit_pkt(struct qfle3_adapter * adapter, vmk_uint32 qid, vmk_PktHandle * pkt);
VMK_ReturnStatus cnicLL2Tx (vmk_AddrCookie data, vmk_PktHandle * pkt);
int qfle3_reset_nic_mode(struct qfle3_adapter *adapter);
int
qfle3_has_fcoe_rx_work(struct qfle3_fastpath *fp);
VMK_ReturnStatus
qfle3_alloc_cnic_queue_mem(struct qfle3_adapter * adapter,struct qfle3_fastpath *fp);
void
qfle3_msix_rx(void *handlerData, vmk_IntrCookie intrCookie);
void qfle3_set_iscsi_eth_rx_mode(struct qfle3_adapter *adapter, vmk_Bool start);
int qfle3_cnic_get_ooo_cqe(struct qfle3_adapter *adapter, struct cnic_ooo_cqe *ooo_cqe);
int qfle3_cnic_send_ooo_pkt(struct qfle3_adapter *adapter, vmk_PktHandle *pkt);
int qfle3_cnic_comp_ooo_tx_pkts(struct qfle3_adapter *adapter);
int qfle3_cnic_reuse_ooo_pkt(struct qfle3_adapter *adapter, vmk_PktHandle *pkt);
void qfle3_setup_cnic_irq_info(struct qfle3_adapter *adapter);
int qfle3_set_mac_one(struct qfle3_adapter *adapter, vmk_uint8 *mac,
		      struct ecore_vlan_mac_obj *obj, vmk_Bool set,
		      int mac_type, unsigned long *ramrod_flags);
VMK_ReturnStatus qfle3_get_sfp_diagnostic(vmk_Device dev, struct sfp_diagnostic *data);
VMK_ReturnStatus qfle3_get_fc_npiv_tbl(vmk_Device, struct qcnic_fc_npiv_tbl *);

#endif
