#ifndef _LINUX_PROFILER_ASM_H
#define _LINUX_PROFILER_ASM_H

#include <linux/config.h>

#ifdef CONFIG_DEBUG_MCOUNT

/*
 * You've got to define two macros if you port the profiling stuff:
 */

/*
 * [kernel stack overflow profiling]
 *
 *    this says how much kernel stack space is >left<. If this goes
 *    below a certain treshold then we generate an artificial oops.
 *
 *    we do not assume anything about stack growth direction
 */

#define get_stack_left()				\
({ register unsigned long __res;			\
   __asm__("movl %%esp, %0" : "=r" (__res));		\
   __res & 0x1fff;					\
})

/*
 * [kernel tracer]
 *
 *    this macro gets fast an accurate time and puts it into a 'long long'
 *    variable. It's used as a tracer timestamp.
 */

#ifdef CONFIG_TRACE_TIMESTAMP
#define get_profiler_timestamp()				\
    ( {								\
	    register u64 __res;					\
	    if (boot_cpu_data.x86_capability & 0x10) {		\
		__asm__ __volatile__(				\
			"rdtsc" : "=A"(__res)			\
		);						\
	    }							\
	    else {						\
		/* no rdtsc, use jiffies instead */		\
		__res = jiffies;				\
	    }							\
	    __res;						\
    } )

#ifdef CONFIG_TRACE_TRUNCTIME
typedef u32 profiler_timestamp_t;
#else
typedef u64 profiler_timestamp_t;
#endif /* CONFIG_TRACE_TRUNCTIME */
#endif /* CONFIG_TRACE_TIMESTAMP */

typedef unsigned long profiler_pc_t;

#endif /* CONFIG_DEBUG_MCOUNT */

#endif	/* _LINUX_PROFILER_ASM_H */
