#ifndef _MM_UNWRAP_H
#define _MM_UNWRAP_H

#include <linux/config.h>

#ifdef CONFIG_MEMLEAK

#ifdef MEMLEAK_UNWRAP_PAGE
/* mm/page_alloc.c */
#undef __get_free_pages
#define __get_free_pages(gfp_mask,gfporder) \
	__get_free_pages_wrap((gfp_mask),(gfporder),IDPTR)
#endif /* MEMLEAK_UNWRAP_PAGE */

#ifdef MEMLEAK_UNWRAP_SLAB
/* mm/slab.c */
/*
 * NOTE: leave kmem_cache_create wrapped, as otherwise the allocation
 *       id won't exist for the underlying allocator.  Other functions
 *       which lead to a physical allocation must also pass this id.
 *       This looks ugly, but causes ownership of the allocation to be
 *       passed on to the allocation initiator.
 *
 *       freeing of the allocation is the responsibility of the underlying
 *       allocator.  I hope that this helps to keep memleak in sync.
 */

#undef kmem_cache_alloc
#undef kmalloc

#define kmem_cache_alloc(cachep,flags) \
	kmem_cache_alloc_wrap((cachep),(flags),IDPTR)

#define kmalloc(size,priority) \
	kmalloc_wrap((size),(priority),IDPTR)

#define kmem_cache_grow(cachep,flags) \
	kmem_cache_grow_wrap((cachep),(flags),IDPTR)

#define __kmem_cache_alloc(cachep,flags) \
	__kmem_cache_alloc_wrap((cachep),(flags),IDPTR)

#define kmem_cache_slabmgmt(cachep,objp,local_flags) \
	kmem_cache_slabmgmt_wrap((cachep),(objp),(local_flags),IDPTR)
#endif /* MEMLEAK_UNWRAP_SLAB */

#ifdef MEMLEAK_UNWRAP_VMALLOC
/* mm/vmalloc.c */
#undef vmalloc
#undef get_vm_area
#undef alloc_area_pte
#undef alloc_area_pmd
#undef vmalloc_area_pages

#define get_vm_area(size) get_vm_area_wrap((size),IDPTR)
#define alloc_area_pte(pte, address, size) alloc_area_pte_wrap((pte),(address),(size),IDPTR)
#define alloc_area_pmd(pmd, address, size) alloc_area_pmd_wrap((pmd),(address),(size),IDPTR)
#define vmalloc_area_pages(address, size) vmalloc_area_pages_wrap((address),(size),IDPTR)
#endif /* MEMLEAK_UNWRAP_VMALLOC */

#ifdef MEMLEAK_UNWRAP_SKBUFF
/* net/core/skbuff.c */
#undef alloc_skb
#undef skb_clone
#undef skb_copy
#undef skb_realloc_headroom

#define alloc_skb(size,gfp_mask) alloc_skb_wrap((size),(gfp_mask),IDPTR)
#define skb_clone(skb,gfp_mask) skb_clone_wrap((skb),(gfp_mask),IDPTR)
#define skb_copy(skb,gfp_mask) skb_copy_wrap((skb),(gfp_mask),IDPTR)
#define skb_realloc_headroom(skb,newheadroom) skb_realloc_headroom_wrap((skb),(newheadroom),IDPTR)
#endif /* MEMLEAK_UNWRAP_SKBUFF */

#ifdef MEMLEAK_UNWRAP_SOCK
/* net/core/sock.c */
#undef sock_wmalloc
#undef sock_rmalloc
#undef sock_kmalloc
#undef sk_alloc

#define sock_wmalloc(sk,size,force,priority) sock_wmalloc_wrap((sk),(size),(force),(priority),IDPTR)
#define sock_rmalloc(sk,size,force,priority) sock_rmalloc_wrap((sk),(size),(force),(priority),IDPTR)
#define sock_kmalloc(sk,size,priority) sock_kmalloc_wrap((sk),(size),(priority),IDPTR)
#define sk_alloc(family,priority,zero_it) sk_alloc_wrap((family),(priority),(zero_it),IDPTR)

/* include/net/sock.h */
#undef sock_alloc_send_skb
#define sock_alloc_send_skb(sk,size,fallback,noblock,errcode) \
	sock_alloc_send_skb_wrap((sk),(size),(fallback),(noblock),(errcode),IDPTR)
#endif /* MEMLEAK_UNWRAP_SOCK */

#endif /* CONFIG_MEMLEAK */
#endif /* _MM_UNWRAP_H */
