/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.css.swt.internal.theme.BootstrapTheme3x;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class UIStyles {
    public static final Color COLOR_WHITE = new Color(null, 255, 255, 255);
    private static final Log log = Log.getLog(UIStyles.class);
    private static final String THEME_HIGH_CONTRAST_ID = "org.eclipse.e4.ui.css.theme.high-contrast";
    static final Color COLOR_BLACK = new Color(null, 0, 0, 0);
    static final Color COLOR_WHITE_DARK = new Color(null, 192, 192, 192);
    static IPreferenceStore EDITORS_PREFERENCE_STORE;
    static IThemeEngine themeEngine;

    static {
        themeEngine = null;
    }

    public static synchronized IPreferenceStore getEditorsPreferenceStore() {
        if (EDITORS_PREFERENCE_STORE == null) {
            EDITORS_PREFERENCE_STORE = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.ui.editors");
        }
        return EDITORS_PREFERENCE_STORE;
    }

    public static boolean isDarkTheme() {
        return UIUtils.isDark(UIStyles.getDefaultTextBackground().getRGB()) || UIStyles.isDarkHighContrastTheme();
    }

    private static IThemeEngine getThemeEngine() {
        IThemeManager manager;
        ServiceReference ref;
        BundleContext context;
        Bundle bundle;
        if (themeEngine == null && (bundle = FrameworkUtil.getBundle(BootstrapTheme3x.class)) != null && (context = bundle.getBundleContext()) != null && (ref = context.getServiceReference(IThemeManager.class)) != null && (manager = (IThemeManager)context.getService(ref)) != null) {
            themeEngine = manager.getEngineForDisplay(Display.getDefault());
        }
        return themeEngine;
    }

    public static boolean isHighContrastTheme() {
        IThemeEngine themeEngine = UIStyles.getThemeEngine();
        org.eclipse.e4.ui.css.swt.theme.ITheme theme = null;
        if (themeEngine != null) {
            theme = themeEngine.getActiveTheme();
        } else {
            themeEngine = (IThemeEngine)PlatformUI.getWorkbench().getService(IThemeEngine.class);
            if (themeEngine != null) {
                theme = themeEngine.getActiveTheme();
            }
        }
        if (theme != null) {
            return theme.getId().equals(THEME_HIGH_CONTRAST_ID);
        }
        return false;
    }

    public static boolean isDarkHighContrastTheme() {
        return UIStyles.isHighContrastTheme() && UIUtils.isDark(UIStyles.getDefaultWidgetBackground().getRGB());
    }

    public static Color getDefaultWidgetBackground() {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        Color color = theme.getColorRegistry().get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START");
        if (color == null) {
            color = Display.getCurrent().getSystemColor(22);
        }
        return color;
    }

    public static Color getDefaultTextBackground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Color.Background", 25);
    }

    public static Color getDefaultTextForeground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Color.Foreground", 24);
    }

    public static Color getDefaultTextSelectionBackground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Color.SelectionBackground", 26);
    }

    public static Color getDefaultTextSelectionForeground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Color.SelectionForeground", 27);
    }

    public static Color getDefaultTextColor(String id, int defSWT) {
        IPreferenceStore preferenceStore = UIStyles.getEditorsPreferenceStore();
        String fgRGB = preferenceStore == null ? null : preferenceStore.getString(id);
        return CommonUtils.isEmpty((String)fgRGB) ? Display.getDefault().getSystemColor(defSWT) : UIUtils.getSharedColor(fgRGB);
    }

    public static Color getErrorTextForeground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Error.Color.Foreground", 3);
    }

    public static Color getContrastColor(Color color) {
        if (color == null) {
            return COLOR_BLACK;
        }
        double luminance = 1.0 - (0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue()) / 255.0;
        if (luminance > 0.5) {
            return UIStyles.isDarkTheme() ? COLOR_WHITE_DARK : COLOR_WHITE;
        }
        return COLOR_BLACK;
    }

    public static Color getInvertedColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    @NotNull
    public static Color lighten(@NotNull Color color, float amount) {
        float[] hsl = UIStyles.toHSL(color);
        float l = hsl[2] + amount;
        return UIStyles.toRGB(hsl[0], hsl[1], l, (float)color.getAlpha() / 255.0f);
    }

    @NotNull
    public static Color darken(@NotNull Color color, float amount) {
        float[] hsl = UIStyles.toHSL(color);
        float l = hsl[2] - amount;
        return UIStyles.toRGB(hsl[0], hsl[1], l, (float)color.getAlpha() / 255.0f);
    }

    @NotNull
    public static float[] toHSL(@NotNull Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float h = 0.0f;
        if (max == min) {
            h = 0.0f;
        } else if (max == r) {
            h = (60.0f * (g - b) / (max - min) + 360.0f) % 360.0f;
        } else if (max == g) {
            h = 60.0f * (b - r) / (max - min) + 120.0f;
        } else if (max == b) {
            h = 60.0f * (r - g) / (max - min) + 240.0f;
        }
        float l = (max + min) / 2.0f;
        float s = max == min ? 0.0f : (l <= 0.5f ? (max - min) / (max + min) : (max - min) / (2.0f - max - min));
        return new float[]{h, s, l};
    }

    @NotNull
    public static Color toRGB(float h, float s, float l, float alpha) {
        h = h % 360.0f / 360.0f;
        s = Math.clamp(s, 0.0f, 1.0f);
        l = Math.clamp(l, 0.0f, 1.0f);
        alpha = Math.clamp(alpha, 0.0f, 1.0f);
        float q = (double)l < 0.5 ? l * (1.0f + s) : l + s - s * l;
        float p = 2.0f * l - q;
        float r = Math.max(0.0f, UIStyles.hueToRGB(p, q, h + 0.33333334f));
        float g = Math.max(0.0f, UIStyles.hueToRGB(p, q, h));
        float b = Math.max(0.0f, UIStyles.hueToRGB(p, q, h - 0.33333334f));
        r = Math.min(r, 1.0f);
        g = Math.min(g, 1.0f);
        b = Math.min(b, 1.0f);
        return new Color((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(alpha * 255.0f));
    }

    private static float hueToRGB(float p, float q, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }
}

