/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.ui.editors;

import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.app.DB2ServerApplication;
import org.jkiss.dbeaver.ext.db2.model.app.DB2ServerApplicationManager;
import org.jkiss.dbeaver.ext.db2.ui.internal.DB2Messages;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.views.session.AbstractSessionEditor;
import org.jkiss.dbeaver.ui.views.session.SessionManagerViewer;

public class DB2ServerApplicationEditor
extends AbstractSessionEditor {
    private ForceApplicationAction forceApplicationAction;

    public void createEditorControl(Composite parent) {
        this.forceApplicationAction = new ForceApplicationAction();
        super.createEditorControl(parent);
    }

    protected SessionManagerViewer createSessionViewer(DBCExecutionContext executionContext, Composite parent) {
        return new SessionManagerViewer<DB2ServerApplication>((IWorkbenchPart)this, parent, (DBAServerSessionManager)new DB2ServerApplicationManager((DB2DataSource)executionContext.getDataSource())){

            protected void contributeToToolbar(DBAServerSessionManager sessionManager, IContributionManager contributionManager) {
                contributionManager.add((IAction)DB2ServerApplicationEditor.this.forceApplicationAction);
                contributionManager.add((IContributionItem)new Separator());
            }

            protected void onSessionSelect(DBAServerSession session) {
                super.onSessionSelect(session);
                DB2ServerApplicationEditor.this.forceApplicationAction.setEnabled(session != null);
            }
        };
    }

    private class ForceApplicationAction
    extends Action {
        public ForceApplicationAction() {
            super(DB2Messages.editors_db2_application_editor_title_force_application, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REJECT));
        }

        public void run() {
            List sessions = DB2ServerApplicationEditor.this.getSessionsViewer().getSelectedSessions();
            String action = DB2Messages.editors_db2_application_editor_action_force;
            if (UIUtils.confirmAction((Shell)DB2ServerApplicationEditor.this.getSite().getShell(), (String)"Confirm force application", (String)NLS.bind((String)DB2Messages.editors_db2_application_editor_confirm_action, (Object)action.toLowerCase(), (Object)sessions))) {
                HashMap options = new HashMap();
                DB2ServerApplicationEditor.this.getSessionsViewer().alterSessions(sessions, options);
            }
        }
    }
}

