/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.freeplane.core.extension.Configurable;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.map.NodeModel;

public class Connectors
implements IExtension {
    private final Map<NodeModel, Collection<ConnectorModel>> connectorsFromSource = new HashMap<NodeModel, Collection<ConnectorModel>>();
    private final Map<NodeModel, Collection<ConnectorModel>> connectorsToTarget = new HashMap<NodeModel, Collection<ConnectorModel>>();

    public static Connectors of(Configurable configurable) {
        return configurable.computeIfAbsent(Connectors.class, Connectors::new);
    }

    public void add(ConnectorModel connector) {
        this.connectorsFromSource.computeIfAbsent(connector.getSource(), n -> new ArrayList()).add(connector);
        this.connectorsToTarget.computeIfAbsent(connector.getTarget(), n -> new ArrayList()).add(connector);
    }

    public void addAll(Collection<? extends ConnectorModel> connectors) {
        connectors.stream().forEach(this::add);
    }

    public void clear() {
        this.connectorsFromSource.clear();
        this.connectorsToTarget.clear();
    }

    public Collection<ConnectorModel> getLinksFrom(NodeModel node) {
        return this.connectorsFromSource.getOrDefault(node, Collections.emptyList());
    }

    public Collection<ConnectorModel> getLinksTo(NodeModel node) {
        return this.connectorsToTarget.getOrDefault(node, Collections.emptyList());
    }
}

