#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.43.1
visibility:           public
id:                   hledger-web-1.43.1-2mff9MgbaTMCFr4nGacdQ9
key:                  hledger-web-1.43.1-2mff9MgbaTMCFr4nGacdQ9
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  9ade756be8bbe3483c2615fbeeb4de99
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.43.1-2mff9MgbaTMCFr4nGacdQ9
depends:
    Decimal-0.5.2-GOM6hM9ChYd7QhckIARg8b
    aeson-2.1.2.1-KHwyqlRT8uq4KliO3neHti base-4.17.2.1
    base64-1.0-45A64sN0n13DshKCzujkQG
    blaze-html-0.9.2.0-BIKMCCBg4WREbcLt4aWKrB
    blaze-markup-0.8.3.0-6ICyj6U2NnC3mtRoGtKty6 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-H8Fvgv7YDBkYcnBQIbjuM
    clientsession-0.9.3.0-HE2mk3VroUqFiopqCHgiSp
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-AhGLvUg5hIU6LsM4QL1rg6
    conduit-extra-1.3.8-JYWbaceofIoEWZCrj7lr7T containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-LFhHReVYXhkAHHlVLFa5k7
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    githash-0.1.6.3-Dh98EewSj8GE0V9n8yjcCs
    hjsmin-0.2.1-K7YKlYoqyP4BJwQhIV1Wsg
    hledger-1.43.1-4UK2oaupp9KD5jojPldCmJ
    hledger-lib-1.43.1-K2HI3UVJMTmADOEpx5yRW2
    hspec-2.11.4-4iERIflnCkk4myRxHYwuxG
    http-client-0.7.19-KoKZT635swAE508sq3INbf
    http-conduit-2.3.9.1-9oPlHGYlrOYaw1Zlna69I
    http-types-0.12.4-FtU8gz6pIQD8uIXzLWqrj
    megaparsec-9.7.0-2BpZEZysy1TBFLB2lr3zMC mtl-2.2.2
    network-3.1.4.0-Fdysxcu9OH32QGRZPBFSYA
    safe-0.3.21-F7VtiJ5GidLJaCroTndPfj
    shakespeare-2.1.7-8Qslib1g3nE9djN9WpTedW template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-Iwc9DBU2Q1sHvRcwwytc5q
    unordered-containers-0.2.20.1-L9h8TvnOBH1Ihya3LZF9bU
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-HRHEADwk9POF0mrDAofsIw
    wai-cors-0.2.7-3wKgMN03ZunHmiw47GgsSe
    wai-extra-3.1.18-2s0XLxE0lxE5eNYMMQp8a7
    wai-handler-launch-3.0.3.1-IDQkI0GN7FfHfUQOP5LTYn
    warp-3.4.0-9lZVZaTFnSUJgaAPY0uhZC
    yaml-0.11.11.2-82bhmF4EclXCDsblqIiJpW
    yesod-1.6.2.1-9PqQWTTVuZ7BtfIOkrSKMb
    yesod-core-1.6.27.1-OhlWCjlHSsIBTqTPdM7sk
    yesod-form-1.7.9-DjHNzUQrDXGBVAxyh3ejmH
    yesod-static-1.6.1.0-3ax9jWtaf4LM1NMCxqIjj
    yesod-test-1.6.23-2R3Xihn3crLCDzXCwaaxiw

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

