/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ConsumerGroupMigrationPolicy {
    BIDIRECTIONAL("bidirectional", true, true),
    UPGRADE("upgrade", true, false),
    DOWNGRADE("downgrade", false, true),
    DISABLED("disabled", false, false);

    private final String name;
    private final boolean isUpgradeEnabled;
    private final boolean isDowngradeEnabled;
    private static final Map<String, ConsumerGroupMigrationPolicy> NAME_TO_ENUM;

    private ConsumerGroupMigrationPolicy(String config, boolean isUpgradeEnabled, boolean isDowngradeEnabled) {
        this.name = config;
        this.isUpgradeEnabled = isUpgradeEnabled;
        this.isDowngradeEnabled = isDowngradeEnabled;
    }

    public boolean isUpgradeEnabled() {
        return this.isUpgradeEnabled;
    }

    public boolean isDowngradeEnabled() {
        return this.isDowngradeEnabled;
    }

    public String toString() {
        return this.name;
    }

    public static ConsumerGroupMigrationPolicy parse(String name) {
        if (name == null) {
            return DISABLED;
        }
        ConsumerGroupMigrationPolicy policy = NAME_TO_ENUM.get(name.toLowerCase(Locale.ROOT));
        return policy == null ? DISABLED : policy;
    }

    static {
        NAME_TO_ENUM = Arrays.stream(ConsumerGroupMigrationPolicy.values()).collect(Collectors.toMap(policy -> policy.name.toLowerCase(Locale.ROOT), Function.identity()));
    }
}

