/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactoryBuilder;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.model.BaseModel;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.JsonIO;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.yaml.snakeyaml.LoaderOptions;

class JacksonJsonIO
implements JsonIO<JsonNode, ArrayNode, ObjectNode, ArrayNode, ObjectNode> {
    private static final JsonNodeFactory factory = JsonNodeFactory.instance;
    private final OpenApiConfig config;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper yamlMapper;
    private final ObjectWriter jsonWriter;
    private final ObjectWriter yamlWriter;

    public JacksonJsonIO(OpenApiConfig config, ObjectMapper objectMapper) {
        this.config = config != null ? config : OpenApiConfig.fromConfig(ConfigProvider.getConfig());
        this.jsonMapper = objectMapper;
        this.jsonWriter = objectMapper.writerWithDefaultPrettyPrinter();
        LoaderOptions loaderOptions = new LoaderOptions();
        Optional.ofNullable(this.config.getMaximumStaticFileSize()).ifPresent(arg_0 -> ((LoaderOptions)loaderOptions).setCodePointLimit(arg_0));
        YAMLFactory yamlFactory = new YAMLFactoryBuilder(new YAMLFactory()).loaderOptions(loaderOptions).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS).enable(YAMLGenerator.Feature.ALLOW_LONG_KEYS).build();
        this.yamlMapper = this.jsonMapper.copyWith((JsonFactory)yamlFactory);
        this.yamlWriter = this.yamlMapper.writer().with((JsonFactory)yamlFactory);
    }

    public JacksonJsonIO(OpenApiConfig config) {
        this(config, new ObjectMapper());
    }

    public JacksonJsonIO(ObjectMapper objectMapper) {
        this(null, objectMapper);
    }

    public JacksonJsonIO() {
        this(null, new ObjectMapper());
    }

    @Override
    public boolean isArray(JsonNode value) {
        return value instanceof ArrayNode;
    }

    @Override
    public ArrayNode asArray(JsonNode value) {
        return (ArrayNode)value;
    }

    @Override
    public List<JsonNode> entries(ArrayNode array) {
        ArrayList<JsonNode> entries = new ArrayList<JsonNode>(array.size());
        array.forEach(entries::add);
        return entries;
    }

    @Override
    public boolean isObject(JsonNode value) {
        return value instanceof ObjectNode;
    }

    @Override
    public ObjectNode asObject(JsonNode value) {
        return (ObjectNode)value;
    }

    @Override
    public boolean hasKey(ObjectNode object, String key) {
        return object.has(key);
    }

    @Override
    public Set<Map.Entry<String, JsonNode>> properties(ObjectNode object) {
        return object.properties();
    }

    @Override
    public boolean isString(JsonNode value) {
        return value != null && value.isTextual();
    }

    @Override
    public String asString(JsonNode value) {
        return value != null && value.isValueNode() ? value.asText() : null;
    }

    @Override
    public boolean isBoolean(JsonNode value) {
        return value != null && value.isBoolean();
    }

    @Override
    public Boolean asBoolean(JsonNode value) {
        return value != null && value.isBoolean() ? Boolean.valueOf(value.asBoolean()) : null;
    }

    @Override
    public boolean isNull(JsonNode value) {
        return value != null && value.isNull();
    }

    @Override
    public Integer getJsonInt(ObjectNode object, String key) {
        JsonNode value = object.get(key);
        return value != null && value.isInt() ? Integer.valueOf(value.asInt()) : null;
    }

    @Override
    public String getJsonString(ObjectNode object, String key) {
        return this.asString(object.get(key));
    }

    @Override
    public Boolean getJsonBoolean(ObjectNode object, String key) {
        JsonNode value = object.get(key);
        return value != null && value.isBoolean() ? Boolean.valueOf(value.asBoolean()) : null;
    }

    @Override
    public BigDecimal getJsonBigDecimal(ObjectNode object, String key) {
        JsonNode value = object.get(key);
        return value != null && value.isNumber() ? value.decimalValue() : null;
    }

    @Override
    public JsonNode getValue(ObjectNode object, String key) {
        return object.get(key);
    }

    @Override
    public Optional<ArrayNode> getArray(ObjectNode object, String key) {
        JsonNode value = object.get(key);
        return value != null && value.isArray() ? Optional.of((ArrayNode)value) : Optional.empty();
    }

    @Override
    public Optional<ObjectNode> getObject(ObjectNode object, String key) {
        JsonNode value = object.get(key);
        return value != null && value.isObject() ? Optional.of((ObjectNode)value) : Optional.empty();
    }

    @Override
    public ArrayNode createArray() {
        return factory.arrayNode();
    }

    @Override
    public void add(ArrayNode array, JsonNode value) {
        array.add(value);
    }

    @Override
    public ArrayNode buildArray(ArrayNode array) {
        return array;
    }

    @Override
    public ObjectNode createObject() {
        return factory.objectNode();
    }

    @Override
    public void set(ObjectNode object, String key, JsonNode value) {
        object.set(key, value);
    }

    @Override
    public void setAll(ObjectNode object, ObjectNode valueSource) {
        object.setAll(valueSource);
    }

    @Override
    public ObjectNode buildObject(ObjectNode object) {
        return object;
    }

    @Override
    public JsonNode toJson(Object value, JsonNode defaultValue, JsonIO.PropertyMapper<JsonNode, ObjectNode> propertyMapper) {
        if (value instanceof String) {
            return factory.textNode((String)value);
        }
        if (value instanceof List) {
            return this.toJson((List)value, propertyMapper);
        }
        if (value instanceof Map) {
            return this.toJson((Map)value, propertyMapper);
        }
        if (value instanceof Enum) {
            return factory.textNode(value.toString());
        }
        if (value instanceof BaseModel) {
            return this.toJson((BaseModel)value, propertyMapper);
        }
        if (value instanceof JsonNode) {
            return (JsonNode)value;
        }
        if (value instanceof BigDecimal) {
            return factory.numberNode((BigDecimal)value);
        }
        if (value instanceof BigInteger) {
            return factory.numberNode((BigInteger)value);
        }
        if (value instanceof Boolean) {
            return factory.booleanNode(((Boolean)value).booleanValue());
        }
        if (value instanceof Double) {
            return factory.numberNode((Double)value);
        }
        if (value instanceof Float) {
            return factory.numberNode((Float)value);
        }
        if (value instanceof Short) {
            return factory.numberNode(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return factory.numberNode((Integer)value);
        }
        if (value instanceof Long) {
            return factory.numberNode((Long)value);
        }
        if (value instanceof Character) {
            return factory.textNode(((Character)value).toString());
        }
        return defaultValue;
    }

    private JsonNode toJson(List<?> value, JsonIO.PropertyMapper<JsonNode, ObjectNode> propertyMapper) {
        ArrayNode array = this.createArray();
        for (Object entry : value) {
            JsonNode node = this.toJson(entry, (JsonNode)factory.nullNode(), propertyMapper);
            array.add(node);
        }
        return array;
    }

    private JsonNode toJson(Map<?, ?> value, JsonIO.PropertyMapper<JsonNode, ObjectNode> propertyMapper) {
        ObjectNode object = this.createObject();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            JsonNode node = this.toJson(entry.getValue(), (JsonNode)factory.nullNode(), propertyMapper);
            object.set(String.valueOf(entry.getKey()), node);
        }
        return object;
    }

    private JsonNode toJson(BaseModel<?> value, JsonIO.PropertyMapper<JsonNode, ObjectNode> propertyMapper) {
        Optional<JsonNode> override = propertyMapper.mapObject(value);
        if (override.isPresent()) {
            return override.get();
        }
        ObjectNode object = this.createObject();
        for (Map.Entry entry : value.getAllProperties().entrySet()) {
            Object propertyValue;
            String propertyName = String.valueOf(entry.getKey());
            Optional<JsonNode> propertyOverride = propertyMapper.mapProperty(value, propertyName, propertyValue = entry.getValue());
            JsonNode node = propertyOverride.isPresent() ? propertyOverride.get() : this.toJson(propertyValue, (JsonNode)factory.nullNode(), propertyMapper);
            if (node.isNull()) continue;
            object.set(propertyName, node);
        }
        propertyMapper.mapObject(value, object);
        return object;
    }

    @Override
    public Object fromJson(JsonNode value) {
        if (value == null || value.isNull()) {
            return null;
        }
        if (value.isBigDecimal()) {
            return value.decimalValue();
        }
        if (value.isBigInteger()) {
            return value.bigIntegerValue();
        }
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isDouble()) {
            return value.asDouble();
        }
        if (value.isFloat()) {
            return value.asDouble();
        }
        if (value.isInt()) {
            return value.asInt();
        }
        if (value.isLong()) {
            return value.asLong();
        }
        if (value.isTextual()) {
            return value.asText();
        }
        if (value.isArray()) {
            ArrayList items = new ArrayList();
            value.elements().forEachRemaining(entry -> items.add(this.fromJson((JsonNode)entry)));
            return items;
        }
        if (value.isObject()) {
            LinkedHashMap items = new LinkedHashMap();
            value.properties().forEach(field -> items.put((String)field.getKey(), this.fromJson((JsonNode)field.getValue())));
            return items;
        }
        return null;
    }

    @Override
    public <T> T fromJson(JsonNode object, Class<T> desiredType) {
        if (desiredType == String.class && object.isValueNode()) {
            return (T)object.asText();
        }
        if (desiredType == Integer.class && object.canConvertToInt()) {
            return (T)Integer.valueOf(object.asInt());
        }
        if (desiredType == BigInteger.class && object.canConvertToExactIntegral()) {
            return (T)object.bigIntegerValue();
        }
        if (desiredType == Long.class && object.canConvertToLong()) {
            return (T)Long.valueOf(object.asLong());
        }
        if (desiredType == BigDecimal.class && object.isNumber()) {
            return (T)object.decimalValue();
        }
        if (desiredType == Boolean.class && object.isBoolean()) {
            return (T)Boolean.valueOf(object.booleanValue());
        }
        return null;
    }

    @Override
    public String toString(JsonNode value, Format format) {
        try {
            if (format == Format.JSON) {
                return this.jsonWriter.writeValueAsString((Object)value);
            }
            return this.yamlWriter.writeValueAsString((Object)value);
        }
        catch (IOException e) {
            throw new OpenApiRuntimeException(e);
        }
    }

    @Override
    public JsonNode fromReader(Reader reader, Format format) {
        try {
            if (format == Format.JSON) {
                return this.jsonMapper.readTree(reader);
            }
            return this.yamlMapper.readTree(reader);
        }
        catch (IOException e) {
            throw new OpenApiRuntimeException("Failed to read " + String.valueOf((Object)format) + " stream", e);
        }
    }

    @Override
    public JsonNode nullValue() {
        return factory.nullNode();
    }
}

