/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.update;

import java.io.IOException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.get.GetResult;

@PublicApi(since="1.0.0")
public class UpdateResponse
extends DocWriteResponse {
    private static final String GET = "get";
    private GetResult getResult;

    public UpdateResponse(ShardId shardId, StreamInput in) throws IOException {
        super(shardId, in);
        if (in.readBoolean()) {
            this.getResult = new GetResult(in);
        }
    }

    public UpdateResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.getResult = new GetResult(in);
        }
    }

    public UpdateResponse(ShardId shardId, String id, long seqNo, long primaryTerm, long version, DocWriteResponse.Result result) {
        this(new ReplicationResponse.ShardInfo(0, 0, new ReplicationResponse.ShardInfo.Failure[0]), shardId, id, seqNo, primaryTerm, version, result);
    }

    public UpdateResponse(ReplicationResponse.ShardInfo shardInfo, ShardId shardId, String id, long seqNo, long primaryTerm, long version, DocWriteResponse.Result result) {
        super(shardId, id, seqNo, primaryTerm, version, result);
        this.setShardInfo(shardInfo);
    }

    public void setGetResult(GetResult getResult) {
        this.getResult = getResult;
    }

    public GetResult getGetResult() {
        return this.getResult;
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.CREATED ? RestStatus.CREATED : super.status();
    }

    @Override
    public void writeThin(StreamOutput out) throws IOException {
        super.writeThin(out);
        this.writeGetResult(out);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeGetResult(out);
    }

    private void writeGetResult(StreamOutput out) throws IOException {
        if (this.getResult == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.getResult.writeTo(out);
        }
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerToXContent(builder, params);
        if (this.getGetResult() != null) {
            builder.startObject(GET);
            this.getGetResult().toXContentEmbedded(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UpdateResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",seqNo=").append(this.getSeqNo());
        builder.append(",primaryTerm=").append(this.getPrimaryTerm());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",shards=").append(this.getShardInfo());
        return builder.append("]").toString();
    }

    public static UpdateResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        Builder context = new Builder();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            UpdateResponse.parseXContentFields(parser, context);
        }
        return context.build();
    }

    public static void parseXContentFields(XContentParser parser, Builder context) throws IOException {
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = parser.currentName();
        if (GET.equals(currentFieldName)) {
            if (token == XContentParser.Token.START_OBJECT) {
                context.setGetResult(GetResult.fromXContentEmbedded(parser));
            }
        } else {
            DocWriteResponse.parseInnerToXContent(parser, context);
        }
    }

    @PublicApi(since="1.0.0")
    public static class Builder
    extends DocWriteResponse.Builder {
        private GetResult getResult = null;

        public void setGetResult(GetResult getResult) {
            this.getResult = getResult;
        }

        @Override
        public UpdateResponse build() {
            UpdateResponse update = this.shardInfo != null ? new UpdateResponse(this.shardInfo, this.shardId, this.id, this.seqNo, this.primaryTerm, this.version, this.result) : new UpdateResponse(this.shardId, this.id, this.seqNo, this.primaryTerm, this.version, this.result);
            if (this.getResult != null) {
                update.setGetResult(new GetResult(update.getIndex(), update.getId(), this.getResult.getSeqNo(), this.getResult.getPrimaryTerm(), update.getVersion(), this.getResult.isExists(), this.getResult.internalSourceRef(), this.getResult.getDocumentFields(), this.getResult.getMetadataFields()));
            }
            update.setForcedRefresh(this.forcedRefresh);
            return update;
        }
    }
}

