/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.get_script_languages.LanguageContext;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GetScriptLanguagesResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GetScriptLanguagesResponse> {
    @Nonnull
    private final List<LanguageContext> languageContexts;
    @Nonnull
    private final List<String> typesAllowed;
    public static final JsonpDeserializer<GetScriptLanguagesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetScriptLanguagesResponse::setupGetScriptLanguagesResponseDeserializer);

    private GetScriptLanguagesResponse(Builder builder) {
        this.languageContexts = ApiTypeHelper.unmodifiableRequired(builder.languageContexts, (Object)this, "languageContexts");
        this.typesAllowed = ApiTypeHelper.unmodifiableRequired(builder.typesAllowed, (Object)this, "typesAllowed");
    }

    public static GetScriptLanguagesResponse of(Function<Builder, ObjectBuilder<GetScriptLanguagesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<LanguageContext> languageContexts() {
        return this.languageContexts;
    }

    @Nonnull
    public final List<String> typesAllowed() {
        return this.typesAllowed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("language_contexts");
        generator.writeStartArray();
        for (LanguageContext languageContext : this.languageContexts) {
            languageContext.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("types_allowed");
        generator.writeStartArray();
        for (String string : this.typesAllowed) {
            generator.write(string);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGetScriptLanguagesResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::languageContexts, JsonpDeserializer.arrayDeserializer(LanguageContext._DESERIALIZER), "language_contexts");
        op.add(Builder::typesAllowed, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "types_allowed");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.languageContexts.hashCode();
        result = 31 * result + this.typesAllowed.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetScriptLanguagesResponse other = (GetScriptLanguagesResponse)o;
        return this.languageContexts.equals(other.languageContexts) && this.typesAllowed.equals(other.typesAllowed);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, GetScriptLanguagesResponse> {
        private List<LanguageContext> languageContexts;
        private List<String> typesAllowed;

        public Builder() {
        }

        private Builder(GetScriptLanguagesResponse o) {
            this.languageContexts = Builder._listCopy(o.languageContexts);
            this.typesAllowed = Builder._listCopy(o.typesAllowed);
        }

        private Builder(Builder o) {
            this.languageContexts = Builder._listCopy(o.languageContexts);
            this.typesAllowed = Builder._listCopy(o.typesAllowed);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder languageContexts(List<LanguageContext> list) {
            this.languageContexts = Builder._listAddAll(this.languageContexts, list);
            return this;
        }

        @Nonnull
        public final Builder languageContexts(LanguageContext value, LanguageContext ... values) {
            this.languageContexts = Builder._listAdd(this.languageContexts, value, values);
            return this;
        }

        @Nonnull
        public final Builder languageContexts(Function<LanguageContext.Builder, ObjectBuilder<LanguageContext>> fn) {
            return this.languageContexts(fn.apply(new LanguageContext.Builder()).build(), new LanguageContext[0]);
        }

        @Nonnull
        public final Builder typesAllowed(List<String> list) {
            this.typesAllowed = Builder._listAddAll(this.typesAllowed, list);
            return this;
        }

        @Nonnull
        public final Builder typesAllowed(String value, String ... values) {
            this.typesAllowed = Builder._listAdd(this.typesAllowed, value, values);
            return this;
        }

        @Override
        @Nonnull
        public GetScriptLanguagesResponse build() {
            this._checkSingleUse();
            return new GetScriptLanguagesResponse(this);
        }
    }
}

