/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editorconfig.common.formatting;

import com.intellij.editorconfig.common.syntax.psi.EditorConfigElementTypes;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.common.AbstractBlock;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0002J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/intellij/editorconfig/common/formatting/EditorConfigFormattingBlock;", "Lcom/intellij/psi/formatter/common/AbstractBlock;", "node", "Lcom/intellij/lang/ASTNode;", "builder", "Lcom/intellij/formatting/SpacingBuilder;", "shouldAlignSeparators", "", "separatorAlignment", "Lcom/intellij/formatting/Alignment;", "<init>", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/formatting/SpacingBuilder;ZLcom/intellij/formatting/Alignment;)V", "buildChildren", "", "Lcom/intellij/formatting/Block;", "getIndent", "Lcom/intellij/formatting/Indent;", "getSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "isUnderHeader", "isLeaf", "getAlignment", "isSeparator", "()Z", "isSection", "intellij.editorconfig.common"})
public final class EditorConfigFormattingBlock
extends AbstractBlock {
    @NotNull
    private final SpacingBuilder builder;
    private final boolean shouldAlignSeparators;
    @Nullable
    private final Alignment separatorAlignment;

    public EditorConfigFormattingBlock(@NotNull ASTNode node, @NotNull SpacingBuilder builder, boolean shouldAlignSeparators, @Nullable Alignment separatorAlignment) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super(node, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), Alignment.createAlignment());
        this.builder = builder;
        this.shouldAlignSeparators = shouldAlignSeparators;
        this.separatorAlignment = separatorAlignment;
    }

    public /* synthetic */ EditorConfigFormattingBlock(ASTNode aSTNode, SpacingBuilder spacingBuilder, boolean bl, Alignment alignment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            alignment = null;
        }
        this(aSTNode, spacingBuilder, bl, alignment);
    }

    @NotNull
    protected List<Block> buildChildren() {
        ArrayList<EditorConfigFormattingBlock> result = new ArrayList<EditorConfigFormattingBlock>();
        Alignment newSeparatorAlignment = this.isSection() ? Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.LEFT) : this.separatorAlignment;
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (Intrinsics.areEqual((Object)child.getElementType(), (Object)TokenType.WHITE_SPACE)) continue;
            EditorConfigFormattingBlock block = new EditorConfigFormattingBlock(child, this.builder, this.shouldAlignSeparators, newSeparatorAlignment);
            result.add(block);
        }
        return result;
    }

    @NotNull
    public Indent getIndent() {
        Indent indent = Indent.getNoneIndent();
        Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"getNoneIndent(...)");
        return indent;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        return this.isUnderHeader() ? Spacing.getReadOnlySpacing() : this.builder.getSpacing((Block)this, child1, child2);
    }

    private final boolean isUnderHeader() {
        for (ASTNode parent = this.getNode().getTreeParent(); parent != null && !(parent.getPsi() instanceof PsiFile); parent = parent.getTreeParent()) {
            if (!Intrinsics.areEqual((Object)parent.getElementType(), (Object)EditorConfigElementTypes.HEADER)) continue;
            return true;
        }
        return false;
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.isSeparator() && this.shouldAlignSeparators ? this.separatorAlignment : this.myAlignment;
    }

    private final boolean isSeparator() {
        return Intrinsics.areEqual((Object)this.getNode().getElementType(), (Object)EditorConfigElementTypes.SEPARATOR);
    }

    private final boolean isSection() {
        return Intrinsics.areEqual((Object)this.getNode().getElementType(), (Object)EditorConfigElementTypes.SECTION);
    }
}

