/*! @azure/msal-browser v4.26.1 2025-11-06 */
'use strict';
import { SignInContinuationState } from '../../../sign_in/auth_flow/state/SignInContinuationState.mjs';
import { RESET_PASSWORD_COMPLETED_STATE_TYPE } from '../../../core/auth_flow/AuthFlowStateTypes.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Represents the state that indicates the successful completion of a password reset operation.
 */
class ResetPasswordCompletedState extends SignInContinuationState {
    constructor() {
        super(...arguments);
        /**
         * The type of the state.
         */
        this.stateType = RESET_PASSWORD_COMPLETED_STATE_TYPE;
    }
}

export { ResetPasswordCompletedState };
//# sourceMappingURL=ResetPasswordCompletedState.mjs.map
