/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.freeplane.core.ui.MouseInsideListener;

public class AutoHide {
    private static final int DELAY = 500;
    final Timer timer;
    final JComponent popup;
    private MouseInsideListener mouseInsideListener;

    public static void start(JComponent popup) {
        new AutoHide(popup);
    }

    private AutoHide(JComponent popup) {
        this.popup = popup;
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoHide.this.tryToClosePopup();
            }
        });
        this.timer.setRepeats(true);
        popup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                AutoHide.this.popup.removeMouseListener(this);
                AutoHide.this.mouseInsideListener = new MouseInsideListener(AutoHide.this.popup);
                AutoHide.this.mouseInsideListener.mouseEntered(e);
                AutoHide.this.timer.start();
            }
        });
    }

    protected void tryToClosePopup() {
        if (this.popup.isVisible()) {
            if (!this.mouseInsideListener.isMouseInside()) {
                this.popup.setVisible(false);
                this.stop();
            }
        } else {
            this.stop();
        }
    }

    protected void stop() {
        this.mouseInsideListener.disconnect();
        this.timer.stop();
    }
}

