/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public abstract class NumberUtils {
    private static final NumberFormat LOCAL_FORMAT = NumberFormat.getNumberInstance();
    private static final NumberFormat UK_FORMAT = NumberFormat.getNumberInstance(Locale.UK);

    static {
        if (UK_FORMAT instanceof DecimalFormat) {
            ((DecimalFormat)UK_FORMAT).applyPattern("0.000");
        }
    }

    public static String formatNumberUk(double d, int n) {
        UK_FORMAT.setMaximumFractionDigits(n);
        UK_FORMAT.setMinimumFractionDigits(n);
        UK_FORMAT.setRoundingMode(RoundingMode.HALF_UP);
        return UK_FORMAT.format(d);
    }

    public static String formatNumberLocal(double d, int n) {
        int n2 = n < 0 ? 3 : n;
        LOCAL_FORMAT.setMaximumFractionDigits(n2);
        LOCAL_FORMAT.setMinimumFractionDigits(n2);
        LOCAL_FORMAT.setRoundingMode(RoundingMode.HALF_UP);
        return LOCAL_FORMAT.format(d);
    }

    public static int numberOfDecimalPlaces(String string) {
        String string2 = string == null ? "" : string.trim();
        int n = string2.length() - 1;
        int n2 = 0;
        boolean bl = false;
        while (n >= 0) {
            char c = string2.charAt(n);
            if (!Character.isDigit(c)) {
                if (c == '.' || c == ',') {
                    return bl || n2 == 0 ? n2 : -1;
                }
                return bl ? 0 : -1;
            }
            bl = true;
            --n;
            ++n2;
        }
        return bl ? 0 : -1;
    }

    public static String formatNumberLocalToMatch(double d, String string) {
        return NumberUtils.formatNumberLocal(d, NumberUtils.numberOfDecimalPlaces(string));
    }

    static Double parseDoubleUsingLocale(String string) {
        String string2;
        String string3 = string2 = string == null ? "" : string.trim();
        if (string2.isEmpty()) {
            return null;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (NumberUtils.isLocalDecimal(string)) {
                try {
                    NumberFormat numberFormat = NumberFormat.getInstance(Locale.getDefault());
                    return numberFormat.parse(string2).doubleValue();
                }
                catch (ParseException parseException) {}
            }
            return null;
        }
    }

    private static boolean isLocalDecimal(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        String string2 = "-0123456789";
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.getDefault());
        if (numberFormat instanceof DecimalFormat) {
            string2 = String.valueOf(string2) + ((DecimalFormat)numberFormat).getDecimalFormatSymbols().getDecimalSeparator();
        }
        int n = 0;
        while (n < string.length()) {
            if (string2.indexOf(string.charAt(n)) < 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String getValueSeparator() {
        char c;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.getDefault());
        if (numberFormat instanceof DecimalFormat && (c = ((DecimalFormat)numberFormat).getDecimalFormatSymbols().getDecimalSeparator()) == ',') {
            return "; ";
        }
        return ", ";
    }

    public static int getIntOrZero(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static double getDoubleOrZero(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return 0.0;
        }
    }
}

