/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.AbstractGeneratedEcKeyProviderFactory;
import org.keycloak.keys.GeneratedEcdsaKeyProvider;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;

public class GeneratedEcdsaKeyProviderFactory
extends AbstractGeneratedEcKeyProviderFactory<KeyProvider> {
    private static final Logger logger = Logger.getLogger(GeneratedEcdsaKeyProviderFactory.class);
    public static final String ECDSA_PRIVATE_KEY_KEY = "ecdsaPrivateKey";
    public static final String ECDSA_PUBLIC_KEY_KEY = "ecdsaPublicKey";
    public static final String ECDSA_ELLIPTIC_CURVE_KEY = "ecdsaEllipticCurveKey";
    protected static ProviderConfigProperty ECDSA_ELLIPTIC_CURVE_PROPERTY = new ProviderConfigProperty("ecdsaEllipticCurveKey", "Elliptic Curve", "Elliptic Curve used in ECDSA", "List", (Object)String.valueOf("P-256"), new String[]{"P-256", "P-384", "P-521"});
    public static final String ID = "ecdsa-generated";
    private static final String HELP_TEXT = "Generates ECDSA keys";
    public static final String DEFAULT_ECDSA_ELLIPTIC_CURVE = "P-256";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = AbstractGeneratedEcKeyProviderFactory.configurationBuilder().property(ECDSA_ELLIPTIC_CURVE_PROPERTY).build();

    public KeyProvider create(KeycloakSession session, ComponentModel model) {
        return new GeneratedEcdsaKeyProvider(session.getContext().getRealm(), model);
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return ID;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected boolean isValidKeyUse(KeyUse keyUse) {
        return KeyUse.SIG.equals((Object)keyUse);
    }

    @Override
    protected boolean isSupportedEcAlgorithm(String algorithm) {
        return algorithm.equals("ES256") || algorithm.equals("ES384") || algorithm.equals("ES512");
    }

    @Override
    protected String getEcEllipticCurveKey(String algorithm) {
        return GeneratedEcdsaKeyProviderFactory.convertJWSAlgorithmToECDomainParmNistRep(algorithm);
    }

    @Override
    protected ProviderConfigProperty getEcEllipticCurveProperty() {
        return ECDSA_ELLIPTIC_CURVE_PROPERTY;
    }

    @Override
    protected String getEcEllipticCurveKey() {
        return ECDSA_ELLIPTIC_CURVE_KEY;
    }

    @Override
    protected String getEcPrivateKeyKey() {
        return ECDSA_PRIVATE_KEY_KEY;
    }

    @Override
    protected String getEcPublicKeyKey() {
        return ECDSA_PUBLIC_KEY_KEY;
    }

    @Override
    protected String getDefaultEcEllipticCurve() {
        return DEFAULT_ECDSA_ELLIPTIC_CURVE;
    }

    public static String convertECDomainParmNistRepToJWSAlgorithm(String ecInNistRep) {
        switch (ecInNistRep) {
            case "P-256": {
                return "ES256";
            }
            case "P-384": {
                return "ES384";
            }
            case "P-521": {
                return "ES512";
            }
        }
        return null;
    }

    public static String convertJWSAlgorithmToECDomainParmNistRep(String algorithm) {
        switch (algorithm) {
            case "ES256": {
                return DEFAULT_ECDSA_ELLIPTIC_CURVE;
            }
            case "ES384": {
                return "P-384";
            }
            case "ES512": {
                return "P-521";
            }
        }
        return null;
    }
}

