#include "verasansmono_compressed.h"

#include <string>
#include <iostream>
#include <cassert>

namespace igl
{
namespace opengl
{

// The string below is a compression of a 256x256x256 font atlas where each pixel's grayscale value is represented by a byte.
// Source font atlas: https://github.com/prideout/recipes/blob/master/verasansmono.png
// The compression below is a pair: hex_value_of_pixel-recurrence_in_hex. If recurrence_in_hex==1,
// it was not appended to the pair and only the pixel value constitutes the item in the list.
// The method below can be used to recover the original format.
// For example, 0-d1e compresses to 3358 neighbouring pixels with value 0x00.
static char verasansmono_compressed_atlas[] = "0-d1e,66-4,0-4,66-4,0-17,44-2,0-8,44-2,0-9,22,66,0-18,1b,46,66,22,0-7,11,5d,1a,0-2,1b,46,66,22,0-4,24,55,5c,30,0-92,72-2,81,a0,0-4,72-2,81,a0,0-17,4c-2,0-8,6b-2,0-3,33,9a,0-4,35,a0,0-18,8e,7d,a0,35,0-6,4,5a,6e,b,0-2,8e,7d,a0,35,0-2,1,31,97,83,75,86,0-94,35,a0,0-6,35,a0,0-21,6b-2,0-3,35,a0,0-4,35,a0,0-18,2d,11,a0,35,0-6,1e,89,2f,0-3,2d,11,a0,35,0-2,e,75,77,1a,5,1f,0-83,12,63,8b-2,5c,0-3,13,67,8e,86,4a,3,0-3,35,a0,0-6,35,a0,0-c,84,49,0-4,49,84,0,64,97-2,64,0-3,1,1f,7a,92,57,77,6b,0,32,97,9a,a0,97-2,64,0,35,a0,2d,7a,90,64,8,0-4,1d-2,0-f,a0,35,0-6,5c,78,1,0-5,a0,35,0-2,27,92,32,0-85,b,66,8b,53,48,71,0-2,b,66,7a,48,5d,92,2a,0-3,35,a0,0-6,35,a0,0-c,6d,6e,0-4,6e,6c,0,2b,41,80,6b,0-3,10,73,7f,49,64,95,6b,0,15,41,61,a0,41-2,2b,0,35,a0,6c,4b,5e,97,3a,0-4,6b-2,0-f,a0,35,0-5,10,8e,38,0-6,a0,35,0-2,31,9c,25,4e,53,24,0-82,28,93,2d,3,1,6,0-2,28,92,3a,29,2e,7e,5e,0-3,35,a0,0-6,35,a0,0-c,46,92,5,5d,5c,4,93,46,0-3,6b-2,0-3,2b,95,22,1,13,7c,6b,0-3,35,a0,0-4,35,a0,21,1,9,73,62,0-4,50-2,0-f,a0,35,0-4,3,56,70,c,0-6,a0,35,0-2,35,9f,69,79,85,93,1e,0-81,33,9e,6,0-5,33,9e,9f-2,a0-2,6a,0-3,35,a0,0-6,35,a0,0-c,2d,97,29,6e-2,29,97,2c,0-3,6b-2,0-3,33,9e,4,0,2,6d,6b,0-3,35,a0,0-4,35,a0,3,0-2,6b,6a,0-15,a0,35,0-4,1d,88,32,0-7,a0,35,0-2,32,9d,33,5,1d,81,57,0-81,30,9a,13,0-5,2f,98,17,10-3,a,0-3,35,9f,2,0-5,35,9f,2,0-b,19,84,68,59-2,67,83,18,0-3,6b-2,0-3,30,9b,e,0,7,72,6b,0-3,35,a0,1,0-3,35,a0,0-3,6b-2,0-15,a0,35,0-4,58,7a,3,0-7,a0,35,0-2,28,92,8,0,3,6e,66,0-81,1c,86,5c,11,6,2c,0-2,1a,85,4f,10,4,1b,2e,0-3,2d,98,26,1,0-4,2d,98,26,1,0-a,8,72,94,3d,3f,94,71,8,0-3,6b-2,0-3,1f,8a,4a,8,30,8d,6b,0-3,31,9c,1e,1,0-2,35,a0,0-3,6b-2,0-4,3c-2,0-f,a0,35,0-3,f,8d,3a,0-8,a0,35,0-2,14,7f,3d,6,23,84,52,0-81,2,3d,8c,8e,8b,84,0-2,2,38,89,8d-2,89,57,0-3,10,6c,91,8e,5e,0-3,10,6c,91,8e,5e,0-a,53,8d,23-2,8e,53,0,2f,8e-2,9a-2,8e-2,2f,4,4e,90,8e,77,88,6b,0-3,19,79,90,8e,5e,0,35,a0,0-3,6b-2,0-4,6b-2,0-d,8e-2,a0,93,8e,2f,3,53,73,e,0-6,8e-2,a0,93,8e,2f,1,3b,8b,8d,8f,84,13,0-83,27,43-2,22,0-4,23,41,46,33,b,0-4,12,41,49,31,0-4,12,41,49,31,0-a,1c,3b,9,a,3b,1c,0,18,4a-6,18,0,4,36,46,21,32,31,0-3,1,1b,43,49,31,0,18,4a,0-3,31-2,0-4,31-2,0-d,4a-5,18,1c,86,33,0-7,4a-5,18,0,1,2c,45,3f,19,0-ea,6,13,4,0-5a5,15-4,0-4,15-4,0-c,7,15,0-11,e-2,0-b,7,15,0-22,d,6,0-2,1,9,12,15,10,5,0-4,d,14,10,3,0-4,d,14,10,3,0-7,4,14,6,1,9,12,15,10,5,0-3,3,10,15,12,8,0-6,e,15,0-4,6,d,0-9,4,14,6,0-2,8,12,13,a,0-52,a0-4,0-4,a0-4,0-c,35,a0,0-11,6b-2,0-b,35,a0,0-8,18,4a,0-17,4,6d,21,0-2,1e,6e,93,9d,8a,5a,8,0-2,1b,7c,9a,88,3f,0-3,1b,7c,9a,88,3f,0-7,33,86,1c,1e,6e,93,9d,8a,5a,8,0,6,43,8c,9d,92,68,d,0-4,6,83,a0,0-4,21,6d,4,0-8,33,86,1c,0,e,68,92,98,72,0-52,22-2,4c,a0,0-4,22-2,4c,a0,0-c,35,a0,0-11,17-2,0-b,35,a0,0-8,35,a0,0-17,32,6c,7,0-2,28,5d,30,25,4d,90,43,0,9,68,7b,30,61,92,10,0,9,68,7b,30,61,92,10,0-5,e,73,53,3,28,5d,30,25,4d,90,43,0,26,90,59,28,44,8e,4b,0-3,2,42,81,a0,0-4,7,6d,33,0-7,e,73,53,3,4,58,90,4c,2a,57,0-44,25,3f-2,20,0-3,1,28,41,3c,16,0-4,35,a0,0-6,35,a0,0-c,35,a0,b,34,43,26,0-3,1,28,41,3c,16,0-3,2f,47-2,2f,0-4,4,33,43,20,30,2f,0,35,a0,b,34,43,26,0-2,18,47,64,a0,47-2,2f,0-13,7,6d,44,0-7,5,70,65,0,21,8b,2f,0,18,83,41,0,21,8b,2f,0,18,83,41,0-5,3a,8d,f,0-5,5,70,65,0,32,9d,8,0,4,6f,64,0-3,1c,75,40,a0,0-5,45,6d,7,0-6,3a,8d,f,0,1c,87,50,2,0-44,2,3a,8b,90,8e,84,0-2,2,3a,89,8f,90,7e,d,0-3,35,a0,0-6,35,a0,0-c,35,a0,58,88,93,8d,1c,0,2,3a,89,8f,90,7e,d,0-2,61,90,9b,6b,0-3,3,4b,91,90,77,88,6b,0,35,a0,58,88,93,8d,1c,0,30,90,96,a0,90-2,61,0-4,52-2,0-d,1c,86,24,0-5,5,10,35,85,3f,0,2e,99,e,8,10,72,5c,0,2e,99,e,8,10,72,5c,0-4,3,7a,58,0-4,5,10,35,85,3f,0,1b,7f,44,15,30,82,35,0-2,1,58,4a,35,a0,0-5,24,86,1c,0-5,3,7a,58,0-2,2d,97,23,d,e,6,0-42,1b,86,5d,12,8,2e,0-2,1a,85,3f,8,1e,81,4c,0-3,35,a0,0-6,35,a0,0-c,35,a0,4d,a,20,84,56,0,1a,85,3f,8,1e,81,4c,0-4,6b-2,0-3,1f,89,4e,9,2f,8d,6b,0,35,a0,4d,a,20,84,56,0-3,35,a0,0-7,6b-2,0-d,2d,97,c,0-5,35,a0,9d,67,1,0,34,9f,2,53-2,6c,68,0,34,9f,2,53-2,6c,68,0-4,32,88,1d,0-4,35,a0,9d,67,1,0-2,30,97,a0,9b,5f,0-3,1d,78,14,35,a0,0-5,d,97,2d,0-5,32,88,1d,0-2,34,9f,4b,90,95,65,8,0-41,2f,9a,13,0-5,2f,9a,7b,77,79,94,66,0-3,35,a0,0-6,35,a0,0-c,35,a0,d,0,3,6d,68,0,2f,9a,7b,77,79,94,66,0-4,6b-2,0-3,30,9b,e,0,7,72,6b,0,35,a0,d,0,3,6d,68,0-3,35,a0,0-7,1a-2,0-d,33,9e,3,0-5,d,29,55,87,24,0,33,9e,3,15,17,6d,66,0,33,9e,3,15,17,6d,66,0-3,c,70,56,3,0-4,d,29,55,87,24,0,12,70,66,30,51,87,26,0,9,66,41,1,35,a0,0-5,3,9e,33,0-4,c,70,56,3,0-2,34,9f,5d,30,4f,93,3c,0-41,33,9e,6,0-5,33,9d,60,5f-3,3f,0-3,35,a0,0-6,35,a0,0-c,35,a0,0-3,6b-2,0,33,9d,60,5f-3,3f,0-4,6b-2,0-3,33,9e,4,0,2,6d,6b,0,35,a0,0-3,6b-2,0-3,35,a0,0-16,33,9d,4,0-7,7,72,5f,0,2d,97,12,0,9,74,58,0,2d,97,12,0,9,74,58,0-3,38,8e,10,0-7,7,72,5f,0,30,9a,b,0,6,70,5f,0,2d,93,44,41,61,a0,41,15,0-3,4,9d,33,0-4,38,8e,10,0-3,2e,98,c,0,5,70,64,0-41,29,93,2b,2,1,4,0-2,28,92,1c,2,1,3,5,0-3,33,9d,8,0-5,33,9d,8,0-b,35,a0,0-3,6b-2,0,28,92,1c,2,1,3,5,0-4,6b-2,0-3,2b,95,22,1,11,7a,6b,0,35,a0,0-3,6b-2,0-3,34,9f,5,0-6,6-2,0-d,2b,95,f,0-3,3,5,1-2,d,76,63,0,1d,88,38,1,1e,87,3a,0,1d,88,38,1,1e,87,3a,0-2,1,78,5c,0-4,3,5,1-2,d,76,63,0,32,9d,12,1,a,73,63,0,32,97-3,9a,a0,97,32,0-3,10,95,2b,0-3,1,78,5c,0-4,20,8b,13,1,9,73,61,0-41,b,68,8b,50,45,6e,0-2,a,64,86,4e,43,5b,5c,0-3,1f,8a,63,3f,29,0-3,1f,8a,63,3f,29,0-9,35,a0,0-3,6b-2,0,a,64,86,4e,43,5b,5c,0,15,3d-2,7f-2,3d-2,15,f,73,81,47,60,94,6b,0,35,a0,0-3,6b-2,0-3,28,92,5d,3f,29,0-4,6b-2,0-d,18,83,29,0-3,2e,70,46,42,6f,97,2e,0,5,5d,88,4a,73,8c,9,0,5,5d,88,4a,73,8c,9,0-2,2f,89,1e,0-4,2e,70,46,42,6f,97,2e,0,1a,83,77,44,62,97,34,0-5,35,a0,0-5,29,83,18,0-3,2f,89,1e,0-4,8,63,78,44,60,95,31,0-42,14,67,8f-2,5f,0-3,12,62,8d,94,79,2f,0-3,5,3d,8d,99,66,0-3,5,3d,8d,99,66,0-9,33,9a,0-3,66-2,0-2,12,62,8d,94,79,2f,0,33,9a-6,33,1,20,7d,95,59,77,68,0,33,9a,0-3,66-2,0-3,9,4e,90,99,66,0-4,66-2,0-d,5,67,4b,0-3,17,61,8e,97,7f,43,3,0-2,12,6e,93,7c,30,0-3,12,6e,93,7c,30,0-2,b,6e,5a,4,0-4,17,61,8e,97,7f,43,3,0,3,2b,7e,96,88,4f,5,0-5,33,9a,0-5,4b,68,5,0-2,b,6e,5a,4,0-5,15,6e,93,89,51,4,0-82,1d,e,3,1d,81,4e,0-24,26,72,a,0-1a,1a,5d,11,0-1f,b,73,26,0-3,1a,5d,11,0-8e,61,7a,70,81,91,17,0-24,3,66,23,0-3c,23,67,3,0-94,12,50,64,52,1a,0-1264,e,2f,47,50,55,1c,0-8,1c,55,39,0-9,1c,55,50,46,2f,d,0-df,1f,ae,d9,f1,fa,ff,55,0-8,55,ff,aa,0-9,55,ff,fa,f0,d9,ad,1d,0-6c,aa,ff-2,0-6e,13,b7,ff,fd,ca,b2,aa,39,0-8,55,ff,aa,0-9,39,aa,b2,cb,fd,ff,b6,12,0-6b,aa,ff-2,0-6e,37,e1,ff,bf,20,8,0-a,55,ff,aa,0-b,8,21,c2,ff,e1,37,0-6b,aa,ff-2,0-6e,4e,f8,ff,69,0-c,55,ff,aa,0-d,6a,ff,f8,4e,0-2c,8,44,91,a2,88,4b,1,0-8,25,7c,9e,98,6a,f,0-e,23,81,a3,9b,72,19,0-5,5,38,82,9e,a6,9b,7a,50,f,0-8,aa,ff-2,0-6e,54,fe,ff,57,0-c,55,ff,aa,0-d,57,ff,fe,54,0-1b,10,40,52,47,24,0-8,55,ff-2,6c,bc,fd,ff-4,b5,2b,0-5,9,8e,f3,ff-4,da,4a,ff-2,aa,0-5,55,ff-2,56,75,ef,ff-4,aa,0-4,24,c2,fd,ff-6,aa,0-4,aa,ff-b,55,0-4,55,ff-2,55,0-5,aa,ff-2,0-3,79,ff-2,59,0-6,5a,ff-2,79,0,df,ff,c4,1a,0-8,1a,c4,ff,de,0,4c,f7,ff,d5,30,0-3,6,ab,ff,fb,9d,0-3,72,ff-2,6e,0-6,62,ff-2,75,0-3,55,ff-a,55,0-8,55,ff-2,55,0-c,55,ff,aa,0-d,55,ff-2,55,0-1a,38,a9,ea,fd,f1,cd,57,8,0-6,55,ff-2,da,fa,b7,64,63,b3,f9,fd,bc,3,0-3,2,6b,fa,ff,d1,78,5f,8a,f5,d9,ff-2,aa,0-5,55,ff-2,86,f1,d8,76,5b,78,c9,aa,0-3,10,a4,ff-2,ae,6d,59,68,a8,ee,aa,0-4,aa,ff-b,55,0-4,55,ff-2,55,0-5,aa,ff-2,0-3,2a,ff-2,a2,6,0-4,7,a3,ff-2,29,0,aa,ff,de,34,0-8,34,de,ff,a9,0,3,9e,fe,fd,ab,0-3,59,fb,ff,cd,27,0-3,1d,fa,ff,b6,12,0-4,b,ab,ff,fd,23,0-3,55,ff-a,55,0-8,55,ff-2,55,0-c,55,ff,aa,0-d,55,ff-2,55,0-19,10,ba,f9,ff-4,d4,46,0-6,55,ff-3,73,5,0-2,4,70,ff-2,6d,1,0-2,37,e0,ff,c2,9,0-3,43,e2,ff-2,aa,0-5,55,ff-2,f2,9e,13,0-3,2,40,0-3,42,ec,ff,98,0-5,11,4f,0-8,aa,ff-2,0-a,55,ff-2,55,0-5,aa,ff-2,0-4,c5,ff,db,31,0-4,32,dc,ff,c5,0-2,6a,fe,fa,59,0-8,59,fa,fd,69,0-2,1b,b7,ff-2,70,6,41,e0,ff,f0,36,0-5,a5,ff,ef,4b,0-4,3c,e5,ff,b7,0-a,2,55,ff-2,db,33,0-8,57,ff-2,55,0-c,55,ff,aa,0-d,55,ff-2,56,0-19,64,ff-7,b9,0-6,55,ff-2,e3,c,0-4,c,e2,ff,b7,12,0-2,77,fd,f1,52,0-4,7,96,ff-2,aa,0-5,55,ff-2,f4,1e,0-9,52,fc,ff,61,0-f,aa,ff-2,0-a,55,ff-2,55,0-5,aa,ff-2,0-4,76,fe,fa,61,0-4,62,fa,fe,76,0-2,45,ee,ff,89,0-8,89,ff,ee,44,0-3,37,f7,ff,de,3f,c0,fe,fb,86,0-6,55,f4,ff,96,0-4,77,fd,fb,66,0-a,29,ce,ff-2,69,5,0-8,63,ff,fb,51,0-c,55,ff,aa,0-d,51,fb,ff,62,0-19,99,ff-7,ee,0-6,55,ff-2,95,0-6,95,ff,df,35,0-2,bf,ff,ca,20,0-5,41,ff-2,aa,0-5,55,ff-2,a5,0-a,4a,f4,ff,c6,35,13,0-d,aa,ff-2,0-a,55,ff-2,55,0-5,aa,ff-2,0-4,34,de,ff,c0,0-4,c1,ff,de,34,0-2,23,cd,ff,cb,0-2,42,eb,e9,3f,0-2,cb,ff,cd,23,0-4,6e,f4,ff,f6,ff-2,a4,11,0-6,18,bf,ff,f3,14,0-2,4,da,ff,d1,27,0-9,8,b8,ff,fc,a3,0-a,a5,ff,e7,3d,0-c,55,ff,aa,0-d,3d,e7,ff,a4,0-8,d,31,4d,53,49,31,a,0-5,1a,13,0-3,99,ff-7,ee,0-6,55,ff-2,6e,0-6,6e,ff,f1,47,0-2,e4,ff,b6,c,0-5,1a,ff-2,aa,0-5,55,ff-2,75,0-a,27,d1,ff-2,df,bd,90,5e,18,0-a,aa,ff-2,0-a,55,ff-2,55,0-5,aa,ff-2,0-4,d,b4,ff,f7,18,0-2,19,f7,ff,b4,e,0-2,a,b2,ff,f7,9,0,6d,fd-2,68,0,9,f6,ff,b2,a,0-4,13,ab,ff-3,eb,24,0-7,1,7b,ff-2,63,0-2,35,fe,ff,9e,6,0-8,1,62,fd,ff,d1,2b,0-7,1,1a,66,f1,ff,bc,17,0-c,55,ff,aa,0-d,16,bb,ff,f1,65,1a,1,0-4,32,af,db,f7,fd,f3,db,a9,64,1d,5,1a,59,c2,4c,0-3,64,ff-7,b9,0-6,55,ff-2,5a,0-6,5b,ff,fb,51,0-2,f8,ff,ac,2,0-5,6,ff-2,aa,0-5,55,ff-2,5a,0-b,43,d8,fb,ff-4,f6,a4,17,0-8,aa,ff-2,0-a,55,ff-2,55,0-5,aa,ff-2,0-5,5e,ff-2,74,0-2,74,ff-2,5f,0-4,7a,ff-2,42,0,b8,e9,ec,b3,0,42,ff-2,7b,0-6,14,e5,ff,f1,5a,0-9,17,f4,ff,bf,16,5,99,ff-2,3c,0-9,46,e3,ff,f3,3c,0-7,55,ff-3,f1,ad,1c,0-d,55,ff,aa,0-e,19,aa,f0,ff-3,55,0-3,aa,f3,ce,b1,ad,bd,d9,fc,ff-5,eb,45,0-3,10,ba,f9,ff-4,d4,46,0-6,55,ff-2,5a,0-6,5b,ff,fb,51,0-2,f9,ff,ac,2,0-5,6,ff-2,aa,0-5,55,ff-2,55,0-c,2e,6d,b8,ea,ff-4,90,a,0-7,aa,ff-2,0-a,55,ff-2,55,0-5,aa,ff-2,0-5,15,f8,ff,b4,f,10,b4,ff,f9,16,0-4,45,ff-2,77,5,ef,ac,b1,ec,4,76,ff-2,46,0-6,13,e3,ff,f1,59,0-a,b0,ff,ec,44,24,ce,ff,e0,6,0-8,6,c5,ff,fc,8e,1,0-7,55,ff-3,f1,a8,16,0-d,55,ff,aa,0-e,14,a5,f0,ff-3,55,0-3,85,56,24,7,3,13,2f,65,ab,eb,fa,e1,a9,45,c,0-4,38,a9,ea,fd,f1,cd,57,8,0-6,55,ff-2,6e,0-6,6e,ff,f2,48,0-2,e6,ff,b6,c,0-5,1a,ff-2,aa,0-5,55,ff-2,55,0-f,1,38,91,f5,ff,e6,3c,0-7,aa,ff-2,0-a,55,ff-2,55,0-4,3,ad,ff-2,0-6,aa,ff,e8,3f,40,e8,ff,ab,0-5,b,f8,ff,b0,4a,fb,61,64,fc,46,af,ff,f8,c,0-5,14,ac,ff-3,eb,27,0-9,4c,f1,ff,a2,61,fa,fe,7e,0-8,a,8a,ff-2,ab,15,0-9,2,1b,66,f1,ff,b8,15,0-c,55,ff,aa,0-d,15,b7,ff,f0,64,1b,2,0-18,10,40,53,47,24,0-8,55,ff-2,95,0-6,94,ff,e0,36,0-2,c2,ff,c9,1f,0-5,41,ff-2,aa,0-5,55,ff-2,55,0-11,6,9a,ff,fa,50,0-7,aa,ff-2,0-a,53,fd,ff,5b,0-4,e,b8,ff-2,0-6,60,fa,fd,79,7a,fd,fa,61,0-6,ce,ff,cc,a0,e3,39,3b,e5,9c,cb,ff,cf,0-6,76,f5,ff,f6,ff-2,a9,15,0-8,1c,c6,ff,ee,bd,ff,e8,40,0-8,4b,e8,ff,f0,2b,0-d,a2,ff,e6,3c,0-c,55,ff,aa,0-d,3c,e6,ff,a1,0-28,55,ff-2,e3,c,0-4,b,e2,ff,ba,14,0-2,7a,fd,f0,51,0-4,7,96,ff-2,aa,0-5,55,ff-2,55,0-12,63,ff,fb,51,0-7,9f,ff-2,f,0-9,47,f1,ff,83,0-4,33,dc,ff-2,0-6,26,d0,ff,d8-2,ff,d1,27,0-6,8c,ff,f4-2,bb,12,14,bc,"
"f2,f3,ff,8d,0-4,1,44,fb,ff,dc,3d,bd,fe,fd,94,2,0-8,71,ff-4,b1,e,0-7,1b,e2,ff,f0,5e,0-e,61,ff,fb,51,0-c,55,ff,aa,0-d,51,fb,ff,61,0-28,55,ff-3,73,5,0-2,4,6f,ff-2,71,1,0-2,39,e2,ff,c0,8,0-3,43,e2,ff-2,aa,0-5,55,ff-2,55,0-a,2b,4e,1,0-4,3,b2,ff,e6,3c,0-7,82,ff-2,48,0-9,31,db,ff,d1,6,0-3,8f,fb,ff-2,0-6,6,a0,ff,fd-2,ff,a2,6,0-6,5b,fb,ff-2,8d,1,2,8f,ff-2,fc,5d,0-4,25,c6,ff-2,66,5,3a,db,ff,f5,49,0-8,1c,f9,ff-3,6b,0-7,a,93,ff-2,9d,e,0-e,56,ff-2,55,0-c,55,ff,aa,0-d,55,ff-2,56,0-28,55,ff-2,db,f9,b6,63,62,b3,f9,fd,bf,4,0-3,2,6d,fa,ff,d0,77,5e,8a,f5,d7,ff-2,aa,0-5,55,ff-2,55,0-a,55,ff,dc,9a,65,58,75,c5,ff-2,91,a,0-7,31,f8,ff,e3,85,58,55-2,1c,0-4,8,9b,ff-2,bf,6a,66,ad,df,e1,ff-2,0-7,43,ff-4,45,0-7,35,df,ff-2,3f,0-2,41,ff-2,e0,36,0-3,a,b7,ff,fa,9a,0-3,4a,f6,ff,da,39,0-8,a4,ff-2,f3,10,0-7,4c,f6,ff,f7,62,55-6,1c,0-8,55,ff-2,55,0-c,55,ff,aa,0-d,55,ff-2,55,0-28,55,ff-2,6d,c1,fe,ff-4,b7,2d,0-5,9,8f,f3,ff-4,da,49,ff-2,aa,0-5,55,ff-2,55,0-a,55,ff-7,f8,a8,17,0-8,3,93,f7,ff-5,55,0-5,26,e0,ff-4,f6,5c,b0,ff-2,0-7,9,ea,ff-2,eb,a,0-7,1b,c5,ff,f4,a,0-2,b,f4,ff,c6,1c,0-2,2,6a,fd,ff,c7,23,0-3,2,95,fd,fe,bb,4,0-7,5b,fa,ff,b1,0-8,55,ff-a,55,0-8,55,ff-2,55,0-c,55,ff,aa,0-d,55,ff-2,55,0-28,55,ff-2,55,9,48,93,a2,89,4c,1,0-8,26,7d,9f,99,6b,10,0,ff-2,aa,0-5,39,aa-2,39,0-a,6,2c,62,84,a0,a7,99,76,27,1,0-a,2,2c,7c,9b,a9,aa-2,39,0-6,16,69,a2,a3,73,22,0,71,aa-2,0-8,6d,aa-2,6e,0-8,2,70,aa,7f,0-4,80,aa,72,2,0-2,24,95,aa-2,2b,0-5,15,87,aa-2,47,0-7,8c,ff,f5,54,0-8,39,aa-a,39,0-8,54,fe,ff,57,0-c,55,ff,aa,0-d,57,ff,fe,54,0-28,55,ff-2,55,0-16,ff-2,aa,0-76,4,e0,ff,d0,26,0-1c,4e,f8,ff,68,0-c,55,ff,aa,0-d,6a,ff,f8,4e,0-28,55,ff-2,55,0-16,ff-2,aa,0-75,1,60,ff-2,88,1,0-1c,37,e1,ff,bf,1f,7,0-a,55,ff,aa,0-b,8,20,c2,ff,e1,37,0-28,55,ff-2,55,0-16,ff-2,aa,0-74,1,3e,cd,ff,fd,2c,0-1d,13,b8,ff,fd,c9,b1,aa,39,0-8,55,ff,aa,0-9,39,aa,b2,ca,fd,ff,b6,12,0-28,55,ff-2,55,0-16,ff-2,aa,0-73,55,ff-3,f5,83,0-1f,20,af,d9,f1,fa,ff,55,0-8,55,ff,aa,0-9,55,ff,fa,f1,d9,ae,1e,0-29,55,ff-2,55,0-16,ff-2,aa,0-73,55,ff,fa,dd,70,13,0-20,e,2f,47,50,55,1c,0-8,55,ff,aa,0-9,1c,55,50,47,2f,e,0-ee,55,ff,aa,0-fd,1c,55,39,0-43a,20,55,52,8,0-fc,21,dc,fc,66,2,0-fc,34,d2,e9,53,0-1a,55,ff-2,55,0-25,aa,ff-2,0-19,9,63,b6,ed,fc,ff-2,aa,0-13,55,ff-2,55,0-11,aa,ff-2,0-e,ff-2,aa,0-8,aa,ff-2,0-b,aa,ff-6,aa,0-3b,2,45,f7,d5,12,0-19,55,ff-2,55,0-25,aa,ff-2,0-18,3,70,f6,ff-5,aa,0-13,55,ff-2,55,0-11,aa,ff-2,0-e,ff-2,aa,0-8,aa,ff-2,0-b,aa,ff-6,aa,0-3d,5c,eb,aa,14,0-18,55,ff-2,55,0-25,aa,ff-2,0-18,30,da,ff,cc,2b,6,0-16,55,ff-2,55,0-11,aa,ff-2,0-e,ff-2,aa,0-8,aa,ff-2,0-10,ff-2,aa,0-3d,a,42,4a,12,0-18,55,ff-2,55,0-25,aa,ff-2,0-18,4a,f4,ff,6c,0-18,55,ff-2,55,0-11,39,55-2,0-e,55-2,39,0-8,aa,ff-2,0-10,ff-2,aa,0-4a,6,21,35,47,50,54,4d,35,13,0-6,55,ff-2,55,4,23,49,51,44,26,1,0-9,9,2a,48,52,51,48,30,14,0-6,a,2f,4c,50,3e,18,0,aa,ff-2,0-6,1,18,40,50,52,43,1a,1,0-a,54,fe,ff,55,0-a,a,2f,4d,50,3d,17,0-8,55,ff-2,55,2,1a,45,51,47,25,0-27,aa,ff-2,0-10,ff-2,aa,0-b,9,38,51,36,1,4,3c,52,3d,d,0-8,2,1d,47,53,49,28,0-9,10,3a,4e,53,4a,2a,7,0-17,77,cb,df,f1,fa,fe,f7,df,ba,40,2,0-4,55,ff-2,55,6e,cb,f3,fb,ee,d0,65,a,0-7,21,a2,d4,f2,fc,fb,f2,da,be,0-5,13,9c,d9,f6,fa,e8,bf,33,aa,ff-2,0-6,60,bd,ea,fa,fc,ed,bf,5a,0-6,39,aa-3,c6,ff-2,c6,aa-4,71,0-4,10,99,d9,f7,fa,e7,bd,2c,71,aa-2,0-4,55,ff-2,55,4e,be,ef,fb,f1,cf,49,0-6,71,aa-6,0-a,aa-6,71,0-8,aa,ff-2,0-5,1b,a4,aa-2,75,0-6,ff-2,aa,0-8,71,aa-2,69,e2,fb,e0,4a,66,e6,fc,e7,85,0-4,39,aa-2,39,54,c2,f1,fd,f3,d2,4d,1,0-6,3c,ad,e4,f8,fd,f4,d4,97,10,0-16,aa,fc,e5,c1,b1,ad,b9,e5,fe,f2,71,0-4,55,ff-2,bb,fc,db,b1-2,da,fc,fb,95,2,0-5,56,e4,ff,f4,c3,af,b0,c0,e8,fe,0-4,24,c4,ff,f9,c3,af,bd,ea,dd-2,ff-2,0-4,f,8a,ff,fc,ca,b0,b4,d6,ff-2,6d,6,0-4,55,ff-b,aa,0-3,20,bd,ff,fb,c7,af,ba,e7,d7-2,ff-2,0-4,55,ff-2,98,f4,cc,ae,bc,f6,ff,e2,3d,0-5,aa,ff-6,0-a,ff-6,aa,0-8,aa,ff-2,0-4,39,cf,ff-2,aa,1d,0-6,ff-2,aa,0-8,aa,ff-2,d5,b3,f4,ff,ee,e6,b5,d9,ff,fe,26,0-3,55,ff-2,9e,f4,cc,ae,bc,f6,ff,e4,3f,0-4,2,49,f7,ff,e7,ba,ad,c2,f9,ff,c4,26,0-15,8f,74,3b,17,7,3,f,48,cf,ff,eb,17,0-3,55,ff-2,fd,ba,36,7-2,35,b9,ff,f8,3d,0-4,1a,e1,ff,e3,67,19,5,6,16,44,a5,0-4,8e,fb,f7,88,19,5,13,4b,f1,fe,ff-2,0-4,62,f1,f8,92,20,6,a,2c,c3,ff,de,34,0-4,1c,55-3,8e,ff-2,8e,55-4,39,0-3,84,fa,f9,92,1d,5,10,45,ed,fd,ff-2,0-4,55,ff-2,f5,91,22,4,12,89,fa,fe,89,0-5,39,55-3,c6,ff-2,0-a,55-4,ff-2,aa,0-8,aa,ff-2,0-3,20,d1,fe,ff,c3,1c,0-7,ff-2,aa,0-8,aa,ff-2,5d,9,aa,ff-2,b1,b,54,ff-2,60,0-3,55,ff-2,f6,91,22,4,12,89,fa,fe,8b,0-4,21,c5,ff,ed,46,10,3,18,87,f6,fb,92,0-1d,4b,ff-2,69,0-3,55,ff-2,f1,1b,0-4,19,f1,ff,ad,b,0-2,6,97,ff,fc,49,0-a,16,f7,ff,a7,c,0-4,6b,f9,ff-2,0-3,b,e6,ff,9e,a,0-4,38,e1,ff,91,0-8,55,ff-2,55,0-7,12,f4,ff,ad,f,0-4,66,f8,ff-2,0-4,55,ff-2,d8,4,0-3,22,cc,ff,d1,0-9,aa,ff-2,0-e,ff-2,aa,0-8,aa,ff-2,0-2,3f,d4,ff-2,a3,19,0-8,ff-2,aa,0-8,aa,ff-2,1b,0,6e,ff-2,71,0,18,ff-2,8a,0-3,55,ff-2,d8,4,0-3,22,cc,ff,d3,0-4,6d,fd,f7,64,0-4,c,a7,ff,fa,1a,0-1c,14,ff-2,90,0-3,55,ff-2,b3,0-6,b2,ff,d4,2a,0-2,23,cd,ff,ce,3,0-a,54,ff-2,5c,0-5,30,da,ff-2,0-3,44,ff-2,45,0-5,14,be,ff,cd,0-8,55,ff-2,55,0-7,4f,ff-2,61,0-5,2e,d8,ff-2,0-4,55,ff-2,8f,0-4,a,b4,ff,ee,0-9,aa,ff-2,0-e,ff-2,aa,0-8,aa,ff-2,0,26,d6,fe,ff,bc,18,0-9,ff-2,aa,0-8,aa,ff-2,a,0,5f,ff-2,60,0,9,ff-2,9c,0-3,55,ff-2,8f,0-4,a,b4,ff,f0,0-4,af,ff,d7,2d,0-5,5b,ff-2,58,0-15,4,1e,3f,4d,54,55-3,ff-2,a4,0-3,55,ff-2,76,0-6,77,ff,ef,45,0-2,43,ed,ff,81,0-b,8a,ff-2,21,0-5,11,bb,ff-2,0-3,86,ff-2,5e,54-3,55-2,57,c9,ff,f4,0-8,55,ff-2,55,0-7,87,ff-2,22,0-5,11,bb,ff-2,0-4,55,ff-2,62,0-4,1,ab,ff,fc,0-9,aa,ff-2,0-e,ff-2,aa,0-8,aa,ff-2,45,d9,ff,fe,9b,16,0-a,ff-2,aa,0-8,aa,ff-2,1,0,57,ff-2,56,0,2,ff-2,a7,0-3,55,ff-2,62,0-4,1,ab,ff,fe,0-4,e2,ff,b9,f,0-5,1f,ff-2,8c,0-14,f,8c,c8,e9,f7,fe,ff-5,a9,0-3,55,ff-2,5f,0-6,60,ff,f9,4f,0-2,50,fa,ff,63,0-b,9e,ff-2,a,0-5,6,b0,ff-2,0-3,a0,ff-2,fe-4,ff-5,fe,0-8,55,ff-2,55,0-7,9d,ff-2,b,0-5,5,af,ff-2,0-4,55,ff-2,57,0-5,aa,ff-2,0-9,aa,ff-2,0-e,ff-2,aa,0-8,aa,ff-2,db,ff-2,f6,20,0-b,ff-2,aa,0-8,aa,ff-2,0-2,55,ff-2,55,0-2,ff-2,aa,0-3,55,ff-2,57,0-5,aa,ff-2,0-4,f7,ff,ae,4,0-5,9,ff-2,a1,0-13,2b,ca,ff,fe,d5,ba,ac,aa-3,ff-2,aa,0-3,55,ff-2,58,0-6,59,ff,fc,52,0-2,54,fe,ff,59,0-b,a5,ff-2,3,0-5,2,ac,ff-2,0-3,a8,ff,f8,aa-a,0-8,55,ff-2,55,0-7,a6,ff-2,3,0-5,2,ac,ff-2,0-4,55,ff-2,55,0-5,aa,ff-2,0-9,aa,ff-2,0-e,ff-2,aa,0-8,aa,ff-6,98,d,0-a,ff-2,aa,0-8,aa,ff-2,0-2,55,ff-2,55,0-2,ff-2,aa,0-3,55,ff-2,55,0-5,aa,ff-2,0-4,fd,ff,ab,1,0-5,2,ff-2,a8,0-13,90,fd,fa,9b,2b,10,2,0-2,7,ff-2,aa,0-3,55,ff-2,63,0-6,63,ff,f6,4c,0-2,4e,f8,ff,68,0-b,99,ff-2,d,0-5,7,b1,ff-2,0-3,9c,ff,f2,0-12,55,ff-2,55,0-7,9a,ff-2,f,0-5,7,b1,ff-2,0-4,55,ff-2,55,0-5,aa,ff-2,0-9,aa,ff-2,0-e,ff-2,aa,0-8,aa,ff-2,fd,af,e2,ff,ee,5a,0-a,ff-2,aa,0-8,aa,ff-2,0-2,55,ff-2,55,0-2,ff-2,aa,0-3,55,ff-2,55,0-5,aa,ff-2,0-4,f3,ff,b0,6,0-5,d,ff-2,9e,0-13,e7,ff,c0,16,0-5,29,ff-2,aa,0-3,55,ff-2,8b,0-6,8a,ff,e4,3a,0-2,38,e2,ff,9d,0-b,75,ff-2,33,0-5,1b,c5,ff-2,0-3,72,ff-2,1e,0-11,55,ff-2,55,0-7,75,ff-2,38,0-5,1b,c5,ff-2,0-4,55,ff-2,55,0-5,aa,ff-2,0-9,aa,ff-2,0-e,ff-2,aa,0-8,aa,ff-2,8c,10,4a,e8,ff,ee,27,0-9,fe,ff,aa,0-8,aa,ff-2,0-2,55,ff-2,55,0-2,ff-2,aa,0-3,55,ff-2,55,0-5,aa,ff-2,0-4,d2,ff,c3,19,0-5,32,ff-2,7c,0-13,fc,ff,ae,4,0-5,6d,ff-2,aa,0-3,55,ff-2,c5,0-6,c3,ff,cb,21,0-2,1a,c4,ff,e3,8,0-a,43,ff-2,6c,0-5,39,e3,ff-2,0-3,37,ff-2,67,0-11,55,ff-2,55,0-7,41,ff-2,76,0-5,38,e2,ff-2,0-4,55,ff-2,55,0-5,aa,ff-2,0-9,aa,ff-2,0-e,ff-2,aa,0-8,aa,ff-2,f,0,9,86,ff-2,a6,12,0-8,f5,ff,af,5,0-7,aa,ff-2,0-2,55,ff-2,55,0-2,ff-2,aa,0-3,55,ff-2,55,0-5,aa,ff-2,0-4,a1,ff,e0,36,0-5,6d,ff-2,4c,0-13,e0,ff,cd,24,0-4,3d,d8,ff-2,aa,0-3,55,ff-3,4e,3,0-2,2,4b,ff-2,85,1,0-3,66,ff-2,8e,f,0-4,2,26,0-3,2,d9,ff,cd,27,0-3,6,a3,ff-3,0-4,c0,ff,d8,3e,0-5,1,28,16,0-8,55,ff-2,55,0-7,2,d6,ff,d4,32,0-3,4,a0,ff-3,0-4,55,ff-2,55,0-5,aa,ff-2,0-9,aa,ff-2,0-e,ff-2,aa,0-8,aa,ff-2,0-3,4,be,fe,fb,88,0-8,c9,ff,d0,26,0-7,aa,ff-2,0-2,55,ff-2,55,0-2,ff-2,aa,0-3,55,ff-2,55,0-5,aa,ff-2,0-4,4e,f1,ff,9b,4,0-3,28,cd,ff,e2,7,0-13,96,ff,f8,ab,2a,6,18,58,d3,e6,ff-2,aa,0-3,55,ff-2,fc,d9,64,e,d,61,d6,ff,ef,1f,0-4,d,c7,ff,f1,a3,32,9,a,28,79,cd,0-4,6c,f7,fb,b9,32,8,24,85,f7,fd,ff-2,0-4,4b,e6,fe,d5,5c,1a,3,12,49,8c,d2,4e,0-8,55,ff-2,55,0-8,68,f5,fc,c5,3c,b,20,7e,ef,f7,ff-2,0-4,55,ff-2,55,0-5,aa,ff-2,0-9,aa,ff-2,0-e,ff-2,aa,0-8,aa,ff-2,0-4,3f,df,ff,f1,37,0-7,7f,fe,f8,99,14,1,0-5,aa,ff-2,0-2,55,ff-2,55,0-2,ff-2,aa,0-3,55,ff-2,55,0-5,aa,ff-2,0-4,15,b3,ff,f6,7d,20,6,30,b9,fb,f9,78,0-14,20,ad,fe,ff-5,d2,44,ff-2,aa,0-3,55,ff-2,83,de,fe,ff-4,d6,49,0-6,1e,a1,f7,ff-7,0-4,9,79,f3,ff-4,fd,a0,c0,ff-2,0-5,45,d9,fc,ff-7,55,0-8,55,ff-2,55,0-8,8,76,f2,ff-4,fc,90,b8,ff,fe,0-4,55,ff-2,55,0-5,aa,ff-2,0-4,55,ff-b,aa,0-9,ff-2,aa,0-8,aa,ff-2,0-5,57,fa,ff,cd,28,0-6,1b,a8,ff-6,0-3,aa,ff-2,0-2,55,ff-2,55,0-2,ff-2,aa,0-3,55,ff-2,55,0-5,aa,ff-2,0-5,18,c3,f9,ff-5,f3,7f,c,0-15,1c,80,cc,f6,fa,d9,99,2f,3,ff-2,aa,0-3,55,ff-2,55,3d,9b,e7,f7,dd,a0,32,4,0-7,11,5f,aa,e6,fa,f9,e5,b7,7e,0-5,9,5d,b3,ee,f6,d1,83,18,aa,ff-2,0-6,31,7d,cf,f1,fd,f4,d9,b8,81,23,0-8,55,ff-2,55,0-9,8,5c,b5,ef,f5,cd,7c,14,ac,ff,f5,0-4,55,ff-2,55,0-5,aa,ff-2,0-4,55,ff-b,aa,0-9,ff-2,aa,0-8,aa,ff-2,0-5,5,a9,ff,fb,9d,0-7,1c,87,d4,f9,ff-3,0-3,aa,ff-2,0-2,55,ff-2,55,0-2,ff-2,aa,0-3,55,ff-2,55,0-5,aa,ff-2,0-6,20,70,cb,f1,fc,ea,ab,5a,9,0-7d,10,ba,ff,d8,0-29,7,ff-2,a3,0-cf,33,dd,ff,a1,0-29,26,ff-2,8a,0-c7,49,a7,47,23,8,3,10,33,c2,ff,e5,3e,0-28,18,99,ff,fe,42,0-c7,55,ff,ef,cd,b2,ad,ba,dd,ff-2,76,9,0-24,39,aa-3,c2,f4,ff,c6,7,0-c7,3c,c2,df,f0,fb,fd,f4,e1,b3,51,0-26,55,ff-3,f9,e6,9d,20,0-c8,4,18,35,46,51,53,4a,37,11,0-27,1c,55-3,4f,3c,c,0-76b,3,2e,80,9c-2,7f,2d,3,0-18,1,25,74,97,a4,92,59,1a,0-7a,aa-6,0-18,aa-6,0-28,55,ff-5,fd,f2,d2,9f,45,d,0-5,1b,af,fb,ff-4,fa,ad,1a,0-5,ff-5,fd,ec,cc,81,37,0-7,1c,a7,f8,ff-5,fc,ab,29,0-2,55,ff-e,55,0-2,ff-2,aa,0-6,aa,ff-2,0-2,40,ea,ff,9d,0-8,9d,ff,ea,40,eb,ff,b9,f,0-8,f,b9,ff,ea,0,56,fd,ff,b6,15,0-5,30,f8,ff,d1,2a,2e,d7,ff,ed,1a,0-6,1b,ef,ff,d7,2d,0-2,ff-d,55,0-6,ff-6,0-5,6a,ff-2,40,0-f,ff-6,0-b,17,d2,ff,e9,55,0-18,55,ff-9,ec,96,2,0-3,13,9f,ff-2,a6,67,69,a6,ff-2,9c,12,0-4,ff-8,fd,df,51,1,0-4,16,a3,ff-2,c1,77,5c,6d,b6,f4,ff,55,0-2,55,ff-e,55,0-2,ff-2,aa,0-6,aa,ff-2,0-2,1e,c8,ff,df,0-8,df,ff,c8,1e,c8,ff,c9,1f,0-8,20,ca,ff,c8,0,7,c2,ff,f3,61,0-4,10,a7,ff-2,69,3,5,80,ff-2,84,4,0-4,4,87,ff-2,80,5,0-2,ff-d,55,0-6,ff-2,c6,55-3,0-5,13,ef,ff,9f,8,0-e,55-3,c6,ff-2,0-a,d,92,ff-3,da,19,0-17,55,ff-2,55,0-2,3,15,5f,c4,ff-2,81,5,0-2,6d,f9,f3,70,0-4,70,f3,f8,69,0-4,ff-2,aa,0-2,3,1e,66,e1,ff,e7,46,0-4,74,fc,f5,82,0-5,24,ae,4b,0-8,55,ff-2,55,0-8,ff-2,aa,0-6,aa,ff-2,0-2,1,92,ff-2,35,0-6,35,ff-2,92,1,9e,ff,df,35,0-8,35,df,ff,9e,0-2,3b,e2,ff,e9,19,0-3,72,f8,ff,b9,1,0-2,a,db,ff,e5,43,0-4,45,e6,ff,da,9,0-c,3e,fb,ff,cf,29,0-6,ff-2,aa,0-9,83,fd,e7,41,0-11,aa,ff-2,0-9,1,87,f9,ea,75,d5,ff,ba,1d,0-16,55,ff-2,55,0-4,1,24,e6,ff,ce,24,0-2,cb,ff,c2,18,0-4,18,c2,ff,c8,0-4,ff-2,aa,0-5,60,ef,ff,9a,0-4,c5,ff,c9,1f,0-6,15,12,0-8,55,ff-2,55,0-8,ff-2,aa,0-6,aa,ff-2,0-3,50,ff-2,78,0-6,78,ff-2,50,0,7c,ff,f0,46,0-8,46,f0,ff,7b,0-2,8,8b,ff-2,88,5,0,16,e4,ff,e5,45,0-4,6b,f8,fe,aa,0-4,ac,fe,f8,6b,0-c,1a,b8,ff-2,5f,3,0-6,ff-2,aa,0-9,39,e1,fe,91,0-11,aa,ff-2,0-9,46,f2,ff,70,9,46,dd,f9,94,0-16,55,ff-2,55,0-6,7e,ff,f2,48,0,23,ff-2,77,0-6,79,ff-2,21,0-3,ff-2,aa,0-5,13,bd,ff,e2,0-4,f4,ff,ad,3,0-10,55,ff-2,55,0-8,ff-2,aa,0-6,aa,ff-2,0-3,9,f1,ff,bb,11,0-4,11,bb,ff,f1,9,0,55,fb,ff,61,0-8,62,ff,fb,55,0-3,c,da,ff,eb,4f,d,a0,ff-2,75,2,0-4,13,b0,ff-2,4a,0-2,4c,ff-2,b0,13,0-c,8f,fd-2,a7,0-8,ff-2,aa,0-9,5,94,ff,f6,1b,0-10,aa,ff-2,0-8,3f,dd,f4,83,0-3,39,e8,ff,6b,6,0-14,55,ff-2,55,0-6,5c,ff,fc,52,0,55,ff-2,48,0-6,49,ff-2,53,0-3,ff-2,aa,0-5,3,ad,ff,f8,0-4,f7,ff,ba,10,0-10,55,ff-2,55,0-8,ff-2,aa,0-6,aa,ff-2,0-4,b7,ff,dd,33,0-4,32,dc,ff,b8,0-2,42,ec,ff,83,0-2,4c,aa-2,4c,0-2,83,ff,ed,43,0-4,66,f5,ff,c2,51,ec,ff,d8,10,0-6,44,ff-2,b5,16-2,b6,ff-2,44,0-c,32,f2,ff,d9,34,0-8,ff-2,aa,0-a,32,fe,ff,78,0-10,aa,ff-2,0-7,b,c7,fe,98,12,0-4,65,ed,e2,45,0-14,55,ff-2,55,0-6,72,ff,f5,4b,0,80,ff-2,23,0-6,24,ff-2,7e,0-3,ff-2,aa,0-5,b,b5,ff,ec,0-4,c9,ff,f3,7c,12,0-f,55,ff-2,55,0-8,ff-2,aa,0-6,aa,ff-2,0-4,66,fc,fd,67,0-4,66,fd,fc,67,0-2,2d,d7,ff,ad,0-2,a2,ff-2,a2,0-2,ae,ff,d7,2d,0-4,d,a1,ff-2,f5,ff,ea,4b,0-8,a5,fe,f9,71,72,fa,fe,a4,0-c,1e,c3,ff,fb,55,0-9,ff-2,aa,0-b,b0,ff,d2,28,0-f,aa,ff-2,0-6,12,a3,fa,aa,4,0-5,2,5a,f5,e5,25,0-13,55,ff-2,55,0-5,1,c1,ff,e0,36,0,95,ff-2,"
"10,0-6,11,ff-2,94,0-3,ff-2,aa,0-5,2a,d4,ff,bb,0-4,73,fa,ff,f5,b6,79,30,7,0-c,55,ff-2,55,0-8,ff-2,aa,0-6,aa,ff-2,0-4,3a,e4,ff,a9,0-4,a7,ff,e5,3b,0-2,1c,c6,ff,d0,0-2,d3,ff-2,d2,0-2,d0,ff,c6,1c,0-5,2d,f7,ff-3,9b,c,0-8,40,e3,ff,df,e0,ff,e3,3f,0-c,7f,f8,ff,b5,6,0-9,ff-2,aa,0-b,55,f2,f9,68,0-f,aa,ff-2,0-6,11,4a,50,1b,0-7,3,4b,55,22,0-13,55,ff-2,55,0-2,1,a,31,99,ff-2,9d,a,0,a2,ff-2,5,0-6,6,ff-2,a1,0-3,ff-2,aa,0-2,1,c,2b,b1,ff,e9,4b,0-4,e,84,f3,ff-4,f0,a5,57,e,0-9,55,ff-2,55,0-8,ff-2,aa,0-6,aa,ff-2,0-4,11,b9,ff,f2,a,0-2,a,f1,ff,ba,12,0-2,8,b0,ff,f6,4,11,fd,d7-2,fd,10,4,f6,ff,b0,8,0-6,80,fb,ff,e6,13,0-9,3,80,ff-4,80,3,0-b,39,fa,ff,d2,2b,0-a,ff-2,aa,0-b,12,b4,ff,db,8,0-e,aa,ff-2,0-28,55,ff-2,c6,aa-2,ab,b4,da,fb,ff,df,24,0-2,a7,ff-2,2,0-6,2,ff-2,a7,0-3,ff-2,e3,aa-2,ab,b6,d5,ff,f3,64,a,0-5,a,5b,b6,fd,ff-4,f4,9c,1d,0-8,55,ff-2,55,0-8,ff-2,aa,0-6,aa,ff-2,0-4,1,86,ff-2,41,0-2,3e,ff-2,87,1,0-3,96,ff-2,1d,40,ff,a3-2,ff,3f,1d,ff-2,96,0-7,6e,fb,ff,df,8,0-a,17,eb,ff-2,ea,17,0-b,17,b3,ff-2,64,3,0-a,ff-2,aa,0-c,60,ff-2,4b,0-e,aa,ff-2,0-28,55,ff-5,fe,f9,e9,d0,86,1a,0-3,9e,ff-2,8,0-6,a,ff-2,a1,0-3,ff-8,b8,32,0-a,15,4c,8d,ba,ef,ff-2,c1,7,0-7,55,ff-2,55,0-8,ff-2,aa,0-6,aa,ff-2,0-5,33,ff-2,93,2-2,91,ff-2,34,0-4,6c,ff-2,47,7c,fd,64-2,fd,7b,47,ff-2,6c,0-6,1c,ec,ff-3,83,6,0-a,73,ff-2,73,0-c,89,fc,fd,ac,0-c,ff-2,aa,0-c,4,da,ff,b9,13,0-d,aa,ff-2,0-28,55,ff-2,8e,55-2,54,4f,3f,26,2,0-4,92,ff-2,13,0-6,14,ff-2,93,0-3,ff-2,c7,5a,62,75,c0,fb,f8,bc,d,0-b,1,12,58,d7,ff,fe,42,0-7,55,ff-2,55,0-8,ff-2,aa,0-6,aa,ff-2,0-5,6,e9,ff,c1,18,16,bf,ff,ea,6,0-4,49,ff-2,6e,a7,eb,41-2,eb,a6,6e,ff-2,4a,0-5,6,8c,ff-4,df,38,0-a,55,ff-2,55,0-b,2d,f0,ff,db,38,0-c,ff-2,aa,0-d,79,fd,ec,46,0-d,aa,ff-2,0-28,55,ff-2,55,0-b,6f,ff-2,2f,0-6,30,ff-2,76,0-3,ff-2,aa,0-3,5,6f,fe,ff,99,b,0-d,46,ff-2,8d,0-7,55,ff-2,55,0-8,fc,ff,aa,0-6,aa,ff,fb,0-6,9b,ff,eb,42,40,e9,ff,9c,0-5,1f,ff-2,b3,c9,cb,21-2,cb,c8,b2,ff-2,20,0-5,51,ec,ff,d5,70,f4,ff,c0,7,0-9,55,ff-2,55,0-a,1b,bf,ff,fc,5a,0-d,ff-2,aa,0-d,26,cf,ff,b4,0-d,aa,ff-2,0-28,55,ff-2,55,0-b,4b,ff-2,53,0-6,53,ff-2,51,0-3,ff-2,aa,0-4,a,ca,ff,e7,40,0-d,d,ff-2,a4,0-7,55,ff-2,55,0-8,f4,ff,aa,0-5,1,ab,ff,f3,0-6,5c,fa,fe,73,6f,fd,fa,5d,0-5,5,f7,ff,e6,e8,b0,8-2,af,e7,e5,ff,f8,5,0-4,3,c4,ff,f3,61,16,b8,ff,fd,58,0-9,55,ff-2,55,0-a,79,f7,ff,ba,7,0-d,ff-2,aa,0-d,4,8a,ff,f7,24,0-c,aa,ff-2,0-28,55,ff-2,55,0-b,d,f5,ff,94,4,0-4,4,94,ff,f9,16,0-3,ff-2,aa,0-5,4c,ee,ff,b8,1,0-c,14,ff-2,98,0-7,55,ff-2,55,0-8,dc,ff,b0,6,0-4,7,b1,ff,dd,0-6,2c,d6,ff,c6,c2,ff,d7,2d,0-6,d2,ff-3,78,0-2,76,ff-3,d3,0-4,3,70,ff-2,9e,c,0,2b,f1,ff,d6,2f,0-8,55,ff-2,55,0-9,34,f8,ff,d5,2e,0-e,ff-2,aa,0-e,1a,f2,ff,97,6,0-b,aa,ff-2,0-28,55,ff-2,55,0-c,b5,ff,cf,25,0-4,25,ce,ff,c5,0-4,ff-2,aa,0-5,13,b9,ff,f9,2c,0-3,57,7,0-7,5c,ff-2,6e,0-7,55,ff-2,55,0-8,b7,ff,c6,1c,0-4,1d,c7,ff,b7,0-6,c,b3,ff,f7,f6,ff,b4,d,0-6,b0,ff-3,43,0-2,42,ff-3,b1,0-4,2a,d2,ff,f6,29,0-3,90,fe,fc,97,0-8,55,ff-2,55,0-8,15,ae,ff-2,6a,4,0-e,ff-2,aa,0-f,a5,ff,d7,2d,0-b,aa,ff-2,0-28,55,ff-2,55,0-c,3f,e6,ff,b4,28,9-2,28,b3,ff,ef,51,0-4,ff-2,aa,0-6,48,fe,ff,a3,a,0-2,fd,ca,58,2c,d,3,8,1e,6c,e5,ff,e7,15,0-7,55,ff-2,55,0-8,59,f4,fc,9a,21,7,8,21,9d,fc,f4,59,0-7,6b,ff-4,6d,0-7,85,ff-2,f7,a,0-2,a,f7,ff-2,87,0-3,2,a6,ff,f9,7a,0-4,1e,c0,ff,fe,46,0-7,55,ff-2,55,0-8,83,fb,fe,b1,0-10,ff-2,aa,0-f,3d,e6,ff,86,0-b,aa,ff-2,0-28,55,ff-2,55,0-c,9,77,ff-2,d2,b3-2,d2,ff-2,94,e,0-4,ff-2,aa,0-6,7,d4,ff,e1,37,0-2,ff-2,f5,d6,b7,ad,b2,c8,f6,ff,ed,65,0-8,55,ff-2,55,0-8,13,a3,ff,fd,cb,b1,b2,cb,fd,ff,a5,14,0-7,28,ff-4,2a,0-7,64,ff-2,ce,0-4,cc,ff-2,65,0-3,3a,f7,ff,ca,21,0-4,1,50,ff-2,b9,19,0-6,55,ff-2,55,0-8,ed,ff,fe,cd,aa-9,39,0-6,ff-2,aa,0-f,e,af,ff,e4,9,0-a,aa,ff-2,0-28,55,ff-2,55,0-e,5a,bc,ea,f8,ff-2,fc,99,2,0-5,ff-2,aa,0-7,5d,f6,ff,a1,0-2,3a,90,c8,e1,f6,fd,f9,ef,d3,a9,2d,0-9,55,ff-2,55,0-9,3,78,c7,ed,fa-2,ed,c7,7a,3,0-9,d3,ff-2,d5,0-8,47,f1,ff,8d,0-4,8b,ff,f2,48,0-2,1b,c1,ff,fa,45,0-7,a1,fd,fc,86,0-6,55,ff-2,55,0-8,ff-d,55,0-6,ff-2,aa,0-10,3e,fd,ff,6d,1,0-9,aa,ff-2,0-28,1c,55-2,1c,0-e,2,17,40,4e,7e,ed,fd,c2,13,0-5,55-2,39,0-7,13,4c,55,48,0-3,1,1e,37,4c,53,4f,45,29,9,0-a,1c,55-2,1c,0-a,3,1e,43,50-2,43,1e,3,0-a,3b,55-2,3c,0-8,15,4d,55,26,0-4,25,55,4e,15,0-2,14,4d,55,50,3,0-7,1f,53,55,43,0-6,1c,55-2,1c,0-8,55-d,1c,0-6,ff-2,aa,0-10,5,cf,ff,bd,18,0-9,aa,ff-2,0-3e,1,53,f0,ff,c5,2f,0-98,ff-2,aa,0-11,5c,f6,f7,60,0-9,aa,ff-2,0-3f,2,74,f1,ec,55,0-98,ff-2,e3,aa-3,0-e,20,ca,ff,bf,0-6,aa-3,e3,ff-2,0-40,3,56,2e,0-99,ff-6,0-18,ff-6,0-dc,55-6,0-18,55-6,0-16,aa-d,39,0-f2,ff-d,55,0-f2,55-d,1c,0-638,7,27,46,51,4d,3a,10,0-39,16,37,4b,52,49,34,b,0-77,2,17,40,4e-2,40,17,2,0-1a,42,aa-3,b,0-7,aa-6,9e,86,47,b,0-9,1a,9e,d1,f0,fb,f7,e4,b1,51,0-4,aa-4,a0,90,65,2c,0-8,39,aa-b,71,0-3,39,aa-b,0-6,7,57,c0,e1,f5,fc,f3,de,aa,4c,0-4,aa-2,71,0-7,aa-2,71,0-3,39,aa-a,39,0-7,71,aa-6,71,0-5,aa-2,71,0-7,4d,a7,aa,6e,0-2,39,aa-2,39,0-b,71,aa-2,9c,2b,0-5,56,aa-3,39,0-2,aa-3,65,0-6,aa-2,71,0-5,5c,bd,ea,f8-2,ea,bc,5a,0-a,17,38,4e,53,47,2e,3,0-9,aa,ff-3,57,0-7,ff-9,e1,4b,6,0-6,52,e1,ff,ed,bf,af,b8,d5,fd,ff,0-4,ff-8,ba,4d,1,0-5,55,ff-b,aa,0-3,55,ff-b,0-5,14,b2,fd,f9,d7,b4,ae,bd,dd,ff-2,0-4,ff-2,aa,0-7,ff-2,aa,0-3,55,ff-a,55,0-7,aa,ff-6,aa,0-5,ff-2,aa,0-5,4,4c,f7,ff,ae,1d,0-2,55,ff-2,55,0-b,aa,ff-3,76,0-4,11,ba,ff-3,55,0-2,ff-3,e9,c,0-5,ff-2,aa,0-3,9,78,ff-2,d2,b3,b4,d3,ff-2,76,9,0-6,a,5c,c1,e2,f8,fd,f1,d8,82,16,0-7,5,eb,ff-3,9b,3,0-6,ff-2,c6,55-3,62,8a,ed,ff,df,3e,0-5,1c,e1,ff,d1,54,15,5,e,2b,8c,ef,0-4,ff-2,c6,55,5f,74,b4,f2,ff,e8,52,1,0-4,55,ff-2,8e,55-8,39,0-3,55,ff-2,8e,55-8,0-4,a,8d,fe-2,81,2e,a,4,13,33,99,f3,0-4,ff-2,aa,0-7,ff-2,aa,0-3,1c,55-3,8e,ff-2,8e,55-3,1c,0-7,39,55-4,ff-2,aa,0-5,ff-2,aa,0-5,45,dc,ff,d1,20,0-3,55,ff-2,55,0-b,aa,ff-2,fb,bf,0-4,36,e0,fb,ff-2,55,0-2,ff-4,53,0-5,ff-2,aa,0-3,41,e6,ff,b4,28,9,a,29,b4,ff,e5,3f,0-5,1e,be,fe,f5,d1,b4,ae,c2,ed,ff,c6,12,0-6,4a,ff-2,fd,ff,d0,26,0-6,ff-2,aa,0-5,39,df,ff,b6,0-4,d,a5,ff,ea,21,0-6,41,0-4,ff-2,aa,0-4,1e,c1,fd,e1,40,0-4,55,ff-2,55,0-c,55,ff-2,55,0-c,5d,f3,f8,7e,0-6,1,45,0-4,ff-2,aa,0-7,ff-2,aa,0-7,55,ff-2,55,0-10,ff-2,aa,0-5,ff-2,aa,0-3,2,3e,f0,ff,bc,25,0-4,55,ff-2,55,0-b,aa,ff-2,b7,fd,1e,0-3,74,fe,b7,ff-2,55,0-2,ff-2,fb-2,b7,11,0-4,ff-2,aa,0-3,b6,ff,cf,25,0-4,25,cf,ff,b3,0-4,17,a7,ff,e9,60,27,a,4,18,50,ec,ff,77,1,0-4,1,90,ff-2,bf,ff,f2,4b,0-6,ff-2,aa,0-5,c,b6,ff,ea,0-4,38,e2,ff,8b,0-c,ff-2,aa,0-5,37,d9,fe,a0,0-4,55,ff-2,55,0-c,55,ff-2,55,0-c,bc,ff,cc,22,0-c,ff-2,aa,0-7,ff-2,aa,0-7,55,ff-2,55,0-10,ff-2,aa,0-5,ff-2,aa,0-3,38,d2,ff,de,29,0-5,55,ff-2,55,0-b,aa,ff-2,6f,fe,66,0-3,be,fc,70,ff-2,55,0-2,ff-2,dc-2,e7,3e,0-4,ff-2,aa,0-2,d,f5,ff,94,4,0-4,4,95,ff,f4,c,0-3,8b,fd,c8,2c,0-6,55,f0,d0,26,0-4,20,ca,ff,de,46,ef,ff,97,0-6,ff-2,aa,0-5,5,af,ff,f8,0-4,7b,ff,e8,3e,0-c,ff-2,aa,0-5,1,8e,ff,f9,15,0-3,55,ff-2,55,0-c,55,ff-2,55,0-b,22,ff-2,84,0-d,ff-2,aa,0-7,ff-2,aa,0-7,55,ff-2,55,0-10,ff-2,aa,0-5,ff-2,aa,0,1,32,e7,ff,c8,2f,0-6,55,ff-2,55,0-b,aa,ff-2,33,dd,b5,d,0,1d,fd,bc,55,ff-2,55,0-2,ff-2,ae,96,ff,9b,0-4,ff-2,aa,0-2,4b,ff-2,53,0-6,54,ff-2,4a,0-2,1b,f0,fe,42,1,0-6,1d,c7,ec,42,0-4,44,ed,ff,98,22,cc,ff,dd,0-6,ff-2,aa,0-5,19,c3,ff,d9,0-4,ad,ff,ce,24,0-c,ff-2,aa,0-6,53,ff-2,48,0-3,55,ff-2,55,0-c,55,ff-2,55,0-b,55,ff-2,4c,0-d,ff-2,aa,0-7,ff-2,aa,0-7,55,ff-2,55,0-10,ff-2,aa,0-5,ff-2,aa,0,2d,c6,ff,e8,33,1,0-6,55,ff-2,55,0-b,aa,ff-2,f,b7,db,31,0,66,fe,73,55,ff-2,55,0-2,ff-2,aa,3d,ff,ec,c,0-3,ff-2,aa,0-2,6f,ff-2,2f,0-6,30,ff-2,6e,0,2,81,ff,a2,0-3,15,88,dc,f5,c8,48,b3,fb,51,0-4,8b,ff,f3,4c,2,93,ff-2,37,0-5,ff-2,aa,0-3,7,1e,8a,f8,f6,72,0-4,dd,ff,b9,f,0-c,ff-2,aa,0-6,24,ff-2,7d,0-3,55,ff-2,55,0-c,55,ff-2,55,0-b,87,ff-2,20,0-d,ff-2,aa,0-7,ff-2,aa,0-7,55,ff-2,55,0-10,ff-2,aa,0-5,ff-2,aa,27,db,ff,d4,39,0-8,55,ff-2,55,0-b,aa,ff-2,0,6b,fd,6b,e,b5,e0,36,55,ff-2,55,0-2,ff-2,aa,0,c7,ff,6d,1,0-2,ff-2,aa,0-2,92,ff-2,14,0-6,15,ff-2,91,0,12,ba,f4,54,0-2,11,97,fe,ff-3,d9,df,ff,55,0-4,d2,ff,d1,27,0,4d,ff-2,7e,0-5,ff-2,e3,aa-3,b1,c8,f9-2,88,14,0-4,ee,ff,b0,6,0-c,ff-2,aa,0-6,f,ff-2,93,0-3,55,ff-2,c6,aa-8,0-4,55,ff-2,c6,aa-7,39,0-3,98,ff-2,d,0-d,ff-2,e3,aa-7,ff-2,aa,0-7,55,ff-2,55,0-10,ff-2,aa,0-5,ff-2,cd,b9,ff-2,a5,9,0-8,55,ff-2,55,0-b,aa,ff-2,0,22,fe,b3,31,db,bb,11,55,ff-2,55,0-2,ff-2,aa,0,6d,fc,b8,13,0-2,ff-2,aa,0-2,9d,ff-2,8,0-6,a,ff-2,9c,0,30,da,d3,29,0-2,6b,fa,da,58,9,26,bb,fd,ff,55,0-3,2b,ff-2,9c,4,0,7,ed,ff,c0,16,0-4,ff-8,ef,93,29,3,0-4,fb,ff,ac,2,0-c,ff-2,aa,0-6,2,ff-2,a3,0-3,55,ff-b,0-4,55,ff-a,55,0-3,a6,ff-2,3,0-4,39,55-4,39,0-3,ff-c,aa,0-7,55,ff-2,55,0-10,ff-2,aa,0-5,ff-4,fc,ff,f0,5e,0-8,55,ff-2,55,0-b,aa,ff-2,0-2,c4,fa,82,fd,70,0,55,ff-2,55,0-2,ff-2,aa,0,25,cf,f1,4f,0-2,ff-2,aa,0-2,a7,ff-2,2,0-6,2,ff-2,a6,0,43,ed,be,14,0-2,ba,ff,6b,3,0-2,3a,de,ff,55,0-3,73,ff-2,59,0-3,ad,ff,e4,3a,0-4,ff-2,c6,55-3,63,88,e5,ff,cc,42,0-4,f5,ff,ae,4,0-c,ff-2,aa,0-6,3,ff-2,a3,0-3,55,ff-2,8e,55-8,0-4,55,ff-2,8e,55-7,1c,0-3,9f,ff-2,8,0-4,aa,ff-4,aa,0-3,ff-2,c6,55-7,ff-2,aa,0-7,55,ff-2,55,0-10,ff-2,aa,0-5,ff-3,f4,8c,f0,ff,d9,10,0-7,55,ff-2,55,0-b,aa,ff-2,0-2,7a,ff,eb,ff,27,0,55,ff-2,55,0-2,ff-2,aa,0,5,92,ff,9e,0-2,ff-2,aa,0-2,a2,ff-2,5,0-6,6,ff-2,a1,0,4d,f7,b1,7,0-2,f1,ff,13,0-3,a,b4,ff,55,0-2,11,ba,ff,f3,c,0-3,5a,f9,ff,77,0-4,ff-2,aa,0-5,1b,b5,ff,e6,13,0-3,e3,ff,b6,c,0-c,ff-2,aa,0-6,e,ff-2,93,0-3,55,ff-2,55,0-c,55,ff-2,55,0-b,8d,ff-2,17,0-4,71,aa-2,ff-2,aa,0-3,ff-2,aa,0-7,ff-2,aa,0-7,55,ff-2,55,0-10,ff-2,aa,0-5,ff-2,e4,4d,7,88,ff-2,9d,d,0-6,55,ff-2,55,0-b,aa,ff-2,0-2,39,e3,ff,ca,0-2,55,ff-2,55,0-2,ff-2,aa,0-2,27,fa,f8,1b,0,ff-2,aa,0-2,96,ff-2,f,0-6,10,ff-2,94,0,53,fd,ac,2,0-2,fa,ff,5,0-3,3,ad,ff,55,0-2,34,de,ff,f3,aa-4,c0,f9,ff,be,0-4,ff-2,aa,0-6,4a,ff-2,5e,0-3,c5,ff,c4,1a,0-c,ff-2,aa,0-6,24,ff-2,7e,0-3,55,ff-2,55,0-c,55,ff-2,55,0-b,6d,ff-2,34,0-7,ff-2,aa,0-3,ff-2,aa,0-7,ff-2,aa,0-7,55,ff-2,55,0-10,ff-2,aa,0-5,ff-2,b0,6,0,16,dd,ff,ee,57,0-6,55,ff-2,55,0-b,aa,ff-2,0-2,15,bf,ff,80,0-2,55,ff-2,55,0-2,ff-2,aa,0-2,1,c3,ff,71,0,ff-2,aa,0-2,80,ff-2,23,0-6,23,ff-2,7e,0,4d,f7,b2,8,0-2,e1,ff,2b,0-3,16,c0,ff,55,0-2,6d,fe,ff-9,fc,1a,0-3,ff-2,aa,0-6,c,ff-2,9a,0-3,8c,ff,e0,36,0-c,ff-2,aa,0-6,52,ff-2,49,0-3,55,ff-2,55,0-c,55,ff-2,55,0-b,33,ff-2,6a,0-7,ff-2,aa,0-3,ff-2,aa,0-7,ff-2,aa,0-7,55,ff-2,55,0-f,9,ff-2,9e,0-5,ff-2,aa,0-3,49,e8,ff,e8,1e,0-5,55,ff-2,55,0-b,aa,ff-2,0-8,55,ff-2,55,0-2,ff-2,aa,0-3,58,f6,c8,1e,ff-2,aa,0-2,56,ff-2,48,0-6,48,ff-2,53,0,45,ef,bb,11,0-2,aa,ff,88,6,0-2,4d,eb,ff,55,0-2,b3,ff,e5,73,55-5,91,ff-2,5e,0-3,ff-2,aa,0-6,8,ff-2,a3,0-3,54,f5,fa,61,0-c,ff-2,aa,0-5,1,8d,ff,f9,16,0-3,55,ff-2,55,0-c,55,ff-2,55,0-b,8,e4,ff,a7,8,0-6,ff-2,aa,0-3,ff-2,aa,0-7,ff-2,aa,0-7,55,ff-2,55,0-f,1c,ff-2,8e,0-5,ff-2,aa,0-3,a,8e,ff-2,96,b,0-4,55,ff-2,55,0-b,aa,ff-2,0-8,55,ff-2,55,0-2,ff-2,aa,0-3,23,cd,f3,51,ff-2,aa,0-2,25,ff-2,77,0-6,78,ff-2,22,0,30,da,d6,2c,0-2,41,e6,f7,aa,5d,7b,eb,fb,ff,55,0,13,f9,ff,b1,d,0-5,19,f9,ff,ad,9,0-2,ff-2,aa,0-6,38,ff-2,87,0-3,1a,be,ff,d5,11,0-6,20,0-4,ff-2,aa,0-5,37,da,ff,a2,0-4,55,ff-2,55,0-c,55,ff-2,55,0-c,7c,fa,e9,50,0-6,ff-2,aa,0-3,ff-2,aa,0-7,ff-2,aa,0-7,55,ff-2,55,0-7,71,21,0-6,54,ff-2,5e,0-5,ff-2,aa,0-4,8,cd,ff,f5,6d,0-4,55,ff-2,55,0-b,aa,ff-2,0-8,55,ff-2,55,0-2,ff-2,aa,0-4,7b,ff,b9,ff-2,aa,0-3,cd,ff,c2,18,0-4,18,c1,ff,c9,0-2,16,c0,f2,4c,0-2,9,6d,fc,ff-3,c4,cd,ff,55,0,54,ff-2,77,0-7,cc,ff,d4,2a,0-2,ff-2,aa,0-5,10,9e,ff-2,47,0-3,1,57,ff-2,8c,11,0-4,37,ba,0-4,ff-2,aa,0-4,1d,c1,fd,e2,42,0-4,55,ff-2,55,0-c,55,ff-2,55,0-c,25,cd,ff,d0,23,0-4,5,ff-2,aa,0-3,ff-2,aa,0-7,ff-2,aa,0-7,55,ff-2,55,0-7,aa,be,41,0-4,10,a8,ff,fd,21,0-5,ff-2,aa,0-5,51,ea,ff,e4,1a,0-3,55,ff-2,55,0-b,aa,ff-2,0-8,55,ff-2,55,0-2,ff-2,aa,0-4,22,fb,f7,ff-2,aa,0-3,6f,fa,f3,70,0-4,6f,f3,f9,6a,0-3,80,ff,b1,1,0-3,35,88,a0,76,d,71,aa,39,6,a5,ff,fc,21,0-7,75,fd,f9,5c,0-2,ff-2,c6,55-3,60,7e,d6,ff,fa,a8,0-6,86,f2,ff,da,7e,5f,6f,a9,fb,ff,0-4,ff-2,c6,55,5f,73,b3,f2,ff,e9,54,1,0-4,55,ff-2,8e,55-8,39,0-3,55,ff-2,55,0-d,2e,dc,ff,ee,a3,65,5b,80,d1,ff-2,92,0-3,ff-2,aa,0-7,ff-2,aa,0-3,1c,55-3,8e,ff-2,8e,55-3,1c,0-3,aa,ff,fe,b7,76,5a,6d,c8,fd,fb,9a,0-6,ff-2,aa,0-5,3,77,"
"ff-2,ad,13,0-2,55,ff-2,8e,55-8,39,0-2,aa,ff-2,0-8,55,ff-2,55,0-2,ff-2,aa,0-5,a9,ff-3,aa,0-3,14,a2,ff-2,a5,67-2,a5,ff-2,9e,12,0-3,23,fb,f6,3d,0-b,24,ce,ff,d5,1,0-7,41,ea,ff,9e,0-2,ff-9,fb,8f,1e,0-6,10,67,ef,ff-5,f6,a6,0-4,ff-8,bc,4f,1,0-5,55,ff-b,aa,0-3,55,ff-2,55,0-e,3c,b3,ff-6,f3,9f,20,0-3,ff-2,aa,0-7,ff-2,aa,0-3,55,ff-a,55,0-3,52,d7,fe,ff-6,a5,20,0-6,ff-2,aa,0-6,f,d0,ff,f3,67,0-2,55,ff-b,aa,0-2,aa,ff-2,0-8,55,ff-2,55,0-2,ff-2,aa,0-5,57,f4,ff-2,aa,0-4,1c,b2,fb,ff-4,fa,ae,1a,0-5,86,f8,d6,40,0-a,30,a1,aa,60,0-8,14,85,aa,99,0-2,aa-6,a0,8e,5c,1c,0-a,11,52,8e,a2,9a,74,20,0-5,aa-4,a1,91,67,2d,0-8,39,aa-b,71,0-3,39,aa-2,39,0-10,32,73,98,a4,8f,65,19,0-5,aa-2,71,0-7,aa-2,71,0-3,39,aa-a,39,0-4,3,2c,73,96,a6,9c,75,35,0-8,aa-2,71,0-7,36,a2,aa,9d,6,0,39,aa-b,71,0-2,71,aa-2,0-8,39,aa-2,39,0-2,aa-2,71,0-5,16,88,aa-2,71,0-5,4,30,82,9d,9c,80,2e,3,0-6,1e,be,fe,d8,4c,5,0-fb,14,ba,f8,fc,d6,86,67,5c,7c,b2,32,0-f6,1b,75,ec,ff-5,f9,56,0-f8,c,45,84,9e,a6,91,4f,e,0-9f6,c,4f,b6,e6,f6,df,8e,38,0-6,2,e,23,33,48,53,55-2,0-8,1c,48,8f,c2,ec,fa,f1,d6,94,4c,8,0-5,22,7b,af,d1,ef,fb,f0,d0,83,36,0-c,17,4f,55-2,0-6,1c,55-a,1c,0-6,1,1b,72,ba,e9,f9,ee,cf,90,25,0-4,55-c,39,0-5,1e,6d,c8,ed,f9,e7,a7,56,7,0-7,2f,82,d3,f2,f4,db,8c,3b,1,0-56,d,48,87,cb,ec,fa,ee,b8,69,11,0-7,83,ed,ff-4,fe,dc,3c,0-5,3b,b8,cd,dd,f2,fd,ff-2,0-8,c6,f0,ff-7,ee,87,12,0-4,55,ff-7,fd,dd,4d,1,0-a,80,f9,ff-2,0-6,55,ff-a,55,0-6,33,b9,fd,ff-6,55,0-4,ff-c,a7,0-4,12,c0,f9,ff-5,f2,79,9,0-5,34,d7,fc,ff-4,fe,df,49,0-56,7e,ed,ff-6,fa,96,14,0-4,1,5e,ff-2,a1,2f,d,46,d7,ff,d7,2f,0-4,53,f1,dd,cd,b8,e5,ff-2,0-8,ff,eb,ae,6d,27,c,e,37,aa,f4,fe,a8,3,0-3,4f,d4,90,4f,18,6,16,54,d6,ff,e7,48,0-9,34,f9,ff-3,0-6,55,ff-2,c6,aa-7,39,0-5,21,e3,ff,e3,86,26,9,19,50,bd,4b,0-4,aa-8,ab,e2,ff-2,5c,0-3,c,a6,ff,fb,81,21,8,31,bf,fd,f6,64,0-4,27,d1,ff,eb,6b,1c,9,33,b7,f9,e1,3e,0-55,aa,ea,aa,49,16,2,1d,9a,f4,fd,81,0-4,1a,c0,ff,d6,13,0-3,53,eb,fc,86,0-4,1a,47,33,23,e,ac,ff-2,0-8,b2,4c,d,0-5,13,a2,ff,f9,35,0-3,16,2a,1,0-5,4d,e6,ff,a2,0-8,12,aa,e8-2,ff-2,0-6,55,ff-2,55,0-c,7,92,ff,fb,51,6,0-4,17,13,0-c,18,c0,ff,f1,11,0-3,34,de,ff,bc,6,0-3,3a,dd,ff,bc,0-4,71,fb,f9,77,0-4,21,c3,fe,9b,0-55,84,48,d,0-4,1a,c4,ff,d5,0-4,52,f5,fa,63,0-4,a,aa,ff,ea,6,0-8,aa,ff-2,0-11,29,ff-2,8a,0-b,d,b7,ff,ea,0-8,75,f9,86,ae,ff-2,0-6,55,ff-2,55,0-c,3a,e4,fe,92,0-14,54,f3,ff,94,0-4,4f,f9,ff,68,0-4,a,b4,ff,f3,0-4,c3,ff,ce,24,0-5,55,ff,f5,d,0-5b,8,b2,ff,f7,0-4,87,ff,e3,39,0-5,72,ff-2,31,0-8,aa,ff-2,0-11,8,ff-2,a4,1,0-a,4,ae,ff,f9,0-7,18,e6,eb,19,aa,ff-2,0-6,55,ff-2,55,0-c,6e,fc,ed,47,0-14,a1,ff,ef,4b,0-4,51,fb,ff,5a,0-4,3,ad,ff,f7,0-4,e9,ff,b6,c,0-5,1c,ff-2,3d,0-2e,6,5b,2e,0-11,5b,31,3,0-16,30,d9,ff,e2,0-4,bb,ff,c7,1d,0-5,3b,ff-2,65,0-8,aa,ff-2,0-11,23,ff-2,af,5,0-a,1c,c6,ff,d4,0-6,e,a4,f5,67,0,aa,ff-2,0-6,55,ff-2,55,0-c,ac,ff,ca,20,f,38,51,4f,39,13,0-d,18,f8,ff,b8,13,0-4,38,e2,ff,7d,0-4,15,bf,ff,c5,0-4,fa,ff,ac,2,0-5,5,ff-2,70,0-7,55,ff-3,0-c,55,ff-3,0-10,f,3a,90,e4,ff,55,0-11,aa,fc,d0,67,2f,3,0-12,1d,ca,ff,fa,80,0-4,dc,ff,ba,10,0-5,21,ff-2,86,0-8,aa,ff-2,0-11,6a,ff-2,96,1,0-a,77,f4,fc,80,0-6,53,ee,be,18,0,aa,ff-2,0-6,55,ff-2,98,91,a5,9b,7f,38,6,0-6,d3,ff,b8,1f,a8,e2,fb,f9,e3,b9,34,0-c,6a,ff-2,72,1,0-4,f,a9,ff,d4,b,0-3,4b,ea,f7,6a,0-4,f3,ff,af,5,0-5,d,ff-2,8b,0-7,55,ff-3,0-c,55,ff-3,0-e,d,53,b5,e4,ff-2,f5,4b,0-11,97,ff-2,fa,d9,93,3c,0-10,1f,ad,ff-2,c3,22,0-4,f0,ff,af,5,6,33,4c,21,0,b,ff-2,9a,0-8,aa,ff-2,0-10,30,d5,ff,fc,3c,0-6,39,55,57,74,b9,ff,f3,8c,12,0-5,14,df,f7,37,0-2,aa,ff-2,0-6,55,ff-7,fe,d2,3e,5,0-4,ed,ff,c8,c0,e8,bc,ae,be,f2,ff,e7,4f,0-a,17,c1,ff,f1,11,0-6,13,bb,f6,ce,75,5c,85,f2,ed,78,a,0-4,d1,ff,c5,1b,0-5,42,ff-2,9f,0-7,55,ff-3,0-c,55,ff-3,0-b,e,43,89,eb,ff-2,ef,bb,79,18,0-2,aa,ff-d,55,0-2,39,8d,d2,f7,ff-2,cb,73,2b,7,0-b,15,ca,ff,fd,ca,18,0-5,f9,ff,ac,2,37,d5,f6,bb,0,4,ff-2,a4,0-8,aa,ff-2,0-f,3,ae,fc,ff,bb,4,0-6,aa,ff-4,dc,64,c,0-5,4,7f,ff,a6,1,0-2,aa,ff-2,0-6,4d,c7,8b,6b,5a,5d,81,c7,ff-2,db,45,0-4,f8,ff,f7,df,44,12,4,14,6e,eb,ff,cc,1,0-9,45,ed,ff,aa,0-8,1d,89,fc,ff-3,df,66,6,0-5,99,ff,e9,42,0-4,7,95,ff-2,a7,0-7,55,ff-3,0-c,55,ff-3,0-9,8,62,ae,e9,fe,ff,ef,92,4b,14,1,0-3,aa,ff-d,55,0-3,2,28,59,bc,f7,ff,fd,d5,9e,36,4,0-8,4,85,ff-2,c7,31,0-6,fa,ff,ac,2,38,d8,f7,bc,0,4,ff-2,a4,0-8,aa,ff-2,0-e,10,8f,ff-2,ce,2c,0-7,71,aa,ab,b7,d3,fd,f1,79,15,0-4,4d,e9,d4,2c,0-3,aa,ff-2,0-e,68,e8,ff,de,d,0-3,fd,ff,f1,54,0-4,2,84,ff-2,45,0-9,a2,ff,f0,4a,0-6,2,35,c9,fd,d8,b6,ad,bc,ee,fa,90,1f,0-4,3d,e6,ff,d2,34,d,4,19,81,e3,ff-2,a3,0-22,30,96,e8,ff-2,e0,b2,54,e,0-1d,1a,7c,bd,f1,ff,fd,d6,6d,18,0-6,2e,d8,ff,de,18,0-7,f0,ff,af,5,7,35,4d,21,0,b,ff-2,9a,0-8,aa,ff-2,0-e,82,f2,ff,f6,45,2,0-9,1,d,29,8d,f3,f6,98,0-3,3,c2,ff,76,4,0-3,aa,ff-2,0-e,8,8b,ff-2,4c,0-3,f6,ff,cb,21,0-5,38,ff-2,7c,0-8,d,ee,ff,c6,1c,0-6,2d,cd,ff,bd,2e,c,3,12,5d,e0,fa,ab,1,0-3,a,83,ff-2,dd,b7,ae,c3,f4,8e,ff-2,96,0-22,a2,ff-2,d6,81,36,d,0-20,1,16,4e,95,f1,ff,fb,51,0-6,47,f1,ff,7f,0-8,dc,ff,ba,10,0-5,20,ff-2,86,0-8,aa,ff-2,0-c,d,7c,ff-2,e3,52,0-e,3,7a,ff-2,44,0-2,70,ff,cd,5,0-4,aa,ff-2,0-f,25,ff-2,90,0-3,e1,ff,b0,6,0-5,b,ff-2,9e,0-8,6a,ff-2,73,0-7,a0,ff,d8,2e,0-5,5f,ff-2,4b,0-5,6e,c6,ef,fb,f6,da,6d,27,ff-2,7e,0-22,a2,ff-2,cd,79,31,b,0-20,1,13,48,8c,eb,ff,fb,51,0-6,53,fd,ff,57,0-8,bc,ff,c7,1d,0-5,3b,ff-2,66,0-8,aa,ff-2,0-c,79,f0,ff,f8,56,6,0-f,20,ff-2,8b,0-2,a9,ff,da,aa-5,e3,ff-2,aa-2,71,0-c,7,ff-2,a3,0-3,c7,ff,ac,2,0-5,4,ff-2,a5,0-7,10,b3,ff,fb,1e,0-7,e0,ff,b6,c,0-5,19,ff-2,8c,0-5,3,1e,45,51,4c,30,3,41,ff-2,56,0-22,30,97,e8,ff,fe,db,ad,4e,c,0-7,71,aa-d,39,0-7,17,76,b9,ed,ff,fd,d6,6e,18,0-6,55,ff-2,55,0-8,88,ff,e3,39,0-5,72,ff-2,31,0-8,aa,ff-2,0-a,d,79,ff-2,d9,4e,0-11,9,ff-2,a3,0-2,aa,ff-c,aa,0-c,18,ff-2,95,0-3,94,ff,b8,e,0-5,18,ff-2,92,0-7,47,ec,ff,ab,0-8,fa,ff,ad,3,0-5,7,ff-2,a4,0-b,2,89,ff,f9,1c,0-24,8,62,af,ea,fe,ff,ec,8e,4a,14,1,0-3,aa,ff-d,55,0-3,2,27,57,b8,f5,ff,fd,d5,9f,37,4,0-8,39,aa-2,39,0-8,52,f5,fa,63,0-4,a,aa,ff,ea,6,0-8,aa,ff-2,0-a,7a,f0,ff,e3,3d,4,0-11,2f,ff-2,90,0-2,39,55-7,c6,ff-2,55-2,39,0-c,54,ff-2,6c,0-3,5f,fb,d4,2a,0-5,48,ff-2,6d,0-7,8d,fe,f7,5a,0-8,eb,ff,bc,12,0-5,24,ff-2,95,0-b,20,c8,ff,c7,0-27,e,43,89,ec,ff-2,ee,ba,79,18,0-2,39,55-d,1c,0-2,3a,8d,d1,f6,ff-2,cb,73,2b,7,0-16,1b,c0,ff,d6,13,0-3,53,eb,fc,86,0-9,aa,ff-2,0-8,e,7c,ff,fe,ae,26,0-a,36,b,0-6,1b,af,ff,fd,42,0-a,aa,ff-2,0-6,35,9,0-6,35,cf,ff,ed,18,0-3,25,ce,fd,8d,3,0-3,15,b3,ff,f6,1f,0-6,e,ee,ff,c6,1d,0-8,a7,ff,ee,5d,0-4,c,93,ff-2,50,0-4,25,4,0-4,c,9d,fd,ef,52,0-8,55,ff-3,0-c,55,ff-3,0-e,d,54,b5,e4,ff-2,f6,4c,0-11,98,ff-2,fa,d9,94,3d,0-e,1c,55-2,1c,0-8,1,5f,ff-2,a0,2f,c,45,d7,ff,d7,2f,0-9,aa,ff-2,0-8,7e,f0,fb,a9,1a,0-b,e0,af,62,30,c,4,19,4c,bb,f7,ff,bf,7,0-a,aa,ff-2,0-6,df,ab,5a,29,a,6,23,64,d3,fd,f7,7e,0-4,4,76,ff,f3,7e,23,7,28,a3,f5,ff,a0,0-7,55,ff-2,87,3,0-8,4f,ec,ff,e0,5f,18,6,24,93,ef,ff,d7,d,0-4,97,92,3f,a,c,43,a0,fa,ff,9d,10,0-8,55,ff-3,0-c,55,ff-3,0-10,f,3a,90,e4,ff,55,0-11,aa,fd,d1,68,2f,3,0-f,55,ff-2,55,0-a,84,ed,ff-4,fe,dc,3d,0-6,aa,ff-a,0-4,ff-c,bb,11,0-2,ff-9,f5,9b,1c,0-b,aa,ff-2,0-6,ff-8,fd,e2,67,7,0-6,93,ef,ff-5,f9,9d,19,0-6,f,b5,ff,f9,21,0-9,2,5a,e3,fe,ff-5,fd,b9,2f,0-5,aa,ff-6,ee,9f,5,0-9,55,ff-3,0-c,59,ff-2,f6,0-13,6,5c,2e,0-11,5b,31,3,0-12,55,ff-2,55,0-a,c,4f,b7,e7,f6,e0,8f,38,0-7,aa,ff-a,0-4,ff-c,bb,11,0-2,72,9e,ca,e3,f7,fd,f2,da,9d,57,e,0-c,aa,ff-2,0-6,79,ab,d6,ec,fa,fc,eb,ca,81,3b,2,0-7,e,52,b3,e3,f9,ee,b9,6a,13,0-7,3a,e4,ff,c1,0-b,1,3d,89,d3,f1,fa,ec,b9,73,1d,1,0-5,4a,ae,db,f8,f7,dc,a8,4d,e,0-a,55,ff-3,0-c,7f,ff-2,ab,0-3c,55,ff-2,55,0-bc,c8,ff,e1,38,0-fb,c,f6,ff,9c,9,0-fb,4c,ff,f2,20,0-fc,86,ff,9d,0-890,55,1c,0-fe,ff,55,0-1b,22,7d,9f,a0,83,3e,9,0-1c,13,84,9b,2a,0-8,2a,9c,84,13,0-f,71-2,0-6d,55,ff-2,55,0-a,55,ff,aa,0-2,aa,ff,55,0-a,5b,fb,b3,d,0,f,fa-2,13,0-9,ff,56,0-8,10,3b,51,47,19,1,0-b,1,78,ef,ff-5,55,0-a,55,ff,aa,0-f,74,f9,a6,c,0-8,d,a7,f9,73,0-f,aa-2,0-51,20,ca,ff,bf,0-18,55,ff-2,55,0-a,55,ff,aa,0-2,aa,ff,55,0-a,90,ff,86,0-2,45,ff,d2,0-a,ff,57,0-7,f,a8,e5,fb,f1,b9,3d,0-b,2b,f1,ff,e8,8b,5f,84,ed,55,0-a,55,ff,aa,0-e,c,e1,ff,45,0-a,47,ff,e1,c,0-9,3c,41,0-3,aa-2,0-3,41,3c,0-4c,5c,f6,f7,60,0-18,55,ff-2,55,0-a,55,ff,aa,0-2,aa,ff,55,0-a,d8,ff,3e,0,1,8d,ff,88,0-6,28,74,c7,ee,ff,fb,e1,bf,86,23,0-2,10,a8,fe,df,b2,c7,fe,eb,1a,0-a,87,ff-2,49,0-3,23,21,0-a,55,ff,aa,0-d,3,7e,ff,c8,0-c,cb,ff,7d,3,0-8,b1,f9,97,32,0,aa-2,0,32,97,f9,b1,0-4b,5,cf,ff,bd,18,0-18,55,ff-2,55,0-a,55,ff,aa,0-2,aa,ff,55,0-9,16,fb,f7,c,0,10,b8,f8,55,0-5,2b,d1,fb,ff,fe,ff-5,55,0-2,3b,e5,df,4e,8,1d,c0,ff,70,0-a,a3,ff-2,c,0-f,55,ff,aa,0-d,20,c9,fd,72,0-c,75,fe,c8,1f,0-8,2a,7e,f1,d8,5f,b3-2,5f,d8,f1,7d,29,0-4b,3e,fd,ff,6d,1,0-18,55,ff-2,55,0-a,55,ff,aa,0-2,aa,ff,55,0-9,5a,ff,ba,0-2,34,de,d6,2c,0-4,1a,c2,ff,eb,60,12,ff,59,1a,3c,77,31,0-2,52,fc,b2,8,0-2,65,ff,a2,0-a,8d,ff-2,25,0-f,55,ff,aa,0-d,63,fa,dd,33,0-c,35,df,f9,61,0-a,20,8c,e5,fd-2,e5,8b,20,0-a,55,ff,aa,0-3f,e,af,ff,e4,9,0-19,55,ff-2,55,0-a,55,ff,aa,0-2,aa,ff,55,0-5,57,aa-3,d2,ff,de,aa-2,c0,f9,ed,b4,aa-2,0-2,43,ed,ff,8d,0-2,ff,55,0-6,49,f3,c4,1a,0-2,8e,ff,91,0-a,4c,ff-2,72,0-f,55,ff,aa,0-d,af,ff,bb,11,0-c,13,bd,ff,ac,0-b,e,b5,fd-2,b3,d,0-b,55,ff,aa,0-3f,3d,e6,ff,87,0-1a,55,ff-2,55,0-a,55,ff,aa,0-2,aa,ff,55,0-5,83,ff-e,0-2,52,fc,ff,61,0-2,ff,55,0-6,1c,be,fd,bb,64,8e,fc,f5,36,0-2,1,2e,7b,6f,3,0-4,bc,fe,d5,2d,0-e,55,ff,aa,0-c,c,f6,ff,87,0-e,8a,ff,f5,b,0-8,16,6e,db,d8,e6-2,d8,da,6d,16,0-9,55,ff,aa,0-3f,a5,ff,d7,2d,0-1a,55,ff-2,55,0-a,1c,55,39,0-2,39,55,1c,0-5,2c,55-2,7b,ec,e1,6f,55-2,e2,ff,81,55-3,0-2,45,ef,ff,a1,0-2,ff,55,0-6,1,42,ef,ff-3,f6,89,2,0,17,78,d8,ee,69,4,0-3,1,8f,fd,fb,92,0-e,1c,55,39,0-c,3b,ff-2,5a,0-e,5d,ff-2,38,0-7,50,b6,f4,b2,2f,af-2,2f,b2,f4,b6,4f,0-8,55,ff,aa,0-3e,1a,f2,ff,97,6,0-1a,54,fe-2,54,0-1a,57,f9,b6,e,0,e,fa-2,11,0-5,15,ae,ff-2,a2,56,ff,65,4,0-7,20,77,a3,92,36,3,30,7e,ed,d9,7b,19,0-4,22,a7,ff,fc,ff-2,58,3,0-1b,71,ff-2,2e,0-e,30,ff-2,6f,0-7,a7,ca,45,3,0,aa-2,0,4,45,ca,a6,0-8,55,ff,aa,0-3d,4,8a,ff,f7,24,0-1b,4f,f9-2,4f,0-1a,86,ff,8e,1,0,3e,ff,d6,0-7,2b,d3,ff-2,f8,ff,d6,9e,53,1,0-9,19,7b,d9,ed,7f,30,1,0-4,6,b5,fb,da,82,fd,ff,d3,2f,0-3,7,aa-2,0-15,8e,ff-2,16,0-e,18,ff-2,8d,0-7,1e,21,0-3,aa-2,0-3,21,1e,0-8,55,ff,aa,0-3d,26,cf,ff,b4,0-1c,47,f1-2,47,0-1a,c9,ff,4c,0-2,80,ff,94,0-8,d,59,b0,cc,ff-4,ba,2f,0-5,1,31,81,ee,d8,7a,18,0-6,5,85,ff,ec,28,0,82,f7,ff,c6,e,0-2,3,ff,f4,0-15,a3,ff-2,6,0-e,7,ff-2,a2,0-c,aa-2,0-7,55,ff-d,aa,0-37,79,fd,ec,46,0-1c,41,eb,ea,40,0-19,8,f5,fe,18,0,8,ac,fd,61,0-a,a,22,ff,97,b6,f9,fe,c4,4,0-3,1b,7d,da,ec,7d,2f,3,38,92,a2,6f,19,0-2,27,d0,ff,99,0-2,1a,b9,ff-2,78,4,0,c,ff,e4,0-15,a7,ff-2,2,0-e,3,ff-2,a6,0-c,39-2,0-7,55,ff-d,aa,0-15,39,aa-6,39,0-19,4,da,ff,b9,13,0-1c,38,e2-2,38,0-16,ff-e,83,0-9,ff,55,5,7e,ff-2,5e,0-2,46,ef,d7,77,17,0,2,8c,f7,ff-3,e7,36,0,4b,f5,ff,5f,0-3,1e,e3,ff,ef,5f,0,39,ff,b4,0-15,9c,ff-2,b,0-e,c,ff-2,9b,0-1b,55,ff,aa,0-1b,55,ff-6,55,0-19,5f,ff-2,4b,0-1d,12,4a-2,12,0-16,ff-e,83,0-9,ff,55,0,24,ff-2,94,0-2,29,7c,2e,1,0-2,38,f6,fb,8c,65,c1,fe,b4,17,52,fc,ff,61,0-4,66,f2,ff,de,1a,85,ff,7b,0-15,86,ff-2,1d,0-e,1f,ff-2,86,0-1b,55,ff,aa,0-1b,1c,55-6,1c,0-18,12,b4,ff,db,8,0-39,e,b8,f8,55,0-2,7a,ff,95,1,0-c,ff,55,0,8,ff-2,a2,0-8,92,ff,8b,0-2,1d,c7,f0,46,43,ed,ff,a4,0-4,6,80,ff-2,dd,ec,d9,30,0-15,5c,ff-2,3f,0-e,42,ff-2,5b,0-1b,55,ff,aa,0-3b,55,f2,f9,68,0-3a,2b,d5,df,35,0-2,b5,ff,5c,0-7,26,30,0-4,ff,55,0,2e,ff-2,80,0-8,a3,ff,64,0-2,8,b2,fb,51,23,cd,ff,f0,29,0-4,11,cd,ff-3,7f,7,0-15,2d,ff-2,66,0-e,69,ff-2,2c,0-1b,55,ff,aa,0-d,39,aa-3,0-1c,39,aa-3,0-a,b0,ff,d2,28,0-1e,55,ff-2,55,0-18,53,f7,ba,11,0,a,f5,fc,18,0-7,55,f7,89,3e,13,3,ff,58,2b,b3,ff,f1,24,0-8,78,ff,bd,1b,8,4f,e0,e4,3a,0,5f,fa,ff,d8,5b,16,4,a,29,a3,fe,ff-2,6d,2,0-16,e1,ff,a0,3,0-c,4,a3,ff,df,0-1c,55,ff,aa,0-d,55,ff-3,0-1c,55,ff-3,0-9,32,fe,ff,78,0-1f,55,ff-2,55,0-18,84,ff,8f,1,0,3a,ff,d9,1,0-7,55,ff,fd,e6,bd,aa,ff,c9,d2,fa,f5,7e,0-9,21,f0,fd,c5,b2,df,fe,a4,e,0,8,9a,f9,ff,f0,c0,ae,b4,d3,fe,df,f7,ff,cb,24,0-16,9a,ff,c4,1a,0-c,1c,c6,ff,98,0-1c,55,ff,aa,0-d,55,ff-3,0-1c,55,ff-3,0-8,5,94,ff,f6,1b,0-1f,55,ff-2,55,0-18,cd,ff,48,0-2,84,ff,92,0-8,c,50,ac,ce,ea,f8,ff,f9,e4,c1,4a,3,0-a,44,bf,f4,fb,e4,a5,d,0-3,5,4f,c0,e3,f8,fc,ee,d3,81,18,83,fb,fe,90,0-16,43,ec,ee,48,0-c,4b,f0,ec,43,0-2c,71,ff-2,c8,0-1c,55,ff-3,0-8,39,e1,fe,91,0-20,1c,55-2,1c,0-18,4e,55,e,0-2,35,55,27,0-a,8,24,40,50,ff,89,3a,17,0-c,1,1d,4a,51,3a,f,0-6,16,39,4e,52,44,29,2,0,19,51,55,45,0-16,13,ba,fe,89,0-c,8c,ff,ba,14,0-2c,ab,ff,f5,5f,0-1c,1c,55-3,0-8,83,fd,e7,41,0-51,2,ff,56,0-3d,48,fd,eb,f,0-a,10,ec,fd,4a,0-2c,6,ee,ff,b0,12,0-27,13,ef,ff,9f,8,0-51,1,ff,56,0-3d,6,c8,ff,60,0-a,62,ff,c8,6,0-2c,2f,ff-2,4d,0-28,6a,ff-2,40,0-53,ff,55,0-3e,41,e6,cb,21,0-8,22,cc,e6,41,0-2d,78,ff,bb,0-80,55,1c,0-3e,9,42,4e,15,0-8,15,4e,42,9,0-2d,32,55,2b,0-338";

IGL_INLINE void decompress_verasansmono_atlas(unsigned char* _fontatlas)
{
  std::string s = verasansmono_compressed_atlas; // Make a copy so that we can erase pieces as we parse the atlas
  std::string delim_atlas = ",";
  std::string delim_item = "-";
  size_t atlas_split = 0; // Locations found with delims above
  size_t item_split = 0;
  std::string curr_item; // Current element of the atlas string
  int full_res = 0; // Running sum of the total bytes (256*256*1)

  while ((atlas_split = s.find(delim_atlas)) != std::string::npos) {
    curr_item = s.substr(0, atlas_split);
    if(curr_item.find(delim_item) != std::string::npos)
    {
      item_split = curr_item.find(delim_item);
      unsigned int occurences = (unsigned int)std::stoi(curr_item.substr(item_split+1, curr_item.length()-1), 0, 16);
      for(int i=0; i<occurences;i++)
      {
        _fontatlas[full_res+i] = std::stoi(curr_item.substr(0, item_split), 0, 16);
      }
      full_res += occurences;
    }
    else {
      _fontatlas[full_res] =  std::stoi(curr_item, 0, 16);
      full_res+=1;
    }
    s.erase(0, atlas_split + delim_atlas.length());
  }
  // Catch last value in compressed atlas string
  item_split = s.find(delim_item);
  if(item_split != std::string::npos)
  {
    unsigned int occurences = std::stoi(s.substr(item_split+1, s.length()-1), 0, 16);
    for(int i=0; i<occurences;i++)
    {
      _fontatlas[full_res+i] = std::stoi(s.substr(0, item_split), 0, 16);
    }
    full_res += occurences;
  }
  assert(full_res == 256*256);
};

}

}
