/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.sandbox.search.QueryProfilerBreakdown;
import org.apache.lucene.sandbox.search.QueryProfilerResult;
import org.apache.lucene.sandbox.search.QueryProfilerTimer;
import org.apache.lucene.sandbox.search.QueryProfilerTimingType;
import org.apache.lucene.sandbox.search.QueryProfilerTree;
import org.apache.lucene.sandbox.search.QueryProfilerWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class QueryProfilerIndexSearcher
extends IndexSearcher {
    private final QueryProfilerTree profiler = new QueryProfilerTree();

    public QueryProfilerIndexSearcher(IndexReader reader) {
        super(reader);
    }

    @Override
    public Query rewrite(Query original) throws IOException {
        this.profiler.startRewriteTime();
        try {
            Query query = super.rewrite(original);
            return query;
        }
        finally {
            this.profiler.stopAndAddRewriteTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        Weight weight;
        QueryProfilerBreakdown profile = this.profiler.getProfileBreakdown(query);
        QueryProfilerTimer timer = profile.getTimer(QueryProfilerTimingType.CREATE_WEIGHT);
        timer.start();
        try {
            weight = query.createWeight(this, scoreMode, boost);
        }
        finally {
            timer.stop();
            this.profiler.pollLast();
        }
        return new QueryProfilerWeight(query, weight, profile);
    }

    public long getRewriteTime() {
        return this.profiler.getRewriteTime();
    }

    public List<QueryProfilerResult> getProfileResult() {
        return this.profiler.getTree();
    }
}

