/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.AbstractDocIdSetIterator;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.VectorUtil;

final class IntArrayDocIdSet
extends DocIdSet {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntArrayDocIdSet.class);
    private final int[] docs;
    private final int length;

    IntArrayDocIdSet(int[] docs, int length) {
        if (docs[length] != Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.docs = docs;
        assert (IntArrayDocIdSet.assertArraySorted(docs, length)) : "IntArrayDocIdSet need docs to be sorted" + Arrays.toString(ArrayUtil.copyOfSubArray(docs, 0, length));
        this.length = length;
    }

    private static boolean assertArraySorted(int[] docs, int length) {
        for (int i = 1; i < length; ++i) {
            if (docs[i] >= docs[i - 1]) continue;
            return false;
        }
        return true;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.docs);
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        return new IntArrayDocIdSetIterator(this.docs, this.length);
    }

    static class IntArrayDocIdSetIterator
    extends AbstractDocIdSetIterator {
        private final int[] docs;
        private final int length;
        private int i = 0;

        IntArrayDocIdSetIterator(int[] docs, int length) {
            this.docs = docs;
            this.length = length;
        }

        @Override
        public int nextDoc() throws IOException {
            this.doc = this.docs[this.i++];
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            int bound = 1;
            while (this.i + bound < this.length && this.docs[this.i + bound] < target) {
                bound *= 2;
            }
            this.i = Arrays.binarySearch(this.docs, this.i + bound / 2, Math.min(this.i + bound + 1, this.length), target);
            if (this.i < 0) {
                this.i = -1 - this.i;
            }
            this.doc = this.docs[this.i++];
            return this.doc;
        }

        @Override
        public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
            if (this.doc >= upTo) {
                return;
            }
            int from = this.i - 1;
            int to = VectorUtil.findNextGEQ(this.docs, upTo, from, this.length);
            for (int i = from; i < to; ++i) {
                bitSet.set(this.docs[i] - offset);
            }
            this.doc = this.docs[to];
            this.i = to + 1;
        }

        @Override
        public long cost() {
            return this.length;
        }
    }
}

