/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.rest;

import java.io.IOException;
import java.util.List;
import org.joda.time.Instant;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rule.action.CreateRuleAction;
import org.opensearch.rule.action.CreateRuleRequest;
import org.opensearch.rule.action.CreateRuleResponse;
import org.opensearch.rule.autotagging.FeatureType;
import org.opensearch.rule.autotagging.Rule;
import org.opensearch.transport.client.node.NodeClient;

public class RestCreateRuleAction
extends BaseRestHandler {
    public String getName() {
        return "create_rule";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "_rules/{featureType}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        FeatureType featureType = FeatureType.from((String)request.param("featureType"));
        try (XContentParser parser = request.contentParser();){
            Rule.Builder builder = Rule.Builder.fromXContent((XContentParser)parser, (FeatureType)featureType);
            CreateRuleRequest createRuleRequest = new CreateRuleRequest(builder.updatedAt(Instant.now().toString()).id().build());
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)CreateRuleAction.INSTANCE, (ActionRequest)createRuleRequest, this.createRuleResponse((RestChannel)channel));
            return restChannelConsumer;
        }
    }

    private RestResponseListener<CreateRuleResponse> createRuleResponse(RestChannel channel) {
        return new RestResponseListener<CreateRuleResponse>(this, channel){

            public RestResponse buildResponse(CreateRuleResponse response) throws Exception {
                return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }
}

