/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.rest.handler;

import java.io.IOException;
import java.time.Clock;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.PipelineAggregatorBuilders;
import org.opensearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.histogram.Histogram;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.metrics.Max;
import org.opensearch.search.aggregations.metrics.Min;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.model.ValidationIssueType;
import org.opensearch.timeseries.rest.handler.AggregationPrep;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.client.Client;

public class IntervalCalculation {
    private final Logger logger = LogManager.getLogger(IntervalCalculation.class);
    private static final int BUCKET_CAP = 256;
    private static final int MAX_SPLIT_DEPTH = 10;
    private final AggregationPrep aggregationPrep;
    private final Client client;
    private final SecurityClientUtil clientUtil;
    private final User user;
    private final AnalysisType context;
    private final Clock clock;
    private final Map<String, Object> topEntity;
    private final long endMillis;
    private final Config config;
    private final int lookBackWindows;
    private static final int[] INTERVAL_LADDER = new int[]{1, 2, 5, 10, 15, 30, 60, 120, 240, 480, 720, 1440, 2880, 10080, 43200};

    public IntervalCalculation(Config config, TimeValue requestTimeout, Client client, SecurityClientUtil clientUtil, User user, AnalysisType context, Clock clock, SearchFeatureDao searchFeatureDao, long latestTime, Map<String, Object> topEntity, boolean validate) {
        this.aggregationPrep = new AggregationPrep(searchFeatureDao, requestTimeout, config);
        this.client = client;
        this.clientUtil = clientUtil;
        this.user = user;
        this.context = context;
        this.clock = clock;
        this.topEntity = topEntity;
        this.endMillis = latestTime;
        this.config = config;
        this.lookBackWindows = validate ? config.getHistoryIntervals() : config.getDefaultHistory() * 2;
    }

    public void findInterval(ActionListener<IntervalTimeConfiguration> listener) {
        ActionListener minimumIntervalListener = ActionListener.wrap(minInterval -> {
            this.logger.debug("minimum interval found: {}", minInterval);
            if (minInterval == null) {
                this.logger.debug("Fail to find minimum interval");
                listener.onResponse(null);
            } else {
                this.getBucketAggregates((IntervalTimeConfiguration)minInterval, listener);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.findMedianIntervalAdaptive((ActionListener<IntervalTimeConfiguration>)minimumIntervalListener);
    }

    private void getBucketAggregates(IntervalTimeConfiguration minimumInterval, ActionListener<IntervalTimeConfiguration> listener) throws IOException {
        try {
            LongBounds timeStampBounds = this.aggregationPrep.getTimeRangeBounds(minimumInterval, this.endMillis, this.lookBackWindows);
            SearchRequest searchRequest = this.aggregationPrep.createSearchRequest(minimumInterval, timeStampBounds, this.topEntity, 0);
            ActionListener intervalListener = ActionListener.wrap(interval -> listener.onResponse(interval), exception -> {
                listener.onFailure(exception);
                this.logger.error("Failed to get interval recommendation", (Throwable)exception);
            });
            IntervalRecommendationListener searchResponseListener = new IntervalRecommendationListener((ActionListener<IntervalTimeConfiguration>)intervalListener, minimumInterval, this.clock.millis() + 10000L, timeStampBounds);
            this.logger.debug("Interval explore search request: {}", (Object)searchRequest);
            this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, this.context, searchResponseListener);
        }
        catch (ValidationException ex) {
            listener.onFailure((Exception)ex);
        }
    }

    public void findMedianIntervalAdaptive(ActionListener<IntervalTimeConfiguration> listener) {
        long MIN_BUCKET_WIDTH_MINS = 1L;
        String TS_FIELD = this.config.getTimeField();
        BoolQueryBuilder baseFilter = QueryBuilders.boolQuery().filter(this.config.getFilterQuery());
        if (this.topEntity != null && !this.topEntity.isEmpty()) {
            Entity e2 = Entity.createEntityByReordering(this.topEntity);
            for (TermQueryBuilder tq : e2.getTermQueryForCustomerIndex()) {
                baseFilter.filter((QueryBuilder)tq);
            }
        }
        SearchSourceBuilder boundsSrc = new SearchSourceBuilder().size(0).trackTotalHits(true).query((QueryBuilder)baseFilter).aggregation((AggregationBuilder)AggregationBuilders.min((String)"min_ts").field(TS_FIELD)).aggregation((AggregationBuilder)AggregationBuilders.max((String)"max_ts").field(TS_FIELD));
        SearchRequest boundsReq = new SearchRequest(this.config.getIndices().toArray(new String[0])).source(boundsSrc);
        this.logger.debug("Min and max timestamp request: {}", (Object)boundsReq);
        ActionListener boundsRequestListener = ActionListener.wrap(r -> {
            long totalDocs;
            this.logger.debug("Min and max timestamp response: {}", r);
            if (r.getTotalShards() == 0 || r.getSuccessfulShards() == 0) {
                String errorMsg = String.format(Locale.ROOT, "No accessible shards found for indices %s This could indicate: not enough data in index, connectivity issues, or permission problems.", Arrays.toString(this.config.getIndices().toArray()));
                this.logger.error(errorMsg);
                listener.onFailure((Exception)new ValidationException(errorMsg, ValidationIssueType.INDICES, ValidationAspect.MODEL));
                return;
            }
            Min minAgg = (Min)r.getAggregations().get("min_ts");
            Max maxAgg = (Max)r.getAggregations().get("max_ts");
            if (minAgg == null || maxAgg == null || Double.isInfinite(minAgg.getValue()) || Double.isInfinite(maxAgg.getValue()) || Double.isNaN(minAgg.getValue()) || Double.isNaN(maxAgg.getValue()) || minAgg.getValue() == maxAgg.getValue()) {
                listener.onResponse(null);
                return;
            }
            long l = totalDocs = r.getHits().getTotalHits() == null ? 0L : r.getHits().getTotalHits().value();
            if (totalDocs < 2L) {
                this.logger.debug("Exit early due to few docs");
                listener.onResponse(null);
                return;
            }
            long minMs = (long)minAgg.getValue();
            long maxMs = (long)maxAgg.getValue();
            long rangeMs = maxMs - minMs;
            long naiveIntervalMs = rangeMs / totalDocs;
            long initBucketMins = Math.max(1L, this.toCeilMinutes(naiveIntervalMs));
            long MAX_RANGE_MS = 157680000000L;
            if (rangeMs > 157680000000L) {
                this.logger.warn("Range ({}) exceeds max allowed ({}); clamping.", (Object)rangeMs, (Object)157680000000L);
                rangeMs = 157680000000L;
            }
            this.refineGap(initBucketMins, -1, baseFilter, listener, 1L, ChronoUnit.MINUTES, TS_FIELD, 0, minMs, maxMs);
        }, e -> {
            this.logger.error(e.getMessage(), (Throwable)e);
            listener.onFailure(e);
        });
        this.clientUtil.asyncRequestWithInjectedSecurity(boundsReq, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, this.context, boundsRequestListener);
    }

    public void refineGap(long bucketMins, int zoomDir, BoolQueryBuilder baseFilter, ActionListener<IntervalTimeConfiguration> listener, long minBucketMins, ChronoUnit returnUnit, String tsField, int depth, long sliceMinMs, long sliceMaxMs) {
        if (depth > 10) {
            this.runAutoDate(baseFilter, listener, returnUnit, tsField);
            return;
        }
        BoolQueryBuilder filter = new BoolQueryBuilder();
        filter.must((QueryBuilder)baseFilter);
        long sliceRange = sliceMaxMs - sliceMinMs;
        long bucketMs = TimeUnit.MINUTES.toMillis(bucketMins);
        if (bucketMs > 0L && sliceRange / bucketMs > 256L) {
            long windowMs = bucketMs * 256L;
            long sliceStart = sliceMaxMs - windowMs;
            filter.filter((QueryBuilder)QueryBuilders.rangeQuery((String)tsField).gte((Object)sliceStart).format("epoch_millis"));
        }
        SearchSourceBuilder src = new SearchSourceBuilder().size(0).query((QueryBuilder)filter);
        DateHistogramAggregationBuilder hist = ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"dyn").field(tsField)).fixedInterval(new DateHistogramInterval(bucketMins + "m")).minDocCount(0L);
        hist.subAggregation((AggregationBuilder)AggregationBuilders.min((String)"first_ts").field(tsField));
        src.aggregation((AggregationBuilder)hist);
        SearchRequest searchRequest = new SearchRequest(this.config.getIndices().toArray(new String[0])).source(src);
        this.logger.debug("Minimum interval search request: {}", (Object)searchRequest);
        ActionListener minIntervalSearchListener = ActionListener.wrap(r -> {
            long nextBucketMins;
            this.logger.debug("Minimum interval search response: {}", r);
            double gap = Double.NaN;
            boolean hasEmptyBuckets = false;
            Histogram histogram = (Histogram)r.getAggregations().get("dyn");
            if (histogram != null) {
                List timestamps;
                int i;
                List buckets = histogram.getBuckets();
                int firstNonEmpty = -1;
                int lastNonEmpty = -1;
                for (i = 0; i < buckets.size(); ++i) {
                    if (((Histogram.Bucket)buckets.get(i)).getDocCount() <= 0L) continue;
                    if (firstNonEmpty == -1) {
                        firstNonEmpty = i;
                    }
                    lastNonEmpty = i;
                }
                if (firstNonEmpty != -1) {
                    for (i = firstNonEmpty + 1; i < lastNonEmpty; ++i) {
                        if (((Histogram.Bucket)buckets.get(i)).getDocCount() != 0L) continue;
                        hasEmptyBuckets = true;
                        break;
                    }
                }
                if ((timestamps = buckets.stream().filter(bucket -> bucket.getDocCount() > 0L).map(bucket -> (Min)bucket.getAggregations().get("first_ts")).filter(min -> min != null && Double.isFinite(min.getValue())).map(min -> (long)min.getValue()).collect(Collectors.toList())).size() >= 2) {
                    ArrayList<Long> gaps = new ArrayList<Long>();
                    for (int i2 = 1; i2 < timestamps.size(); ++i2) {
                        long currentGap = (Long)timestamps.get(i2) - (Long)timestamps.get(i2 - 1);
                        if (currentGap <= 0L) continue;
                        gaps.add(currentGap);
                    }
                    if (!gaps.isEmpty()) {
                        gaps.sort(null);
                        int size = gaps.size();
                        int middle = size / 2;
                        if (size % 2 == 1) {
                            gap = ((Long)gaps.get(middle)).longValue();
                        } else if (size > 0) {
                            gap = (double)((Long)gaps.get(middle - 1) + (Long)gaps.get(middle)) / 2.0;
                        }
                    }
                }
            }
            long gapMins = this.toCeilMinutes(gap);
            if (!Double.isNaN(gap) && gap > 0.0 && (double)gapMins > (double)bucketMins / 2.0 && (double)gapMins < (double)bucketMins * 2.0) {
                listener.onResponse((Object)new IntervalTimeConfiguration(Math.max(1L, gapMins), returnUnit));
                return;
            }
            int nextDir = zoomDir;
            if (zoomDir < 0) {
                if (hasEmptyBuckets || bucketMins <= minBucketMins) {
                    nextDir = 1;
                    nextBucketMins = bucketMins * 2L;
                } else {
                    nextBucketMins = bucketMins / 2L;
                    if (nextBucketMins < minBucketMins) {
                        nextBucketMins = minBucketMins;
                    }
                }
            } else {
                nextBucketMins = bucketMins * 2L;
            }
            this.refineGap(nextBucketMins, nextDir, baseFilter, listener, minBucketMins, returnUnit, tsField, depth + 1, sliceMinMs, sliceMaxMs);
        }, e -> {
            this.logger.error(e.getMessage(), (Throwable)e);
            listener.onFailure(e);
        });
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, this.context, minIntervalSearchListener);
    }

    public void runAutoDate(BoolQueryBuilder filter, ActionListener<IntervalTimeConfiguration> listener, ChronoUnit unit, String tsField) {
        AutoDateHistogramAggregationBuilder adh = ((AutoDateHistogramAggregationBuilder)new AutoDateHistogramAggregationBuilder("auto").field(tsField)).setNumBuckets(256);
        adh.subAggregation((AggregationBuilder)AggregationBuilders.min((String)"first").field(tsField));
        adh.subAggregation((PipelineAggregationBuilder)PipelineAggregatorBuilders.diff((String)"gap", (String)"first").lag(1).gapPolicy(BucketHelpers.GapPolicy.SKIP));
        SearchSourceBuilder src = new SearchSourceBuilder().size(0).query((QueryBuilder)filter).aggregation((AggregationBuilder)adh).aggregation((PipelineAggregationBuilder)PipelineAggregatorBuilders.minBucket((String)"shortest", (String)"auto>gap"));
        SearchRequest searchRequest = new SearchRequest(this.config.getIndices().toArray(new String[0])).source(src);
        ActionListener autoDateSearchListener = ActionListener.wrap(r -> {
            NumericMetricsAggregation.SingleValue v = (NumericMetricsAggregation.SingleValue)r.getAggregations().get("shortest");
            if (v == null || Double.isNaN(v.value())) {
                listener.onResponse(null);
                return;
            }
            long mins = this.toCeilMinutes(v.value());
            if (mins > 0L) {
                listener.onResponse((Object)new IntervalTimeConfiguration(mins, unit));
            } else {
                listener.onResponse(null);
            }
        }, e -> {
            this.logger.error(e.getMessage(), (Throwable)e);
            listener.onFailure(e);
        });
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, this.context, autoDateSearchListener);
    }

    private long toCeilMinutes(double milliseconds) {
        if (milliseconds <= 0.0) {
            return 0L;
        }
        double minutes = milliseconds / (double)TimeUnit.MINUTES.toMillis(1L);
        return (long)Math.ceil(minutes);
    }

    private static long nextPowerOfTwo(long n) {
        --n;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        n |= n >>> 32;
        return n + 1L;
    }

    private static int nextNiceInterval(int currentMin) {
        for (int step : INTERVAL_LADDER) {
            if (step <= currentMin) continue;
            return step;
        }
        return (int)IntervalCalculation.nextPowerOfTwo(currentMin);
    }

    public class IntervalRecommendationListener
    implements ActionListener<SearchResponse> {
        private final ActionListener<IntervalTimeConfiguration> intervalListener;
        IntervalTimeConfiguration currentIntervalToTry;
        private final long expirationEpochMs;
        private LongBounds currentTimeStampBounds;
        private int attempts = 1;

        public IntervalRecommendationListener(ActionListener<IntervalTimeConfiguration> intervalListener, IntervalTimeConfiguration currentIntervalToTry, long expirationEpochMs, LongBounds timeStampBounds) {
            this.intervalListener = intervalListener;
            this.currentIntervalToTry = currentIntervalToTry;
            this.expirationEpochMs = expirationEpochMs;
            this.currentTimeStampBounds = timeStampBounds;
        }

        public void onResponse(SearchResponse resp) {
            IntervalCalculation.this.logger.debug("interval explorer response: {}", (Object)resp);
            try {
                long shingles = IntervalCalculation.this.aggregationPrep.getShingleCount(resp);
                IntervalCalculation.this.logger.debug("number of shingles: {}", (Object)shingles);
                if (shingles >= 32L) {
                    this.intervalListener.onResponse((Object)this.currentIntervalToTry);
                    return;
                }
                if (++this.attempts > 10) {
                    IntervalCalculation.this.logger.debug("number of attempts: {}", (Object)this.attempts);
                    this.intervalListener.onResponse(null);
                    return;
                }
                long nowMillis = IntervalCalculation.this.clock.millis();
                if (nowMillis > this.expirationEpochMs) {
                    IntervalCalculation.this.logger.debug("Timed out: now={}, expires={}", (Object)nowMillis, (Object)this.expirationEpochMs);
                    this.intervalListener.onFailure((Exception)new ValidationException(CommonMessages.TIMEOUT_ON_INTERVAL_REC, ValidationIssueType.TIMEOUT, ValidationAspect.MODEL));
                    return;
                }
                int nextMin = IntervalCalculation.nextNiceInterval((int)this.currentIntervalToTry.getInterval());
                if ((long)nextMin <= this.currentIntervalToTry.getInterval()) {
                    IntervalCalculation.this.logger.debug("Cannot grow interval further: next={}, current={}", (Object)nextMin, (Object)this.currentIntervalToTry.getInterval());
                    this.intervalListener.onResponse(null);
                    return;
                }
                this.searchWithDifferentInterval(nextMin);
            }
            catch (Exception e) {
                this.onFailure(e);
            }
        }

        private void searchWithDifferentInterval(int newIntervalMinuteValue) {
            this.currentIntervalToTry = new IntervalTimeConfiguration(newIntervalMinuteValue, ChronoUnit.MINUTES);
            this.currentTimeStampBounds = IntervalCalculation.this.aggregationPrep.getTimeRangeBounds(this.currentIntervalToTry, IntervalCalculation.this.endMillis, IntervalCalculation.this.lookBackWindows);
            SearchRequest searchRequest = IntervalCalculation.this.aggregationPrep.createSearchRequest(this.currentIntervalToTry, this.currentTimeStampBounds, IntervalCalculation.this.topEntity, 0);
            IntervalCalculation.this.logger.debug("next search request: {}", (Object)searchRequest);
            IntervalCalculation.this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)IntervalCalculation.this.client).search(arg_0, arg_1), IntervalCalculation.this.user, IntervalCalculation.this.client, IntervalCalculation.this.context, this);
        }

        public void onFailure(Exception e) {
            IntervalCalculation.this.logger.error("Failed to recommend new interval", (Throwable)e);
            this.intervalListener.onFailure((Exception)new ValidationException(CommonMessages.MODEL_VALIDATION_FAILED_UNEXPECTEDLY, ValidationIssueType.AGGREGATION, ValidationAspect.MODEL));
        }
    }
}

