/**
 * ./src/lib/select_filesystem_type.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import inquirer from 'inquirer';
import yaml from 'js-yaml';
import fs from 'node:fs';
import Pacman from '../../classes/pacman.js';
export default async function selectFileSystemType() {
    let partitions = {};
    if (fs.existsSync('/etc/calamares/modules/partition.conf')) {
        partitions = yaml.load(fs.readFileSync('/etc/calamares/modules/partition.conf', 'utf8'));
    }
    else {
        partitions.defaultFileSystemType = 'ext4';
    }
    const choices = ['ext4'];
    if (Pacman.packageIsInstalled('progs') ||
        Pacman.packageIsInstalled('btrfsprogs')) {
        choices.push('btrfs');
    }
    partitions.defaultFileSystemType = 'ext4';
    const questions = [
        {
            choices: choices,
            default: partitions.defaultFileSystemType,
            message: 'Select file system type',
            name: 'fileSystemChoices',
            type: 'list'
        }
    ];
    return new Promise((resolve) => {
        inquirer.prompt(questions).then((options) => {
            resolve(options.fileSystemChoices);
        });
    });
}
