"use strict";
/// <reference types="@volar/typescript" />
Object.defineProperty(exports, "__esModule", { value: true });
exports.isRefAtLocation = isRefAtLocation;
const language_core_1 = require("@vue/language-core");
function isRefAtLocation(ts, language, program, sourceScript, virtualCode, position, isTsPlugin) {
    const serviceScript = sourceScript.generated.languagePlugin.typescript?.getServiceScript(virtualCode);
    if (!serviceScript) {
        return false;
    }
    let mapped = false;
    for (const [_sourceScript, map] of language.maps.forEach(serviceScript.code)) {
        for (const [position2, mapping] of map.toGeneratedLocation(position)) {
            if ((0, language_core_1.isCompletionEnabled)(mapping.data)) {
                position = position2;
                mapped = true;
                break;
            }
        }
        if (mapped) {
            break;
        }
    }
    if (!mapped) {
        return false;
    }
    position += isTsPlugin ? sourceScript.snapshot.getLength() : 0;
    const sourceFile = program.getSourceFile(virtualCode.fileName);
    if (!sourceFile) {
        return false;
    }
    const node = findPositionIdentifier(sourceFile, sourceFile, position);
    if (!node) {
        return false;
    }
    const checker = program.getTypeChecker();
    const type = checker.getTypeAtLocation(node);
    const props = type.getProperties();
    return props.some(prop => prop.escapedName === 'value' && prop.flags & ts.SymbolFlags.Accessor);
    function findPositionIdentifier(sourceFile, node, offset) {
        let result;
        node.forEachChild(child => {
            if (!result) {
                if (child.end === offset && ts.isIdentifier(child)) {
                    result = child;
                }
                else if (child.end >= offset && child.getStart(sourceFile) < offset) {
                    result = findPositionIdentifier(sourceFile, child, offset);
                }
            }
        });
        return result;
    }
}
//# sourceMappingURL=isRefAtLocation.js.map