/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Register definitions for TI BQ257XX
 * Copyright (C) 2020 Texas Instruments Incorporated - http://www.ti.com/
 */

#define BQ25703_CHARGE_OPTION_0			0x00
#define BQ25703_CHARGE_CURRENT			0x02
#define BQ25703_MAX_CHARGE_VOLT			0x04
#define BQ25703_OTG_VOLT			0x06
#define BQ25703_OTG_CURRENT			0x08
#define BQ25703_INPUT_VOLTAGE			0x0a
#define BQ25703_MIN_VSYS			0x0c
#define BQ25703_IIN_HOST			0x0e
#define BQ25703_CHARGER_STATUS			0x20
#define BQ25703_PROCHOT_STATUS			0x22
#define BQ25703_IIN_DPM				0x24
#define BQ25703_ADCIBAT_CHG			0x28
#define BQ25703_ADCIINCMPIN			0x2a
#define BQ25703_ADCVSYSVBAT			0x2c
#define BQ25703_MANUFACT_DEV_ID			0x2e
#define BQ25703_CHARGE_OPTION_1			0x30
#define BQ25703_CHARGE_OPTION_2			0x32
#define BQ25703_CHARGE_OPTION_3			0x34
#define BQ25703_ADC_OPTION			0x3a

#define BQ25703_EN_LWPWR			BIT(15)
#define BQ25703_WDTMR_ADJ_MASK			GENMASK(14, 13)
#define BQ25703_WDTMR_DISABLE			0
#define BQ25703_WDTMR_5_SEC			1
#define BQ25703_WDTMR_88_SEC			2
#define BQ25703_WDTMR_175_SEC			3

#define BQ25703_ICHG_MASK			GENMASK(12, 6)
#define BQ25703_ICHG_STEP_UA			64000
#define BQ25703_ICHG_MIN_UA			64000
#define BQ25703_ICHG_MAX_UA			8128000

#define BQ25703_MAX_CHARGE_VOLT_MASK		GENMASK(15, 4)
#define BQ25703_VBATREG_STEP_UV			16000
#define BQ25703_VBATREG_MIN_UV			1024000
#define BQ25703_VBATREG_MAX_UV			19200000

#define BQ25703_OTG_VOLT_MASK			GENMASK(13, 6)
#define BQ25703_OTG_VOLT_STEP_UV		64000
#define BQ25703_OTG_VOLT_MIN_UV			4480000
#define BQ25703_OTG_VOLT_MAX_UV			20800000
#define BQ25703_OTG_VOLT_NUM_VOLT		256

#define BQ25703_OTG_CUR_MASK			GENMASK(14, 8)
#define BQ25703_OTG_CUR_STEP_UA			50000
#define BQ25703_OTG_CUR_MAX_UA			6350000

#define BQ25703_MINVSYS_MASK			GENMASK(13, 8)
#define BQ25703_MINVSYS_STEP_UV			256000
#define BQ25703_MINVSYS_MIN_UV			1024000
#define BQ25703_MINVSYS_MAX_UV			16128000

#define BQ25703_STS_AC_STAT			BIT(15)
#define BQ25703_STS_IN_FCHRG			BIT(10)
#define BQ25703_STS_IN_PCHRG			BIT(9)
#define BQ25703_STS_FAULT_ACOV			BIT(7)
#define BQ25703_STS_FAULT_BATOC			BIT(6)
#define BQ25703_STS_FAULT_ACOC			BIT(5)

#define BQ25703_IINDPM_MASK			GENMASK(14, 8)
#define BQ25703_IINDPM_STEP_UA			50000
#define BQ25703_IINDPM_MIN_UA			50000
#define BQ25703_IINDPM_MAX_UA			6400000
#define BQ25703_IINDPM_DEFAULT_UA		3300000
#define BQ25703_IINDPM_OFFSET_UA		50000

#define BQ25703_ADCIBAT_DISCHG_MASK		GENMASK(6, 0)
#define BQ25703_ADCIBAT_CHG_MASK		GENMASK(14, 8)
#define BQ25703_ADCIBAT_CHG_STEP_UA		64000
#define BQ25703_ADCIBAT_DIS_STEP_UA		256000

#define BQ25703_ADCIIN				GENMASK(15, 8)
#define BQ25703_ADCIINCMPIN_STEP		50000

#define BQ25703_ADCVSYS_MASK			GENMASK(15, 8)
#define BQ25703_ADCVBAT_MASK			GENMASK(7, 0)
#define BQ25703_ADCVSYSVBAT_OFFSET_UV		2880000
#define BQ25703_ADCVSYSVBAT_STEP		64000

#define BQ25703_ADC_CH_MASK			GENMASK(7, 0)
#define BQ25703_ADC_CONV_EN			BIT(15)
#define BQ25703_ADC_START			BIT(14)
#define BQ25703_ADC_FULL_SCALE			BIT(13)
#define BQ25703_ADC_CMPIN_EN			BIT(7)
#define BQ25703_ADC_VBUS_EN			BIT(6)
#define BQ25703_ADC_PSYS_EN			BIT(5)
#define BQ25703_ADC_IIN_EN			BIT(4)
#define BQ25703_ADC_IDCHG_EN			BIT(3)
#define BQ25703_ADC_ICHG_EN			BIT(2)
#define BQ25703_ADC_VSYS_EN			BIT(1)
#define BQ25703_ADC_VBAT_EN			BIT(0)

#define BQ25703_EN_OTG_MASK			BIT(12)

struct bq257xx_device {
	struct i2c_client *client;
	struct regmap *regmap;
};
