import { findNodeAtOffset, getIdentifierText } from "../../checker.js";
import { getStart } from "../util.js";
export function create(statements, below) {
    const first = statements[0];
    const from = getIdentifierText(first.source.id);
    const title = below
        ? `Convert edges below from "${from}" to subgraph`
        : `Convert edges from "${from}" to subgraph`;
    return {
        title,
        command: "DOT.consolidateDescendants",
        arguments: statements.map(s => s.pos),
    };
}
export function execute(doc, sourceFile, cmd) {
    if (!isConsolidateDescendantsCommand(cmd))
        return undefined;
    const g = sourceFile.graph;
    if (!g)
        return undefined;
    const candidateIndexes = cmd.arguments;
    const candidates = candidateIndexes.map(i => findNodeAtOffset(g, i).parent.parent);
    const first = candidates.shift();
    const from = getIdentifierText(first.source.id);
    const edits = [];
    const firstRight = first.rhs[0];
    const firstRightTargetStart = getStart(sourceFile, firstRight.target);
    const firstRightTargetEnd = firstRight.target.end;
    const contents = [sourceFile.content.substring(firstRightTargetStart, firstRightTargetEnd)];
    for (const descendant of candidates) {
        const rightItem = descendant.rhs[0];
        const rightItemTarget = rightItem.target;
        const rightItemTargetStart = rightItemTarget.pos;
        const rightItemTargetEnd = rightItem.target.end;
        const rightItemContent = sourceFile.content.substring(rightItemTargetStart, rightItemTargetEnd);
        edits.push({
            newText: "",
            range: {
                start: doc.positionAt(descendant.pos),
                end: doc.positionAt(rightItemTargetStart),
            },
        });
        edits.push({
            newText: "",
            range: {
                start: doc.positionAt(rightItemTargetStart),
                end: doc.positionAt(rightItemTargetEnd),
            },
        });
        if (descendant.terminator !== undefined) {
            edits.push({
                newText: "",
                range: {
                    start: doc.positionAt(getStart(sourceFile, descendant.terminator)),
                    end: doc.positionAt(descendant.terminator.end),
                },
            });
        }
        contents.push(rightItemContent);
    }
    const toInsert = `{ ${contents.map(s => s.trim()).join(" ")} }`;
    edits.push({
        newText: toInsert,
        range: {
            start: doc.positionAt(firstRightTargetStart),
            end: doc.positionAt(firstRightTargetEnd),
        },
    });
    return {
        label: `Convert edges from "${from}" to subgraph.`,
        edit: {
            changes: {
                [doc.uri]: edits,
            },
        },
    };
}
function isConsolidateDescendantsCommand(cmd) {
    return (cmd.command === "DOT.consolidateDescendants" &&
        !!cmd.arguments &&
        cmd.arguments.length > 1);
}
//# sourceMappingURL=ConsolidateDescendantsCommand.js.map