/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.extract;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.TimeZone;
import tim.prune.function.filesleuth.data.LocationFilter;
import tim.prune.function.filesleuth.data.TrackContents;
import tim.prune.function.filesleuth.extract.ContentExtractor;

public class TextFileExtractor
implements ContentExtractor {
    private final File _file;

    public TextFileExtractor(File file) {
        this._file = file;
    }

    @Override
    public TrackContents getContents(TimeZone timeZone) {
        TrackContents trackContents = new TrackContents(timeZone);
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this._file));){
                bufferedReader.lines().forEach(string -> this.processLine((String)string, trackContents));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return trackContents;
    }

    private void processLine(String string, TrackContents trackContents) {
        if (string == null) {
            return;
        }
        String string2 = string.trim();
        if (string2.equals("")) {
            return;
        }
        String[] stringArray = string2.split("[,;\\t]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray[n2];
            if (TextFileExtractor.looksLikeWord(string3)) {
                trackContents.addString(string3);
            }
            ++n2;
        }
    }

    private static boolean looksLikeWord(String string) {
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            if (Character.isAlphabetic(string.charAt(n))) {
                if (bl) {
                    return true;
                }
                bl = true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean matchesFilter(LocationFilter locationFilter) {
        return false;
    }
}

