/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the inverse of a displacement field.


IterativeInverseDisplacementFieldImageFilter takes a displacement field as input and computes the displacement
field that is its inverse. If the input displacement field was mapping
coordinates from a space A into a space B, the output of this filter
will map coordinates from the space B into the space A.

The algorithm implemented in this filter uses an iterative method for
progressively refining the values of the inverse field. Starting from
the direct field, at every pixel the direct mapping of this point is
found, and a the negative of the current displacement is stored in the
inverse field at the nearest pixel. Then, subsequent iterations verify
if any of the neighbor pixels provide a better return to the current
pixel, in which case its value is taken for updating the vector in the
inverse field.

This method was discussed in the users-list during February 2004.


Corinne Mattmann

See:
 itk::simple::IterativeInverseDisplacementField for the procedural interface

 itk::IterativeInverseDisplacementFieldImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkIterativeInverseDisplacementFieldImageFilter.h
*/
public class IterativeInverseDisplacementFieldImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected IterativeInverseDisplacementFieldImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.IterativeInverseDisplacementFieldImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(IterativeInverseDisplacementFieldImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(IterativeInverseDisplacementFieldImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::IterativeInverseDisplacementFieldImageFilter::~IterativeInverseDisplacementFieldImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_IterativeInverseDisplacementFieldImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::IterativeInverseDisplacementFieldImageFilter::IterativeInverseDisplacementFieldImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  IterativeInverseDisplacementFieldImageFilter() {
    this(SimpleITKJNI.new_IterativeInverseDisplacementFieldImageFilter(), true);
  }

  /**
Self&amp; itk::simple::IterativeInverseDisplacementFieldImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.IterativeInverseDisplacementFieldImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::IterativeInverseDisplacementFieldImageFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.IterativeInverseDisplacementFieldImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IterativeInverseDisplacementFieldImageFilter::SetStopValue(double StopValue)
*/
public  void setStopValue(double StopValue) {
    SimpleITKJNI.IterativeInverseDisplacementFieldImageFilter_setStopValue(swigCPtr, this, StopValue);
  }

  /**
double itk::simple::IterativeInverseDisplacementFieldImageFilter::GetStopValue() const
*/
public  double getStopValue() {
    return SimpleITKJNI.IterativeInverseDisplacementFieldImageFilter_getStopValue(swigCPtr, this);
  }

  /**
std::string itk::simple::IterativeInverseDisplacementFieldImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.IterativeInverseDisplacementFieldImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::IterativeInverseDisplacementFieldImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.IterativeInverseDisplacementFieldImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::IterativeInverseDisplacementFieldImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.IterativeInverseDisplacementFieldImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
