/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.io.Closeable;
import java.util.List;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerInterceptors<K, V>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ProducerInterceptors.class);
    private final List<Plugin<ProducerInterceptor<K, V>>> interceptorPlugins;

    public ProducerInterceptors(List<ProducerInterceptor<K, V>> interceptors, Metrics metrics) {
        this.interceptorPlugins = Plugin.wrapInstances(interceptors, metrics, "interceptor.classes");
    }

    public ProducerRecord<K, V> onSend(ProducerRecord<K, V> record) {
        ProducerRecord<K, V> interceptRecord = record;
        for (Plugin<ProducerInterceptor<K, V>> interceptorPlugin : this.interceptorPlugins) {
            try {
                interceptRecord = interceptorPlugin.get().onSend(interceptRecord);
            }
            catch (Exception e) {
                if (record != null) {
                    log.warn("Error executing interceptor onSend callback for topic: {}, partition: {}", new Object[]{record.topic(), record.partition(), e});
                    continue;
                }
                log.warn("Error executing interceptor onSend callback", (Throwable)e);
            }
        }
        return interceptRecord;
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception, Headers headers) {
        for (Plugin<ProducerInterceptor<K, V>> interceptorPlugin : this.interceptorPlugins) {
            try {
                interceptorPlugin.get().onAcknowledgement(metadata, exception, headers);
            }
            catch (Exception e) {
                log.warn("Error executing interceptor onAcknowledgement callback", (Throwable)e);
            }
        }
    }

    public void onSendError(ProducerRecord<K, V> record, TopicPartition interceptTopicPartition, Exception exception) {
        for (Plugin<ProducerInterceptor<K, V>> interceptorPlugin : this.interceptorPlugins) {
            try {
                Headers headers;
                Headers headers2 = headers = record != null ? record.headers() : new RecordHeaders();
                if (headers instanceof RecordHeaders && !((RecordHeaders)headers).isReadOnly()) {
                    RecordHeaders recordHeaders = (RecordHeaders)headers;
                    headers = new RecordHeaders(recordHeaders);
                    ((RecordHeaders)headers).setReadOnly();
                }
                if (record == null && interceptTopicPartition == null) {
                    interceptorPlugin.get().onAcknowledgement(null, exception, headers);
                    continue;
                }
                if (interceptTopicPartition == null) {
                    interceptTopicPartition = ProducerInterceptors.extractTopicPartition(record);
                }
                interceptorPlugin.get().onAcknowledgement(new RecordMetadata(interceptTopicPartition, -1L, -1, -1L, -1, -1), exception, headers);
            }
            catch (Exception e) {
                log.warn("Error executing interceptor onAcknowledgement callback", (Throwable)e);
            }
        }
    }

    public static <K, V> TopicPartition extractTopicPartition(ProducerRecord<K, V> record) {
        return new TopicPartition(record.topic(), record.partition() == null ? -1 : record.partition());
    }

    @Override
    public void close() {
        for (Plugin<ProducerInterceptor<K, V>> interceptorPlugin : this.interceptorPlugins) {
            try {
                interceptorPlugin.close();
            }
            catch (Exception e) {
                log.error("Failed to close producer interceptor ", (Throwable)e);
            }
        }
    }
}

