/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.keycloak.common.util.NetworkUtils;

public class HostUtils {
    public static String getHostName() {
        return HostUtils.getHostNameImpl().trim().toLowerCase();
    }

    public static String getIpAddress() {
        try {
            String hostname = HostUtils.getHostName();
            return InetAddress.getByName(hostname).getHostAddress();
        }
        catch (UnknownHostException uhe) {
            throw new IllegalStateException(uhe);
        }
    }

    private static String getHostNameImpl() {
        String bindAddr = System.getProperty("jboss.bind.address");
        if (bindAddr != null && !bindAddr.trim().equals("0.0.0.0")) {
            return bindAddr;
        }
        String qualifiedHostName = System.getProperty("jboss.qualified.host.name");
        if (qualifiedHostName != null) {
            return qualifiedHostName;
        }
        qualifiedHostName = System.getenv("HOSTNAME");
        if (qualifiedHostName != null) {
            return qualifiedHostName;
        }
        qualifiedHostName = System.getenv("COMPUTERNAME");
        if (qualifiedHostName != null) {
            return qualifiedHostName;
        }
        try {
            return NetworkUtils.canonize(HostUtils.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
            return "unknown-host.unknown-domain";
        }
    }

    private static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            addr = InetAddress.getByName(null);
        }
        return addr;
    }
}

