/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.ShortDescriptionProvider;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.FalseFriendRuleHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FalseFriendRuleLoader
extends DefaultHandler {
    private final String falseFriendHint;
    private final String falseFriendSugg;
    private final boolean inTestMode;

    public FalseFriendRuleLoader(Language motherTongue) {
        this(motherTongue, false);
    }

    public FalseFriendRuleLoader(Language motherTongue, boolean inTestMode) {
        ResourceBundle messages = JLanguageTool.getDataBroker().getResourceBundle("org.languagetool.MessagesBundle", motherTongue.getLocale());
        this.falseFriendHint = messages.getString("false_friend_hint");
        this.falseFriendSugg = messages.getString("false_friend_suggestion");
        this.inTestMode = inTestMode;
    }

    public FalseFriendRuleLoader(String falseFriendHint, String falseFriendSugg) {
        this.falseFriendHint = Objects.requireNonNull(falseFriendHint);
        this.falseFriendSugg = Objects.requireNonNull(falseFriendSugg);
        this.inTestMode = false;
    }

    public final List<AbstractPatternRule> getRules(File file, Language language, Language motherTongue) throws IOException {
        List<AbstractPatternRule> list;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            list = this.getRules(inputStream, language, motherTongue);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new IOException("Could not load false friend rules from " + file, e);
            }
        }
        ((InputStream)inputStream).close();
        return list;
    }

    public final List<AbstractPatternRule> getRules(InputStream stream, Language textLanguage, Language motherTongue) throws ParserConfigurationException, SAXException, IOException {
        FalseFriendRuleHandler handler = new FalseFriendRuleHandler(textLanguage, motherTongue, this.falseFriendHint, this.inTestMode);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.getXMLReader().setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        saxParser.parse(stream, (DefaultHandler)handler);
        List<AbstractPatternRule> rules = handler.getRules();
        ArrayList<AbstractPatternRule> filteredRules = new ArrayList<AbstractPatternRule>();
        MessageFormat msgFormat = new MessageFormat(this.falseFriendSugg);
        ShortDescriptionProvider descProvider = new ShortDescriptionProvider();
        for (AbstractPatternRule rule : rules) {
            String patternStr = rule.getPatternTokens().stream().map(k -> k.getString()).collect(Collectors.joining(" "));
            List<String> suggestions = handler.getSuggestionMap().get(rule.getId());
            if (suggestions == null) continue;
            ArrayList<CallSite> formattedSuggestions = new ArrayList<CallSite>();
            for (String suggestion : suggestions) {
                if (patternStr.equalsIgnoreCase(suggestion)) continue;
                String desc = descProvider.getShortDescription(suggestion, textLanguage);
                if (desc != null) {
                    formattedSuggestions.add((CallSite)((Object)("<suggestion>" + suggestion + "</suggestion> (" + desc + ")")));
                    continue;
                }
                formattedSuggestions.add((CallSite)((Object)("<suggestion>" + suggestion + "</suggestion>")));
            }
            if (formattedSuggestions.size() <= 0) continue;
            String joined = String.join((CharSequence)", ", formattedSuggestions);
            rule.setMessage(rule.getMessage() + " " + msgFormat.format(new String[]{joined}));
            filteredRules.add(rule);
        }
        return filteredRules;
    }
}

