/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.OracleShardingKey;
import oracle.ucp.routing.ShardingKeys;
import oracle.ucp.util.Pair;

class HashRangeShardingKeys
implements ShardingKeys {
    private final OracleShardingKey keyLowHash;
    private final OracleShardingKey keyHighHash;

    HashRangeShardingKeys(OracleShardingKey keyHighHash, OracleShardingKey keyLowHash) {
        this.keyLowHash = keyLowHash;
        this.keyHighHash = keyHighHash;
    }

    @Override
    public boolean contains(OracleShardingKey hashedKey) {
        return hashedKey.compareTo((Object)this.keyHighHash) < 0 && hashedKey.compareTo((Object)this.keyLowHash) >= 0;
    }

    public String toString() {
        return "{Low:" + this.keyLowHash + ", High:" + this.keyHighHash + "}";
    }

    public int hashCode() {
        return 31 * this.keyLowHash.hashCode() + this.keyHighHash.hashCode();
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (otherObj == this) {
            return true;
        }
        if (!(otherObj instanceof HashRangeShardingKeys)) {
            return false;
        }
        HashRangeShardingKeys otherKeys = (HashRangeShardingKeys)otherObj;
        return this.keyLowHash.equals(otherKeys.keyLowHash) && this.keyHighHash.equals(otherKeys.keyHighHash);
    }

    @Override
    public int compareTo(ShardingKeys other) {
        HashRangeShardingKeys otherKeys = (HashRangeShardingKeys)other;
        int lowCompare = this.keyLowHash.compareTo((Object)otherKeys.keyLowHash);
        if (lowCompare != 0) {
            return lowCompare;
        }
        return this.keyHighHash.compareTo((Object)otherKeys.keyHighHash);
    }

    List<ShardingKeys> split(OracleShardingKey boundaryHash) {
        ArrayList<ShardingKeys> splitKeys = new ArrayList<ShardingKeys>(2);
        splitKeys.add(new HashRangeShardingKeys(boundaryHash, this.keyLowHash));
        splitKeys.add(new HashRangeShardingKeys(this.keyHighHash, boundaryHash));
        return splitKeys;
    }

    @Override
    public List<Pair<OracleShardingKey, OracleShardingKey>> getKeys() {
        ArrayList<Pair<OracleShardingKey, OracleShardingKey>> pairs = new ArrayList<Pair<OracleShardingKey, OracleShardingKey>>();
        pairs.add(new Pair<OracleShardingKey, OracleShardingKey>(this.keyLowHash, this.keyHighHash));
        return pairs;
    }
}

