/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search;

import java.util.EnumSet;
import java.util.List;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.protobufs.SearchRequest;

public class IndicesOptionsProtoUtils {
    private IndicesOptionsProtoUtils() {
    }

    protected static IndicesOptions fromRequest(SearchRequest request, IndicesOptions defaultSettings) {
        return IndicesOptionsProtoUtils.fromProtoParameters(request, defaultSettings);
    }

    protected static IndicesOptions fromProtoParameters(SearchRequest request, IndicesOptions defaultSettings) {
        if (!(request.getExpandWildcardsCount() > 0 || request.hasIgnoreUnavailable() || request.hasAllowNoIndices() || request.hasIgnoreThrottled())) {
            return defaultSettings;
        }
        EnumSet<IndicesOptions.WildcardStates> wildcards = IndicesOptionsProtoUtils.parseProtoParameter(request.getExpandWildcardsList(), defaultSettings.getExpandWildcards());
        return IndicesOptions.fromOptions((boolean)(request.hasIgnoreUnavailable() ? request.getIgnoreUnavailable() : defaultSettings.ignoreUnavailable()), (boolean)(request.hasAllowNoIndices() ? request.getAllowNoIndices() : defaultSettings.allowNoIndices()), (boolean)wildcards.contains(IndicesOptions.WildcardStates.OPEN), (boolean)wildcards.contains(IndicesOptions.WildcardStates.CLOSED), (boolean)wildcards.contains(IndicesOptions.WildcardStates.HIDDEN), (boolean)defaultSettings.allowAliasesToMultipleIndices(), (boolean)defaultSettings.forbidClosedIndices(), (boolean)defaultSettings.ignoreAliases(), (boolean)(request.hasIgnoreThrottled() ? request.getIgnoreThrottled() : defaultSettings.ignoreThrottled()));
    }

    protected static EnumSet<IndicesOptions.WildcardStates> parseProtoParameter(List<SearchRequest.ExpandWildcard> wildcardList, EnumSet<IndicesOptions.WildcardStates> defaultStates) {
        if (wildcardList.isEmpty()) {
            return defaultStates;
        }
        EnumSet<IndicesOptions.WildcardStates> states = EnumSet.noneOf(IndicesOptions.WildcardStates.class);
        for (SearchRequest.ExpandWildcard wildcard : wildcardList) {
            IndicesOptionsProtoUtils.updateSetForValue(states, wildcard);
        }
        return states;
    }

    protected static void updateSetForValue(EnumSet<IndicesOptions.WildcardStates> states, SearchRequest.ExpandWildcard wildcard) {
        switch (wildcard) {
            case EXPAND_WILDCARD_OPEN: {
                states.add(IndicesOptions.WildcardStates.OPEN);
                break;
            }
            case EXPAND_WILDCARD_CLOSED: {
                states.add(IndicesOptions.WildcardStates.CLOSED);
                break;
            }
            case EXPAND_WILDCARD_HIDDEN: {
                states.add(IndicesOptions.WildcardStates.HIDDEN);
                break;
            }
            case EXPAND_WILDCARD_NONE: {
                states.clear();
                break;
            }
            case EXPAND_WILDCARD_ALL: {
                states.addAll(EnumSet.allOf(IndicesOptions.WildcardStates.class));
                break;
            }
            default: {
                throw new IllegalArgumentException("No valid expand wildcard value [" + String.valueOf(wildcard) + "]");
            }
        }
    }
}

