/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.iot;

import java.util.function.Consumer;
import software.amazon.awssdk.crt.iot.IncomingPublishEvent;
import software.amazon.awssdk.crt.iot.SubscriptionStatusEvent;

public class StreamingOperationOptions {
    String topic;
    Consumer<SubscriptionStatusEvent> subscriptionStatusEventCallback;
    Consumer<IncomingPublishEvent> incomingPublishEventCallback;

    public static StreamingOperationOptionsBuilder builder() {
        return new StreamingOperationOptionsBuilder();
    }

    private StreamingOperationOptions() {
    }

    private StreamingOperationOptions(StreamingOperationOptions options) {
        this.topic = options.topic;
        this.subscriptionStatusEventCallback = options.subscriptionStatusEventCallback;
        this.incomingPublishEventCallback = options.incomingPublishEventCallback;
    }

    public static class StreamingOperationOptionsBuilder {
        private final StreamingOperationOptions options = new StreamingOperationOptions();

        StreamingOperationOptionsBuilder() {
        }

        public StreamingOperationOptionsBuilder withTopic(String topic) {
            this.options.topic = topic;
            return this;
        }

        public StreamingOperationOptionsBuilder withSubscriptionStatusEventCallback(Consumer<SubscriptionStatusEvent> callback) {
            this.options.subscriptionStatusEventCallback = callback;
            return this;
        }

        public StreamingOperationOptionsBuilder withIncomingPublishEventCallback(Consumer<IncomingPublishEvent> callback) {
            this.options.incomingPublishEventCallback = callback;
            return this;
        }

        public StreamingOperationOptions build() {
            return new StreamingOperationOptions(this.options);
        }
    }
}

