/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.LatexDocumentFormat;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.NTriplesDocumentFormat;
import org.semanticweb.owlapi.formats.OBODocumentFormat;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.formats.RDFJsonLDDocumentFormat;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.formats.TurtleDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormat;

public class Extensions {
    private static final HashMap<OWLDocumentFormat, List<String>> format_extensions = new HashMap();

    public static List<String> getExtensions(OWLDocumentFormat fmt) {
        if (format_extensions.containsKey(fmt)) {
            return format_extensions.get(fmt);
        }
        return Arrays.asList(".owl");
    }

    public static List<String> getExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (List<String> exts : format_extensions.values()) {
            for (String ext : exts) {
                if (extensions.contains(ext)) continue;
                extensions.add(ext);
            }
        }
        return extensions;
    }

    static {
        format_extensions.put((OWLDocumentFormat)new RDFXMLDocumentFormat(), Arrays.asList(".rdf", ".xml"));
        format_extensions.put((OWLDocumentFormat)new TurtleDocumentFormat(), Arrays.asList(".ttl", ".turtle"));
        format_extensions.put((OWLDocumentFormat)new OWLXMLDocumentFormat(), Arrays.asList(".owx", ".xml", ".owl"));
        format_extensions.put((OWLDocumentFormat)new FunctionalSyntaxDocumentFormat(), Arrays.asList(".ofn"));
        format_extensions.put((OWLDocumentFormat)new ManchesterSyntaxDocumentFormat(), Arrays.asList(".omn"));
        format_extensions.put((OWLDocumentFormat)new OBODocumentFormat(), Arrays.asList(".obo"));
        format_extensions.put((OWLDocumentFormat)new LatexDocumentFormat(), Arrays.asList(".tex"));
        format_extensions.put((OWLDocumentFormat)new RDFJsonLDDocumentFormat(), Arrays.asList(".jsonld"));
        format_extensions.put((OWLDocumentFormat)new NTriplesDocumentFormat(), Arrays.asList(".nt", ".n3"));
    }
}

