from typing import Any, Callable, TypeVar, overload

class CData:
    def __getitem__(self, idx: int): ...
    # required for wl_list_for_each
    @property
    def next(self) -> CData: ...

class CDataArray:
    def __setitem__(self, idx: int, elem: CData) -> None: ...

class DispatcherFuncT: ...
class ResourceDestroyFuncT: ...
class NotifyFuncT: ...

# built-in cdata types
class CharCData(CData): ...

# wayland cdata types
class ClientCData(CData): ...
class DisplayCData(CData): ...
class EventLoopCData(CData): ...
class InterfaceCData(CData): ...
class ListCData(CData): ...

class ListenerCData(CData):
    link: ListCData
    notify: NotifyFuncT

class QueueCData(CData): ...
class ResourceCData(CData): ...

# custom cdata types
class ListenerContainerCData(CData):
    handle: CData
    destroy_listener: ListenerCData

_FuncType = Callable[..., Any]
_F = TypeVar("_F", bound=_FuncType)
_CDataT = TypeVar("_CDataT", bound=CData)

NULL: CData

@overload
def new(cdecl: str) -> CData: ...
@overload
def new(cdecl: str, init: Any) -> CDataArray: ...
def gc(
    cdata: _CDataT, destructor: None | Callable[[_CDataT], None], size: int = 0
) -> _CDataT: ...
def string(cdata: CharCData) -> str: ...
def release(cdata: CData) -> None: ...
def def_extern() -> Callable[[_F], _F]: ...
def new_handle(self: Any) -> CData: ...
def from_handle(cdata: CData) -> Any: ...
def cast(new_type: str, cdata: CData) -> CData: ...
def addressof(cdata: _CDataT) -> _CDataT: ...
