/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkClampImageFilter_h
#define sitkClampImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkDualImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkImageFilter.h"
#include "sitkDualMemberFunctionFactory.h"
#include "sitkBasicFilters.h"

namespace itk::simple {

    /**\class ClampImageFilter
\brief Casts input pixels to output pixel type and clamps the output pixel values to a specified range.

Default range corresponds to the range supported by the pixel type of the output image.

This filter is templated over the input image type and the output image type.

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.


\see UnaryFunctorImageFilter 


\see CastImageFilter
\sa itk::simple::Clamp for the procedural interface
\sa itk::ClampImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ClampImageFilter : public ImageFilter {
    public:
      using Self = ClampImageFilter;

      /** Destructor */
      virtual ~ClampImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ClampImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;

\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputPixelType ( PixelIDValueEnum OutputPixelType ) { this->m_OutputPixelType = OutputPixelType; return *this; }

      /**
       */
      PixelIDValueEnum GetOutputPixelType() const { return this->m_OutputPixelType; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetLowerBound ( double LowerBound ) { this->m_LowerBound = LowerBound; return *this; }

      /**
       */
      double GetLowerBound() const { return this->m_LowerBound; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUpperBound ( double UpperBound ) { this->m_UpperBound = UpperBound; return *this; }

      /**
       */
      double GetUpperBound() const { return this->m_UpperBound; }

      /** Name of this class */
      std::string GetName() const { return std::string ("ClampImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image&& image1 );
#endif
      Image Execute ( const Image& image1 );


    private:
      /** Setup for member function dispatching */
      using MemberFunctionType = Image (Self::*)( const Image& image1 );

      friend struct detail::DualExecuteInternalAddressor<MemberFunctionType>;
      template <class TImageType1, class TImageType2> Image DualExecuteInternal ( const Image& image1 );
      friend struct detail::DualExecuteInternalVectorAddressor<MemberFunctionType>;
      template <class TImageType1, class TImageType2> Image DualExecuteInternalVector ( const Image& image1 );

      std::unique_ptr<detail::DualMemberFunctionFactory<MemberFunctionType> > m_DualMemberFactory;



      PixelIDValueEnum  m_OutputPixelType{itk::simple::sitkUnknown};

      double  m_LowerBound{-std::numeric_limits<double>::max()};

      double  m_UpperBound{std::numeric_limits<double>::max()};


      bool m_InPlace{false};
    };

    /**\
     * \brief Casts input pixels to output pixel type and clamps the output pixel values to a specified range.
     *
     * This function directly calls the execute method of ClampImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ClampImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image Clamp ( Image&& image1, PixelIDValueEnum outputPixelType = itk::simple::sitkUnknown, double lowerBound = -std::numeric_limits<double>::max(), double upperBound = std::numeric_limits<double>::max() );
#endif
     SITKBasicFilters_EXPORT Image Clamp ( const Image& image1, PixelIDValueEnum outputPixelType = itk::simple::sitkUnknown, double lowerBound = -std::numeric_limits<double>::max(), double upperBound = std::numeric_limits<double>::max() );

     /** @} */
}
#endif
