/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils.counters;

import org.graalvm.visualvm.heapviewer.utils.counters.PrimitiveCounter;

public final class DoubleCounter
extends PrimitiveCounter {
    private int size;
    private final long[] keys;
    private final int[] counts;

    public DoubleCounter(int bufferSize) {
        bufferSize = bufferSize * 9 / 8;
        this.keys = new long[bufferSize];
        this.counts = new int[bufferSize];
    }

    public void count(double dkey) {
        int idx;
        long key = Double.doubleToRawLongBits(dkey);
        int index = idx = this.hash(key);
        while (this.keys[index] != key && this.counts[index] != 0) {
            if ((index = this.incIndex(index)) != idx) continue;
            throw new RuntimeException("Full when counting " + dkey);
        }
        if (this.counts[index] == 0) {
            this.keys[index] = key;
            ++this.size;
        }
        int n = index;
        this.counts[n] = this.counts[n] + 1;
    }

    @Override
    public void count(String value) {
        this.count(Double.parseDouble(value));
    }

    public Iterator iterator() {
        return new Iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    private int hash(long key) {
        return (int)Math.abs(key % (long)this.keys.length);
    }

    private int incIndex(int index) {
        return ++index < this.keys.length ? index : 0;
    }

    public final class Iterator
    implements java.util.Iterator<Record> {
        private int index;
        private int count;

        private Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < DoubleCounter.this.size;
        }

        @Override
        public Record next() {
            Record entry = new Record();
            entry.count = DoubleCounter.this.counts[this.index];
            while (entry.count == 0) {
                entry.count = DoubleCounter.this.counts[++this.index];
            }
            entry.value = DoubleCounter.this.keys[this.index++];
            ++this.count;
            return entry;
        }
    }

    public static final class Record
    extends PrimitiveCounter.Record {
        private long value;
        private int count;

        private Record() {
        }

        public double getPrimitive() {
            return Double.longBitsToDouble(this.value);
        }

        @Override
        public String getValue() {
            return Double.toString(this.getPrimitive());
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public int hashCode() {
            return Long.hashCode(this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            return this.value == ((Record)o).value;
        }
    }
}

